/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.Searcher;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.CustomFieldValue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
@LoginAs(user="admin")
public class TestIssueNavigator
extends BaseJiraFuncTest {
    private static final String CUSTOM_FIELD_GLOBAL = "global custom field";
    private static final String CUSTOM_FIELD_ISSUETYPE = "issueType only custom field";
    private static final String CUSTOM_FIELD_PROJECT = "project only custom field";
    private static final String CUSTOM_FIELD_ISSUETYPE_AND_PROJECT = "issue type & project custom field";
    private static final String PROJECT_DOG = "dog";
    private static final String PROJECT_HOMOSAP = "homosapien";
    private static final String homosapId = "10000";
    private static final Long homosapIdLong = 1000L;
    private static final String GROUP_NAME = "test group";
    private static final List<CustomFieldValue>[] cfValuesPerIssue = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
    private static final String issueKey = "HSP-1";
    private static final String issueKey2 = "HSP-2";
    private static final String issueKey3 = "HSP-3";
    private static final String issueKey4 = "HSP-4";
    private static final String customFieldIdSelectList = "10000";
    private static final String customFieldIdRadioButton = "10001";
    private static final String customFieldIdMultiSelect = "10002";
    private static final String customFieldIdCheckBox = "10003";
    private static final String customFieldIdTextField = "10004";
    private static final String customFieldIdUserPicker = "10005";
    private static final String customFieldIdDatePicker = "10006";
    private static final String CUSTOM_FIELD_SELECT = "Custom Field Select";
    private static final String CUSTOM_FIELD_RADIO = "Custom Field Radio";
    private static final String CUSTOM_FIELD_MULTI_SELECT = "Custom Field Multi Select";
    private static final String CUSTOM_FIELD_TEXTFIELD = "Custom Field Text Field";
    private static final String CUSTOM_FIELD_CHECKBOX = "Custom Field Check Box";
    private static final String CUSTOM_FIELD_USERPICKER = "Custom Field User Picker";
    private static final String CUSTOM_FIELD_DATEPICKER = "Custom Field Date Picker";
    private static final String[] customFieldNames = new String[]{"Custom Field Select", "Custom Field Radio", "Custom Field Text Field", "Custom Field Multi Select", "Custom Field Check Box", "Custom Field User Picker", "Custom Field Date Picker"};
    private static final String[] customFieldIds = new String[]{"10000", "10001", "10004", "10002", "10003", "10005", "10006"};
    @Inject
    private FuncTestLogger logger;
    @Inject
    private IssueTableAssertions issueTableAssertions;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    @Restore(value="TestIssueNavigatorSubtaskColumnView.xml")
    public void testSubtaskIssueNavigatorColumn() {
        this.navigation.login("admin", "admin");
        this.navigation.issueNavigator().createSearch("");
        this.textAssertions.assertTextPresent("HSP-5");
        this.textAssertions.assertTextPresent("HSP-6");
        this.logger.log((Object)"Successfully found subtask issue keys in the subtask issue navigator column");
    }

    @Test
    @Restore(value="TestIssueNavigatorColumnVisibilityForCustomFields.xml")
    public void testNavigatorColumnVisibilityForCustomFields() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String dogProjectId = "10010";
        this.navigation.issueNavigator().displayAllIssues();
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
        this.navigation.issueNavigator().createSearch("project=homosapien");
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
        this.navigation.issueNavigator().createSearch("project=homosapien AND issuetype= Bug");
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
        this.navigation.issueNavigator().createSearch("project=dog");
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
        this.navigation.issueNavigator().createSearch("project=dog AND issuetype= Bug");
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
        this.navigation.issueNavigator().createSearch("project in (10010, 10000)");
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
        this.navigation.issueNavigator().createSearch("project in (10010, 10000) AND issuetype= Bug");
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
    }

    @Test
    @Restore(value="TestIssueNavigatorProjectComponentsVisibility.xml")
    public void testJQLWarningShownForInvalidProject() {
        this.logger.log((Object)"Issue Navigator: Test project componenets visibility");
        this.issueTableAssertions.assertSearchWithError("project=99999", "A value with ID '99999' does not exist for the field 'project'.");
        this.issueTableAssertions.assertSearchWithErrors("project=99999 AND project=88888", Lists.newArrayList((Object[])new String[]{"A value with ID '99999' does not exist for the field 'project'.", "A value with ID '88888' does not exist for the field 'project'."}));
        this.issueTableAssertions.assertSearchWithErrors("project=99999 AND project=88888 AND project=10010", Lists.newArrayList((Object[])new String[]{"A value with ID '99999' does not exist for the field 'project'.", "A value with ID '88888' does not exist for the field 'project'."}));
    }

    @Test
    @Restore(value="TestIssueNavigatorCustomfieldVisibility.xml")
    public void testCustomfieldVisibility() {
        List<Searcher> searchers = this.backdoor.searchersClient().allSearchers("");
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_GLOBAL);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_ISSUETYPE);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_PROJECT);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
        searchers = this.backdoor.searchersClient().allSearchers("type=bug");
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_GLOBAL);
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_ISSUETYPE);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_PROJECT);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
        searchers = this.backdoor.searchersClient().allSearchers("project=10000");
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_GLOBAL);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_ISSUETYPE);
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_PROJECT);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
        searchers = this.backdoor.searchersClient().allSearchers("project=10000 and type=bug");
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_GLOBAL);
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_ISSUETYPE);
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_PROJECT);
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
    }

    private void assertSearcherPresent(List<Searcher> searchers, String name) {
        for (Searcher searcher : searchers) {
            if (!name.equals(searcher.getName())) continue;
            Assert.assertTrue((String)("Expected searcher with name " + name + " is shown"), (boolean)searcher.getShown());
            return;
        }
        Assert.fail((String)("Searcher with name " + name + " expected in response"));
    }

    private void assertSearcherNotPresent(List<Searcher> searchers, String name) {
        searchers.stream().filter(searcher -> name.equals(searcher.getName())).forEach(searcher -> Assert.assertFalse((String)("Expected searcher with name " + name + " is not shown"), (boolean)searcher.getShown()));
    }

    @Test
    @Restore(value="TestIssueNavigatorCommon.xml")
    public void testIssueNavigatorSortByCustomField() {
        this.logger.log((Object)"Issue Navigator: Test that the filter correctly orders issues for custom fields.");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().addColumnToIssueNavigator(customFieldNames);
        this.navigation.issueNavigator().displayAllIssues();
        for (int i = 0; i < customFieldIds.length; ++i) {
            this.logger.log((Object)("Sorting by " + customFieldNames[i]));
            this.navigation.issueNavigator().sortIssues("cf[" + customFieldIds[i] + "]", "ASC");
            this.textAssertions.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{issueKey, issueKey2, issueKey3, issueKey4});
            this.navigation.issueNavigator().sortIssues("cf[" + customFieldIds[i] + "]", "DESC");
            this.textAssertions.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{issueKey4, issueKey3, issueKey2, issueKey});
        }
        this.navigation.issueNavigator().restoreColumnDefaults();
    }

    @Test
    @Restore(value="TestIssueNavigatorCommon.xml")
    public void testIssueNavigatorSortByComponent() {
        this.logger.log((Object)"Issue Navigator: Test that the filter correctly orders issues for components.");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.tester.gotoPage("/issues/?jql=ORDER%20BY%20component%20ASC%2C%20key%20ASC");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{issueKey4, issueKey2, issueKey, issueKey3});
        this.tester.gotoPage("/issues/?jql=ORDER%20BY%20component%20DESC%2C%20key%20DESC");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{issueKey3, issueKey, issueKey2, issueKey4});
    }

    @Test
    @Restore(value="TestIssueNavigatorCommon.xml")
    public void testIssueNavigatorHideReporter() {
        this.logger.log((Object)"Issue Navigator: Test that the filter correctly hides the reporter field with full content view.");
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Reporter");
        this.navigation.gotoFullContentView("");
        this.textAssertions.assertTextNotPresent("Reporter");
        this.tester.clickLinkWithText("test issue 1");
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields("Reporter");
        this.navigation.gotoFullContentView("");
        this.textAssertions.assertTextPresent("Reporter");
        this.tester.clickLinkWithText("test issue 1");
    }

    @Test
    @Restore(value="TestIssueNavigatorCommon.xml")
    public void testIssueNavigatorSelectGroup() {
        this.logger.log((Object)"Issue Navigator: Test that all issues are filtered for a specific group");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.usersAndGroups().addGroup(GROUP_NAME);
        this.backdoor.usersAndGroups().addUserToGroup("bob", GROUP_NAME);
        String testIssueKey = this.navigation.issue().createIssue(PROJECT_HOMOSAP, "Bug", "test issue 5");
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
        try {
            this.navigation.issue().assignIssue(testIssueKey, "Assign to Bob", "Bob The Builder");
        }
        finally {
            this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
        }
        this.issueTableAssertions.assertSearchWithResults("assignee in membersOf(\"test group\")", testIssueKey, issueKey3, issueKey);
        this.navigation.issue().deleteIssue(testIssueKey);
        this.administration.usersAndGroups().deleteGroup(GROUP_NAME);
    }

    @Test
    @Restore(value="TestIssueNavigatorCommon.xml")
    public void testIssueNavigatorXMLViewWithCustomFields() throws Exception {
        this.logger.log((Object)"Issue Navigator: Test that the RSS page correctly shows the custom field information.");
        this.navigation.issueNavigator().addColumnToIssueNavigator(customFieldNames);
        this.navigation.gotoXmlView("");
        this.textAssertions.assertTextPresent("An XML representation of a search request");
        this.textAssertions.assertTextPresent("[HSP-1] test issue 1");
        Document doc = XMLUnit.buildControlDocument((String)this.tester.getDialog().getResponse().getText());
        for (List<CustomFieldValue> values : cfValuesPerIssue) {
            for (CustomFieldValue customFieldValue : values) {
                if (customFieldValue.getCfType().equals("datepicker")) continue;
                this.logger.log((Object)("Searching for existence of xpath //item/customfields/customfield[@id='customfield_" + customFieldValue.getCfId() + "'][customfieldname='" + this.getCustomFieldNameFromType(customFieldValue.getCfType()) + "'][customfieldvalues[customfieldvalue='" + customFieldValue.getCfValue() + "']]"));
                XMLAssert.assertXpathExists((String)("//item/customfields/customfield[@id='customfield_" + customFieldValue.getCfId() + "'][customfieldname='" + this.getCustomFieldNameFromType(customFieldValue.getCfType()) + "'][customfieldvalues[customfieldvalue='" + customFieldValue.getCfValue() + "']]"), (Document)doc);
            }
        }
    }

    private String getCustomFieldNameFromType(String type) {
        switch (type) {
            case "select": {
                return CUSTOM_FIELD_SELECT;
            }
            case "radiobuttons": {
                return CUSTOM_FIELD_RADIO;
            }
            case "multiselect": {
                return CUSTOM_FIELD_MULTI_SELECT;
            }
            case "multicheckboxes": {
                return CUSTOM_FIELD_CHECKBOX;
            }
            case "textfield": {
                return CUSTOM_FIELD_TEXTFIELD;
            }
            case "userpicker": {
                return CUSTOM_FIELD_USERPICKER;
            }
            case "datepicker": {
                return CUSTOM_FIELD_DATEPICKER;
            }
        }
        return null;
    }

    @Test
    @Restore(value="TestIssueNavigatorCommon.xml")
    public void testNavigatorOrdering() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.tester.gotoPage("/issues/?jql=ORDER%20BY%20summary%20ASC");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
        this.tester.gotoPage("/issues/?jql=ORDER%20BY%20assignee%20ASC");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"Administrator", "Administrator", "Bob The Builder", "Bob The Builder"});
        this.tester.gotoPage("/issues/?jql=ORDER%20BY%20summary%20ASC%2C%20duedate%20ASC");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
        this.tester.gotoPage("/issues/?jql=ORDER%20BY%20summary%20ASC%2C%20workratio%20ASC");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
    }

    @Test
    @Restore(value="TestIssueNavigatorCommon.xml")
    public void testSearchSortDescriptionForInvalidField() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        long id = Long.parseLong(this.backdoor.filters().createFilter("ORDER BY cf[10006] ASC", "My Test Filter"));
        this.tester.gotoPage("/issues/?filter=" + id);
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
        this.administration.customFields().removeCustomField("customfield_10006");
        this.tester.gotoPage("/issues/?filter=" + id);
        this.tester.assertElementNotPresent("issuetable");
    }

    @Test
    @Restore(value="TestIssueNavigatorNoColumns.xml")
    public void testNoColumnsDialog() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"No columns selected"});
    }

    @Test
    @Restore(value="TestIssueNavigatorTextWithDotAndColon.xml")
    public void testCanSearchForTextWithDotAndColon() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().createSearch("description ~ \"d.dude:123\" order by key desc");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("TST-1");
        this.navigation.issueNavigator().createSearch("description ~ \"dude\" order by key asc");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("TST-1", "TST-2");
    }

    @Test
    @Restore(value="TestImageUrlXss.xml")
    public void testXssInImageUrls() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().createSearch("");
        this.tester.assertTextNotPresent("\"'/><script>alert('prioritiezz');</script>");
        this.tester.assertTextNotPresent("\"'/><script>alert('issue typezz');</script>");
    }

    private void assertTextInIssueTable(String pagetext) {
        this.textAssertions.assertTextPresent(new XPathLocator(this.tester, "//table[@id='issuetable']"), pagetext);
    }
}

