/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
@LoginAs(user="admin")
@Restore(value="TestIssueNavigatorColumnLinks.xml")
public class TestIssueNavigatorColumnLinks
extends BaseJiraFuncTest {
    @Inject
    private FuncTestLogger logger;

    @Test
    public void testColumnLinks() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this._testColumnLinksInIssueNavigator();
    }

    public void _testColumnLinksInIssueNavigator() {
        this.logger.log((Object)"Checking the linkage of column values in the Issue Navigator");
        this.navigation.issueNavigator().displayAllIssues();
        TableLocator tableLocator = new TableLocator(this.tester, "issuetable");
        WebTable table = tableLocator.getTable();
        for (int col = 1; col < table.getColumnCount() - 1; ++col) {
            for (int row = 4; row <= 5; ++row) {
                WebLink[] links;
                TableCell cell = table.getTableCell(row, col);
                String cellString = "Cell (" + row + ", " + col + ")";
                if (this.shouldColumnHaveLink(col)) {
                    links = cell.getLinks();
                    Assert.assertTrue((String)(cellString + " should have a link: " + cell.asText().trim()), (links.length > 0 ? 1 : 0) != 0);
                    for (WebLink link : links) {
                        String valueName = link.asText();
                        String url = link.getURLString();
                        this.logger.log((Object)(cellString + " has a link with text '" + valueName + "' and URL '" + url + "'. Following link ..."));
                        this.tester.gotoPage(this.trimUrl(url));
                        this.tester.assertTextPresent(valueName);
                    }
                    continue;
                }
                links = cell.getLinks();
                Assert.assertTrue((String)(cellString + " should not have any links: " + cell.asText().trim()), (links.length == 0 ? 1 : 0) != 0);
                this.logger.log((Object)(cellString + " has no links. Next cell ..."));
            }
        }
    }

    private boolean shouldColumnHaveLink(int col) {
        if (col < 1 || col > 16) {
            throw new IllegalArgumentException("Specify column between 1 and 16");
        }
        return col <= 4 || col == 9 || col == 10 || col >= 12;
    }

    private String trimUrl(String url) {
        if (url.startsWith(this.getEnvironmentData().getContext())) {
            return url.substring(this.getEnvironmentData().getContext().length());
        }
        return url;
    }
}

