/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestIssueNavigatorHTMLView
extends AbstractTestIssueNavigatorView {
    private static final String ESCAPED_FILTER_NAME = "&lt;script&gt;alert(&#39;xss&#39;)&lt;/script&gt";
    private static final String FILTER_NAME = "<script>alert('xss')</script>";
    private String exportUrl;

    @Before
    public void setUpTest() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "", FILTER_NAME, "");
        this.exportUrl = "/sr/jira.issueviews:searchrequest-html-all-fields/" + filterId + "/SearchRequest-" + filterId + ".html";
    }

    @Test
    public void testTitleTagEscaping() {
        this.tester.gotoPage(this.exportUrl);
        String rawResponse = this.tester.getDialog().getResponseText();
        Assert.assertTrue((String)"Escaped title is present in the response", (boolean)rawResponse.contains("<title>&lt;script&gt;alert(&#39;xss&#39;)&lt;/script&gt"));
    }

    @Test
    public void testAltAttributeValueEscaping() {
        this.tester.gotoPage(this.exportUrl);
        String rawResponse = this.tester.getDialog().getResponseText();
        Assert.assertTrue((String)"Escaped alt attribute value is present in the response", (boolean)rawResponse.contains("alt=\"&lt;script&gt;alert(&#39;xss&#39;)&lt;/script&gt"));
    }

    @Test
    public void testFilterNameEscaping() {
        this.tester.gotoPage(this.exportUrl);
        String rawResponse = this.tester.getDialog().getResponseText();
        Assert.assertTrue((String)"Escaped filter name is present in the response", (boolean)rawResponse.contains("data-testid=\"filterNameHref\">&lt;script&gt;alert(&#39;xss&#39;)&lt;/script&gt"));
    }

    @Test
    public void testTitleFieldBeingUnescapedInTheExport() {
        this.tester.gotoPage(this.exportUrl);
        String rawResponse = this.tester.getDialog().getResponseText();
        Assert.assertFalse((String)"Unescaped filter name is not present in the response", (boolean)rawResponse.contains(FILTER_NAME));
    }
}

