/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorColumnsView;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import com.meterware.httpunit.WebTable;
import java.util.Arrays;
import javax.inject.Inject;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
@Restore(value="TestSearchRequestViewsAndIssueViews.xml")
@LoginAs(user="admin")
public class TestIssueNavigatorPrintableView
extends AbstractTestIssueNavigatorColumnsView {
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testTimeTrackingPrintableView() throws SAXException {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.administration.subtasks().enable();
        this.backdoor.issueTableClient().getIssueTable("");
        this.backdoor.columnControl().addLoggedInUserColumns(Arrays.asList("aggregatetimeoriginalestimate", "aggregateprogress", "aggregatetimeestimate", "aggregatetimespent"));
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?jqlQuery=&tempMax=1000");
        WebTable issueTable = this.tester.getDialog().getResponse().getTableWithID("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 0, 45, "\u03a3 Original Estimate");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 0, 46, "\u03a3 Progress");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 0, 47, "\u03a3 Remaining Estimate");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 0, 48, "\u03a3 Time Spent");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 46, "86%");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 47, "30 minutes");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 48, "3 hours, 20 minutes");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 45, "1 day");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 46, "0%");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 47, "1 day");
    }

    @Test
    public void testAllColumnsPrintableView() throws SAXException {
        this.logger.log((Object)"Issue Navigator: Test that the printable view shows all required items");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?jqlQuery=&tempMax=1000");
        WebTable issueTable = this.tester.getDialog().getResponse().getTableWithID("issuetable");
        for (AbstractTestIssueNavigatorView.Item item : this.items) {
            new AbstractTestIssueNavigatorColumnsView.ItemVerifier(this, item, issueTable, this.getEnvironmentData().getBaseUrl()).verify();
        }
    }

    @Test
    public void testPrintableViewXSSBug() {
        String filter = this.backdoor.filters().createFilter("", "<script>alert('evil');</script>");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-printable/" + filter + "/SearchRequest-" + filter + ".html?tempMax=1000");
        this.tester.assertTextPresent("&lt;script&gt;alert(&#39;evil&#39;);&lt;/script&gt;");
    }

    @Test
    public void testAllColumnsPrintableViewDaysFormat() throws SAXException {
        this.reconfigureTimetracking(TimeTracking.Format.DAYS);
        this.testAllColumnsPrintableView();
    }

    @Test
    public void testAllColumnsPrintableViewHoursFormat() throws SAXException {
        this.reconfigureTimetracking(TimeTracking.Format.HOURS);
        this.testAllColumnsPrintableView();
    }

    @Test
    public void testSearchRequestHeaderSummaryDisplaysCorrectTotals() {
        this.logger.log((Object)"Issue Navigator: Test that the printable view shows all required items");
        this.navigation.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?sorter/field=issuekey&sorter/order=DESC&tempMax=2");
        this.tester.assertTextPresent("<b>1</b>&ndash;<b>2</b> of <b>3</b>");
        this.navigation.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?sorter/field=issuekey&sorter/order=DESC");
        this.tester.assertTextPresent("<b>1</b>&ndash;<b>3</b> of <b>3</b>");
    }

    @Test
    public void testSearchRequestSummaryWithSimpleAndAdvancedQuery() throws Exception {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?jqlQuery=status%20=%20'In Progress'&tempMax=1000");
        CssLocator summaryLocator = new CssLocator(this.tester, ".result-header");
        this.textAssertions.assertTextSequence(summaryLocator, "Status", "In Progress");
        this.textAssertions.assertTextNotPresent(summaryLocator, "JQL Query");
        this.textAssertions.assertTextNotPresent(summaryLocator, "status = 'In Progress'");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?jqlQuery=status%20!=%20'In Progress'&tempMax=1000");
        summaryLocator = new CssLocator(this.tester, ".result-header");
        this.textAssertions.assertTextSequence(summaryLocator, "JQL Query", "status != 'In Progress'");
        this.textAssertions.assertTextNotPresent(summaryLocator, "Status");
    }

    @Test
    public void testJQLEscaping() {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?jqlQuery=assignee=\"admin<details/open/ontoggle=confirm(123)>>\"");
        CssLocator summaryLocator = new CssLocator(this.tester, ".result-header");
        this.textAssertions.assertTextSequence(summaryLocator, "JQL Query", "assignee=\"admin<details/open/ontoggle=confirm(123)>>\"");
    }
}

