/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
public class TestIssueNavigatorWordView
extends AbstractTestIssueNavigatorView {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Restore(value="TestSearchRequestViewNonAsciiSearchName.xml")
    @LoginAs(user="admin")
    public void testWordFilenameWithNonAsciiCharacters() {
        String encodedFilename = "%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F\\+%28jWebTest\\+JIRA\\+installation%29.*\\.doc";
        String oldUserAgent = this.tester.getDialog().getWebClient().getClientProperties().getUserAgent();
        try {
            this.logger.log((Object)"Issue Navigator: Test that the word view generates the correct filename when the search request has non-ASCII characters");
            this.tester.getDialog().getWebClient().getClientProperties().setUserAgent("Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)");
            this.tester.gotoPage("/sr/jira.issueviews:searchrequest-word/10000/SearchRequest-10000.doc?tempMax=1000");
            String contentDisposition = this.tester.getDialog().getResponse().getHeaderField("content-disposition");
            TestIssueNavigatorWordView.assertMatches(contentDisposition, ".*filename=\"%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F\\+%28jWebTest\\+JIRA\\+installation%29.*\\.doc\";");
            Assert.assertEquals((Object)"sandbox", (Object)this.tester.getDialog().getResponse().getHeaderField("Content-Security-Policy"));
            this.tester.getDialog().getWebClient().getClientProperties().setUserAgent("Mozilla/5.001 (windows; U; NT4.0; en-US; rv:1.0) Gecko/25250101");
            this.tester.gotoPage("/sr/jira.issueviews:searchrequest-word/10000/SearchRequest-10000.doc?tempMax=1000");
            contentDisposition = this.tester.getDialog().getResponse().getHeaderField("content-disposition");
            TestIssueNavigatorWordView.assertMatches(contentDisposition, ".*filename\\*=UTF-8''%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F\\+%28jWebTest\\+JIRA\\+installation%29.*\\.doc;");
            Assert.assertEquals((Object)"sandbox", (Object)this.tester.getDialog().getResponse().getHeaderField("Content-Security-Policy"));
        }
        finally {
            this.tester.getDialog().getWebClient().getClientProperties().setUserAgent(oldUserAgent);
        }
    }

    private static void assertMatches(String text, String regex) {
        if (!String.valueOf(text).matches(regex)) {
            Assert.fail((String)String.format("Text \"%s\" was expected to match pattern \"%s\"", text, regex));
        }
    }
}

