/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.core.util.FileUtils;
import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import electric.xml.Document;
import electric.xml.ParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR})
@LoginAs(user="admin")
@Restore(value="TestSearchRequestViewsAndIssueViews.xml")
public class TestIssueNavigatorXmlViewTimeTracking
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.backdoor.subtask().enable();
        this.subTaskify("HSP-12", "HSP-10");
        this.subTaskify("HSP-11", "HSP-10");
    }

    @Test
    public void testTimeTrackingEnabled() throws SAXException, IOException, ParseException {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=&tempMax=1000");
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertAttributeNotPresent(doc, "HSP-12", "timeoriginalestimate");
        this.assertAttributeNotPresent(doc, "HSP-12", "timeestimate");
        this.assertAttributeNotPresent(doc, "HSP-12", "timespent");
        this.assertAttributeNotPresent(doc, "HSP-12", "aggregatetimeoriginalestimate");
        this.assertAttributeNotPresent(doc, "HSP-12", "aggregatetimeremainingestimate");
        this.assertAttributeNotPresent(doc, "HSP-12", "aggregatetimespent");
        this.assertAttributeNotPresent(doc, "HSP-11", "timeoriginalestimate");
        this.assertAttributePresentWithValue(doc, "HSP-11", "timeestimate", "1800");
        this.assertAttributePresentWithValue(doc, "HSP-11", "timespent", "12000");
        this.assertAttributeNotPresent(doc, "HSP-11", "aggregatetimeoriginalestimate");
        this.assertAttributeNotPresent(doc, "HSP-11", "aggregatetimeremainingestimate");
        this.assertAttributeNotPresent(doc, "HSP-11", "aggregatetimespent");
        this.assertAttributePresentWithValue(doc, "HSP-10", "timeoriginalestimate", "86400");
        this.assertAttributePresentWithValue(doc, "HSP-10", "timeestimate", "86400");
        this.assertAttributeNotPresent(doc, "HSP-10", "timespent");
        this.assertAttributePresentWithValue(doc, "HSP-10", "aggregatetimeoriginalestimate", "86400");
        this.assertAttributePresentWithValue(doc, "HSP-10", "aggregatetimeremainingestimate", "88200");
        this.assertAttributePresentWithValue(doc, "HSP-10", "aggregatetimespent", "12000");
    }

    @Test
    public void testTimeTrackingDisabled() throws SAXException, IOException, ParseException {
        this.administration.timeTracking().disable();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=&tempMax=1000");
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertAttributeNotPresent(doc, "HSP-12", "timeoriginalestimate");
        this.assertAttributeNotPresent(doc, "HSP-12", "timeestimate");
        this.assertAttributeNotPresent(doc, "HSP-12", "timespent");
        this.assertAttributeNotPresent(doc, "HSP-12", "aggregatetimeoriginalestimate");
        this.assertAttributeNotPresent(doc, "HSP-12", "aggregatetimeremainingestimate");
        this.assertAttributeNotPresent(doc, "HSP-12", "aggregatetimespent");
        this.assertAttributeNotPresent(doc, "HSP-11", "timeoriginalestimate");
        this.assertAttributeNotPresent(doc, "HSP-11", "timeestimate");
        this.assertAttributeNotPresent(doc, "HSP-11", "timespent");
        this.assertAttributeNotPresent(doc, "HSP-11", "aggregatetimeoriginalestimate");
        this.assertAttributeNotPresent(doc, "HSP-11", "aggregatetimeremainingestimate");
        this.assertAttributeNotPresent(doc, "HSP-11", "aggregatetimespent");
        this.assertAttributeNotPresent(doc, "HSP-10", "timeoriginalestimate");
        this.assertAttributeNotPresent(doc, "HSP-10", "timeestimate");
        this.assertAttributeNotPresent(doc, "HSP-10", "timespent");
        this.assertAttributeNotPresent(doc, "HSP-10", "aggregatetimeoriginalestimate");
        this.assertAttributeNotPresent(doc, "HSP-10", "aggregatetimeremainingestimate");
        this.assertAttributeNotPresent(doc, "HSP-10", "aggregatetimespent");
    }

    private void assertAttributeNotPresent(Document doc, String issueKey, String attributeName) {
        Node issue = this.getIssueWithKey(doc, issueKey);
        if (issue != null) {
            Node issueAttribute = this.getIssueAttribute(issue, attributeName);
            Assert.assertNull((Object)issueAttribute);
        }
    }

    private void assertAttributePresentWithValue(Document doc, String issueKey, String attributeName, String expectedValue) {
        Node issue = this.getIssueWithKey(doc, issueKey);
        if (issue != null) {
            Node issueAttribute = this.getIssueAttribute(issue, attributeName);
            if (issueAttribute != null) {
                NamedNodeMap attributes = issueAttribute.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    if (!"seconds".equals(attribute.getNodeName())) continue;
                    if (expectedValue.equals(attribute.getNodeValue())) {
                        return;
                    }
                    Assert.assertEquals((Object)expectedValue, (Object)attribute.getNodeValue());
                }
            }
            Assert.fail();
        }
    }

    private Node getIssueWithKey(Document doc, String key) {
        if (key != null) {
            NodeList issues = doc.getElementsByTagName("item");
            for (int i = 0; i < issues.getLength(); ++i) {
                Node issue = issues.item(i);
                Node keyAttribute = this.getIssueAttribute(issue, "key");
                if (!key.equals(keyAttribute.getFirstChild().getNodeValue())) continue;
                return issue;
            }
        }
        return null;
    }

    private Node getIssueAttribute(Node issue, String attribute) {
        if (attribute != null) {
            NodeList issueAttributes = issue.getChildNodes();
            for (int i = 0; i < issueAttributes.getLength(); ++i) {
                Node issueAttribute = issueAttributes.item(i);
                if (!attribute.equals(issueAttribute.getNodeName())) continue;
                return issueAttribute;
            }
        }
        return null;
    }

    private void subTaskify(String issueKey, String parentKey) {
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", parentKey);
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Finish");
    }

    private Document getDocument() throws IOException, ParseException {
        InputStream inputStream = this.tester.getDialog().getResponse().getInputStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        FileUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        return new Document(outputStream.toByteArray());
    }
}

