/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR})
@LoginAs(user="admin")
public class TestNavigationBarWebFragment
extends BaseJiraFuncTest {
    private static final long USERS_PROJECT_ROLE_ID = 10000L;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestNavigationBarWebFragment.xml");
    }

    @After
    public void tearDownTest() {
        this.navigation.login("admin", "admin");
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testNavigationBarWebFragment() {
        this.navigation.login("admin", "admin");
        this.tester.assertLinkPresent("home_link");
        this._checkBrowseAndFindIssueLinksVisiblity();
        this._checkCreateIssueLinkVisiblity();
        this._checkAdminLinkVisiblityToProjectAdmin();
        this._checkAdminLinkVisiblityToSystemAdmin();
    }

    public void _checkBrowseAndFindIssueLinksVisiblity() {
        this.tester.assertLinkPresent("browse_link");
        this.tester.assertLinkPresent("find_link");
        this.removeBrowsePermission();
        this.tester.assertLinkNotPresent("find_link");
        this.addBrowsePermission();
        this.navigation.gotoDashboard();
        this.tester.assertLinkPresent("find_link");
        this.tester.assertLinkPresent("browse_link");
        this.tester.assertLinkPresentWithText("Projects");
        this.navigation.gotoDashboard();
        this.tester.assertLinkPresent("browse_link");
        this.tester.assertLinkPresentWithText("Projects");
    }

    public void _checkCreateIssueLinkVisiblity() {
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.assertLinkPresent("create_link");
        this.removeCreatePermission();
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.assertLinkNotPresent("create_link");
        this.addCreatePermission();
        this.navigation.gotoDashboard();
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.assertLinkPresent("create_link");
    }

    public void _checkAdminLinkVisiblityToProjectAdmin() {
        this.navigation.login("project_admin", "project_admin");
        Assert.assertTrue((boolean)this.administration.link().isPresent());
        this.navigation.login("admin", "admin");
        this.removeProjectAdminPermission();
        this.navigation.gotoDashboard();
        Assert.assertTrue((boolean)this.administration.link().isPresent());
        this.navigation.logout();
        this.navigation.login("project_admin", "project_admin");
        Assert.assertFalse((boolean)this.administration.link().isPresent());
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.addProjectAdminPermission();
        this.navigation.gotoDashboard();
        Assert.assertTrue((boolean)this.administration.link().isPresent());
        this.navigation.logout();
        this.navigation.login("project_admin", "project_admin");
        Assert.assertTrue((boolean)this.administration.link().isPresent());
    }

    public void _checkAdminLinkVisiblityToSystemAdmin() {
        this.navigation.login("system_admin", "system_admin");
        Assert.assertTrue((boolean)this.administration.link().isPresent());
        this.navigation.login("admin", "admin");
        this.administration.usersAndGroups().removeUserFromGroup("system_admin", "jira-administrators");
        this.navigation.gotoDashboard();
        Assert.assertTrue((boolean)this.administration.link().isPresent());
        this.navigation.logout();
        this.navigation.login("system_admin", "system_admin");
        Assert.assertFalse((boolean)this.administration.link().isPresent());
        this.navigation.login("admin", "admin");
        this.administration.usersAndGroups().addUserToGroup("system_admin", "jira-administrators");
        this.navigation.gotoDashboard();
        Assert.assertTrue((boolean)this.administration.link().isPresent());
        this.navigation.login("system_admin", "system_admin");
        Assert.assertTrue((boolean)this.administration.link().isPresent());
    }

    public void removeBrowsePermission() {
        this.backdoor.permissionSchemes().removeProjectRolePermission(0L, ProjectPermissions.BROWSE_PROJECTS, 10000L);
        this.navigation.gotoDashboard();
    }

    public void removeCreatePermission() {
        this.backdoor.permissionSchemes().removeProjectRolePermission(0L, ProjectPermissions.CREATE_ISSUES, 10000L);
        this.navigation.gotoDashboard();
    }

    public void removeProjectAdminPermission() {
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ADMINISTER_PROJECTS, "jira-developers");
        this.navigation.gotoDashboard();
    }

    public void addBrowsePermission() {
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS, "jira-users");
    }

    public void addCreatePermission() {
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.CREATE_ISSUES, "jira-users");
    }

    public void addProjectAdminPermission() {
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ADMINISTER_PROJECTS, "jira-developers");
    }
}

