/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Errors;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RestoreBlankInstance
@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.REST})
public class TestAbstractUserBasedFunction
extends BaseJiraRestTest {
    private AbstractUserBasedFunctionClient client;

    @Before
    public void setup() {
        this.client = new AbstractUserBasedFunctionClient(this.getEnvironmentData());
    }

    @Test
    public void testUserQueryWillSucceedWhenUserIsLoggedIn() throws JSONException {
        Form form = new Form();
        form.param("jql", "project in projectsLeadByUser(admin)");
        ParsedResponse<String> webResponse = ((AbstractUserBasedFunctionClient)this.client.loginAs("admin")).submitIssueTableForm(form);
        JSONObject returned = new JSONObject((String)webResponse.body);
        Assert.assertTrue((boolean)returned.has("issueTable"));
    }

    @Test
    public void testUserQueryDeniedWhenGuestAndAnonymousAccessDisabled() {
        Form form = new Form();
        form.param("jql", "project in projectsLeadByUser(admin)");
        ParsedResponse<String> webResponse = ((AbstractUserBasedFunctionClient)this.client.anonymous()).submitIssueTableForm(form);
        Errors returned = webResponse.entity;
        Assert.assertEquals(returned.errorMessages.get(0), (Object)"Function 'projectsLeadByUser' cannot be called as anonymous user.");
    }

    @Test
    public void testUserQueryAllowedWhenGuestAndAnonymousAccessEnabled() throws Exception {
        this.backdoor.permissions().addAnyoneGlobalPermission(27);
        Form form = new Form();
        form.param("jql", "project in projectsLeadByUser(admin)");
        ParsedResponse<String> webResponse = ((AbstractUserBasedFunctionClient)this.client.anonymous()).submitIssueTableForm(form);
        JSONObject returned = new JSONObject((String)webResponse.body);
        Assert.assertTrue((boolean)returned.has("issueTable"));
    }

    public static class AbstractUserBasedFunctionClient
    extends RestApiClient<AbstractUserBasedFunctionClient> {
        public AbstractUserBasedFunctionClient(JIRAEnvironmentData environmentData) {
            super(environmentData);
        }

        public ParsedResponse<String> submitIssueTableForm(Form payload) {
            return this.toResponse(() -> this.resourceRoot(this.getEnvironmentData().getBaseUrl().toExternalForm()).path("rest").path("issueNav").path("1").path("issueTable").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Atlassian-Token", (Object)"no-check").post(Entity.form((Form)payload)), String.class);
        }
    }
}

