/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.assertions.JqlAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@LoginAs(user="admin")
public class TestAdvancedSimple
extends BaseJiraFuncTest {
    @Inject
    private JqlAssertions jqlAssertions;
    @Inject
    private Administration administration;

    @Test
    public void testJQLErrors() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("project = INVALID");
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("issuetype = INVALID");
        this.assertInvalidJqlAndSwitchToBasic("text ~ \"*INVALID\"", "Invalid start character '*'", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("text", "*INVALID"));
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("status = INVALID");
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("resolution = INVALID");
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("priority = INVALID");
        this.assertInvalidJqlAndSwitchToBasic("created >= INVALID AND created <= INVALID", "Invalid date format. Please enter the date in the format", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("created:after", "INVALID"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("created:before", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("updated >= INVALID AND updated <= INVALID", "Invalid date format. Please enter the date in the format", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("updated:after", "INVALID"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("updated:before", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("due >= INVALID AND due <= INVALID", "Invalid date format. Please enter the date in the format", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("duedate:after", "INVALID"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("duedate:before", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("resolved >= INVALID AND resolved <= INVALID", "Invalid date format. Please enter the date in the format", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolutiondate:after", "INVALID"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolutiondate:before", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("workratio >= INVALID AND workratio <= INVALID", "The min limit must be specified using an integer", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("workratio:min", "INVALID"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("workratio:max", "INVALID"));
    }

    @Test
    @Restore(value="TestSwitchingWithOneProject.xml")
    public void testIdsAreTooComplex() throws Exception {
        this.jqlAssertions.assertFitsFilterForm("fixVersion = \"New Version 1\"", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "New Version 1"));
        this.jqlAssertions.assertTooComplex("fixVersion = 10000");
        this.jqlAssertions.assertFitsFilterForm("affectedVersion = \"New Version 1\"", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("affectedVersion", "New Version 1"));
        this.jqlAssertions.assertTooComplex("affectedVersion = 10000");
        this.jqlAssertions.assertFitsFilterForm("component = \"New Component 1\"", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("component", "New Component 1"));
        this.jqlAssertions.assertTooComplex("component = 10000");
    }

    private void assertInvalidJqlAndSwitchToBasic(String invalidJqlQuery, String errorMessage, IssueNavigatorAssertions.FilterFormParam ... params) {
        ParsedResponse<String> searchersResponse = this.backdoor.searchersClient().getSearchersResponse(invalidJqlQuery);
        Assert.assertEquals((long)200L, (long)searchersResponse.statusCode);
    }

    private void assertInvalidJqlAndSwitchToBasicDoesntFit(String invalidJqlQuery) {
        this.jqlAssertions.assertTooComplex(invalidJqlQuery);
    }
}

