/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.CustomFieldConfig;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@Restore(value="TestAllTextClauseCorrectness.xml")
@LoginAs(user="admin")
public class TestAllTextClause
extends BaseJiraFuncTest {
    private static final int DEFAULT_CONFIG_SCHEME_INDEX = 0;
    @Inject
    private IssueTableAssertions issueTableAssertions;
    @Inject
    private Administration administration;

    @Test
    public void testCorrectness() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.issueTableAssertions.assertSearchWithResults("text ~ something", new String[0]);
        String issue1 = this.navigation.issue().createIssue("homosapien", "Bug", "this summary has something in it");
        String issue2 = this.navigation.issue().createIssue("homosapien", "Bug", "this summary has bananas in it");
        String issue3 = this.navigation.issue().createIssue("homosapien", "Bug", "this summary 3");
        String issue4 = this.navigation.issue().createIssue("homosapien", "Bug", "this summary 4");
        this.issueTableAssertions.assertSearchWithResults("text ~ something", issue1);
        this.issueTableAssertions.assertSearchWithResults("text ~ \"[bananaa TO bananaz]\"", issue2);
        this.issueTableAssertions.assertSearchWithResults("text ~ \"[bananas TO bananas]\"", issue2);
        this.issueTableAssertions.assertSearchWithResults("text ~ \"{bananas TO bananaz]\"", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("text ~ \"{ha TO haz}\"", issue2, issue1);
        this.issueTableAssertions.assertSearchWithResults("text ~ \"summary something\"", issue1);
        this.issueTableAssertions.assertSearchWithResults("text ~ \"bananas something\"", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("text ~ \"this summary has in it\"", issue2, issue1);
        this.navigation.issue().setDescription(issue1, "cheese");
        this.issueTableAssertions.assertSearchWithResults("text ~ cheese", issue1);
        this.navigation.issue().setEnvironment(issue2, "toast");
        this.issueTableAssertions.assertSearchWithResults("text ~ toast", issue2);
        this.navigation.issue().addComment(issue3, "monkey", null);
        this.issueTableAssertions.assertSearchWithResults("text ~ monkey", issue3);
        String cfName = "MyText";
        String customFieldId = this.createCustomField("MyText", CustomFields.builtInCustomFieldKey("textarea"), CustomFields.builtInCustomFieldKey("textsearcher"));
        this.navigation.issue().setFreeTextCustomField(issue4, customFieldId, "gojira");
        this.issueTableAssertions.assertSearchWithResults("text ~ gojira", issue4);
        this.updateContextScheme(customFieldId, Collections.singletonList("10001"), null);
        this.issueTableAssertions.assertSearchWithResults("text ~ gojira", new String[0]);
        this.updateContextScheme(customFieldId, Collections.emptyList(), Collections.emptyList());
        this.issueTableAssertions.assertSearchWithResults("text ~ gojira", issue4);
        String urlCFId = this.createCustomField("MyURL", "com.atlassian.jira.plugin.system.customfieldtypes:url", null);
        this.navigation.issue().setFreeTextCustomField(issue4, urlCFId, "http://www.atlassian.com");
        this.issueTableAssertions.assertSearchWithResults("text ~ 'http://www.atlassian.com'", new String[0]);
        this.navigation.issue().addComment(issue4, "something", null);
        this.issueTableAssertions.assertSearchWithResults("text ~ something", issue4, issue1);
        this.navigation.issue().setDescription(issue2, "something");
        this.issueTableAssertions.assertSearchWithResults("text ~ something", issue4, issue2, issue1);
        this.navigation.issue().setEnvironment(issue3, "something");
        this.issueTableAssertions.assertSearchWithResults("text ~ something", issue4, issue3, issue2, issue1);
        this.administration.fieldConfigurations().fieldConfiguration("A Config").hideFields("Description");
        this.issueTableAssertions.assertSearchWithResults("text ~ cheese", issue1);
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Description");
        this.issueTableAssertions.assertSearchWithResults("text ~ cheese", new String[0]);
        this.administration.fieldConfigurations().fieldConfiguration("A Config").hideFields("Environment");
        this.issueTableAssertions.assertSearchWithResults("text ~ toast", issue2);
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Environment");
        this.issueTableAssertions.assertSearchWithResults("text ~ toast", new String[0]);
        this.administration.fieldConfigurations().fieldConfiguration("A Config").hideFields("MyText");
        this.issueTableAssertions.assertSearchWithResults("text ~ gojira", issue4);
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("MyText");
        this.issueTableAssertions.assertSearchWithResults("text ~ gojira", new String[0]);
    }

    private void updateContextScheme(String fieldId, Collection<String> projectIds, Collection<String> issueTypeIds) {
        Long defaultConfigSchemeId = ((CustomFieldConfig)this.backdoor.customFields().getCustomField(fieldId, true).getConfig().get(0)).getId();
        this.backdoor.fieldConfigScheme().updateFieldConfigScheme(fieldId, defaultConfigSchemeId, null, projectIds, issueTypeIds);
    }

    @Test
    public void testErrorMessagesWithInvalidRangeQuery() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.assertSearchWithIncorrectRangeFreeTextJql("[wrong");
        this.assertSearchWithIncorrectRangeFreeTextJql("[wrong]");
        this.assertSearchWithIncorrectRangeFreeTextJql("[wrong TO]");
        this.assertSearchWithIncorrectRangeFreeTextJql("[TO wrong]");
        this.assertSearchWithIncorrectRangeFreeTextJql("[TO wrong");
        this.assertSearchWithIncorrectRangeFreeTextJql("{wrong");
        this.assertSearchWithIncorrectRangeFreeTextJql("{wrong}");
        this.assertSearchWithIncorrectRangeFreeTextJql("{wrong TO}");
        this.assertSearchWithIncorrectRangeFreeTextJql("{TO wrong}");
        this.assertSearchWithIncorrectRangeFreeTextJql("{TO wrong");
    }

    private void assertSearchWithIncorrectRangeFreeTextJql(String rangeQuery) {
        this.issueTableAssertions.assertSearchWithError(String.format("text ~ \"%s\"", rangeQuery), String.format("The text query '%s' for field 'text' is not valid: probably your range query is incorrect.", rangeQuery));
    }

    private String createCustomField(String name, String type, String searcherKey) {
        String customFieldId = this.backdoor.customFields().createCustomField(name, "", type, searcherKey);
        this.backdoor.screens().addFieldToScreen("Default Screen", name);
        return customFieldId;
    }
}

