/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.assertions.JqlAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@Restore(value="TestCustomFieldAliases.xml")
public class TestCustomFieldAliases
extends BaseJiraFuncTest {
    @Inject
    private IssueTableAssertions issueTableAssertions;
    @Inject
    private JqlAssertions jqlAssertions;

    @Before
    public void setUpTest() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testCustumFielAliasesAndSpaces() throws Exception {
        this.issueTableAssertions.assertSearchWithResults("\"With Spaces\" is not empty", "HSP-3", "HSP-2");
        this.issueTableAssertions.assertSearchWithResults("cf[10001] is not empty", "HSP-3", "HSP-2");
        this.issueTableAssertions.assertSearchWithResults("\"With Spaces\" ~ \"Blah\" OR cf[10001] ~ \"Hello there\"", "HSP-3", "HSP-2");
        this.issueTableAssertions.assertSearchWithResults("\"NoSpaces\" is not empty", "HSP-1");
        this.issueTableAssertions.assertSearchWithResults("cf[10000] is not empty", "HSP-1");
        this.issueTableAssertions.assertSearchWithResults("\"With Spaces\" is not empty OR \"NoSpaces\" is not empty", "HSP-3", "HSP-2", "HSP-1");
    }

    @Test
    public void testCustomFieldDoesItFitWithAliasesAndFullNames() throws Exception {
        this.jqlAssertions.assertFitsFilterForm("\"With Spaces\" ~ \"Blah\"", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10001", "Blah"));
        this.jqlAssertions.assertFitsFilterForm("\"cf[10001]\" ~ \"Blah\"", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10001", "Blah"));
        this.jqlAssertions.assertFitsFilterForm("\"NoSpaces\" ~ \"HelloThere\"", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10000", "HelloThere"));
        this.jqlAssertions.assertFitsFilterForm("\"cf[10000]\" ~ \"HelloThere\"", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10000", "HelloThere"));
    }

    @Test
    public void testSameNameSameTypeSameContext() throws Exception {
        this.jqlAssertions.assertFitsFilterForm("cf[10010] ~ \"Blah\"", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10010", "Blah"));
        this.jqlAssertions.assertFitsFilterForm("cf[10010] ~ \"Blah\" AND cf[10011] ~ \"Blah\"", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10010", "Blah"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10011", "Blah"));
        this.jqlAssertions.assertTooComplex("SameSameSame ~ \"Blah\"");
        this.issueTableAssertions.assertSearchWithResults("SameSameSame ~ \"value1\"", "HSP-5", "HSP-4");
        this.issueTableAssertions.assertSearchWithResults("SameSameSame ~ \"value2\"", "HSP-5", "HSP-4");
        this.issueTableAssertions.assertSearchWithResults("cf[10010] ~ \"value1\"", "HSP-4");
        this.issueTableAssertions.assertSearchWithResults("cf[10011] ~ \"value1\"", "HSP-5");
    }

    @Test
    public void testSameNameDiffTypeSameContext() throws Exception {
        this.issueTableAssertions.assertSearchWithError("SameDiffSame ~ 1", "The operator '~' is not supported by the 'SameDiffSame' field.");
        this.issueTableAssertions.assertSearchWithError("SameDiffSame = 1", "The operator '=' is not supported by the 'SameDiffSame' field.");
        this.issueTableAssertions.assertSearchWithError("SameDiffSame = 2", "The operator '=' is not supported by the 'SameDiffSame' field.");
        this.issueTableAssertions.assertSearchWithError("SameDiffSame ~ Value1", "The operator '~' is not supported by the 'SameDiffSame' field.");
        this.issueTableAssertions.assertSearchWithResults("cf[10020] ~ Value1", "HSP-6");
        this.jqlAssertions.assertFitsFilterForm("cf[10020] ~ Value1", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.issueTableAssertions.assertSearchWithResults("cf[10020]  ~ 2", "HSP-7");
        this.jqlAssertions.assertFitsFilterForm("cf[10020]  ~ 2", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.issueTableAssertions.assertSearchWithResults("cf[10021] = 1", "HSP-7");
        this.jqlAssertions.assertFitsFilterForm("cf[10021] = 1", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.issueTableAssertions.assertSearchWithResults("cf[10021] = 2", "HSP-6");
        this.jqlAssertions.assertFitsFilterForm("cf[10021] = 2", new IssueNavigatorAssertions.FilterFormParam[0]);
    }

    @Test
    public void testSameNameSameTypeSameContextDifferentValues() throws Exception {
        this.issueTableAssertions.assertSearchWithResults("SelectHidden = \"SameValue\"", new String[0]);
        this.jqlAssertions.assertTooComplex("SelectHidden = \"SameValue\"");
        this.issueTableAssertions.assertSearchWithResults("SelectHidden = \"DiffValue1\"", "HSP-8");
        this.jqlAssertions.assertTooComplex("SelectHidden = \"DiffValue1\"");
        this.issueTableAssertions.assertSearchWithError("SelectHidden = \"DiffValue2\"", "The option 'DiffValue2' for field 'SelectHidden' does not exist.");
        this.issueTableAssertions.assertSearchWithResults("\"Select\" = \"SameValue\"", "HSP-10", "HSP-9");
        this.jqlAssertions.assertTooComplex("\"Select\" = \"SameValue\"");
        this.jqlAssertions.assertTooComplex("\"Select\" = \"SameValue\" and project = \"homosapien\"");
        this.jqlAssertions.assertTooComplex("\"Select\" = \"SameValue\" and project = \"monkey\"");
        this.jqlAssertions.assertFitsFilterForm("cf[10030] = \"SameValue\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("cf[10031] = \"SameValue\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("cf[10030] = \"DiffValue1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("cf[10031] = \"DiffValue2\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.issueTableAssertions.assertSearchWithError("\"Select\" = \"DiffValue1\"", "The option 'DiffValue1' for field 'Select' does not exist.");
        this.issueTableAssertions.assertSearchWithError("\"Select\" = \"DiffValue2\"", "The option 'DiffValue2' for field 'Select' does not exist.");
    }

    @Test
    public void testSameNameSameTypeDiffContext() throws Exception {
        this.issueTableAssertions.assertSearchWithResults("SelectContext = 'Option1'", "MKY-1", "HSP-11");
        this.jqlAssertions.assertTooComplex("SelectContext = 'Option1'");
        this.issueTableAssertions.assertSearchWithResults("SelectContext = 'Option1' and project = homosapien", "HSP-11");
        this.jqlAssertions.assertTooComplex("SelectContext = 'Option1' and project = homosapien");
        this.issueTableAssertions.assertSearchWithResults("SelectContext = 'Option1' and project = monkey", "MKY-1");
        this.jqlAssertions.assertTooComplex("SelectContext = 'Option1' and project = monkey");
        this.issueTableAssertions.assertSearchWithError("SelectContext= 'OptionMonkey'", "The option 'OptionMonkey' for field 'SelectContext' does not exist.");
    }

    @Test
    public void testSameNameDiffTypeSameOperator() throws Exception {
        this.issueTableAssertions.assertSearchWithResults("Picker in (\"TestValue\")", "HSP-17", "HSP-16", "HSP-15", "HSP-14", "HSP-13");
        this.issueTableAssertions.assertSearchWithResults("cf[10050] in (\"TestValue\")", "HSP-17", "HSP-16", "HSP-15", "HSP-13");
        this.issueTableAssertions.assertSearchWithResults("cf[10051] in (\"TestValue\")", "HSP-17", "HSP-14", "HSP-13");
        this.issueTableAssertions.assertSearchWithResults("Picker not in (\"TestValue\")", "HSP-18");
        this.issueTableAssertions.assertSearchWithResults("cf[10050] not in (\"TestValue\")", "HSP-18");
        this.issueTableAssertions.assertSearchWithResults("cf[10051] not in (\"TestValue\")", "HSP-18");
        this.issueTableAssertions.assertSearchWithResults("Picker = \"TestValue\"", "HSP-17", "HSP-16", "HSP-15", "HSP-14", "HSP-13");
        this.issueTableAssertions.assertSearchWithResults("cf[10050] = \"TestValue\"", "HSP-17", "HSP-16", "HSP-15", "HSP-13");
        this.issueTableAssertions.assertSearchWithResults("cf[10051] = \"TestValue\"", "HSP-17", "HSP-14", "HSP-13");
        this.issueTableAssertions.assertSearchWithResults("Picker != \"TestValue\"", "HSP-18");
        this.issueTableAssertions.assertSearchWithResults("cf[10050] != \"TestValue\"", "HSP-18");
        this.issueTableAssertions.assertSearchWithResults("cf[10051] != \"TestValue\"", "HSP-18");
        this.issueTableAssertions.assertSearchWithResults("Picker is empty", "MKY-2", "MKY-1", "HSP-16", "HSP-15", "HSP-14", "HSP-12", "HSP-11", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.issueTableAssertions.assertSearchWithResults("cf[10050] is empty", "MKY-2", "MKY-1", "HSP-14", "HSP-12", "HSP-11", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.issueTableAssertions.assertSearchWithResults("cf[10051] is empty", "MKY-2", "MKY-1", "HSP-16", "HSP-15", "HSP-12", "HSP-11", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.issueTableAssertions.assertSearchWithResults("Picker is not empty", "HSP-18", "HSP-17", "HSP-16", "HSP-15", "HSP-14", "HSP-13");
        this.issueTableAssertions.assertSearchWithResults("cf[10050] is not empty", "HSP-18", "HSP-17", "HSP-16", "HSP-15", "HSP-13");
        this.issueTableAssertions.assertSearchWithResults("cf[10051] is not empty", "HSP-18", "HSP-17", "HSP-14", "HSP-13");
        this.issueTableAssertions.assertSearchWithError("Picker in (\"New Version 1\")", "The value 'New Version 1' does not exist for the field 'Picker'.");
        this.issueTableAssertions.assertSearchWithError("cf[10051] in (\"New Version 1\")", "The value 'New Version 1' does not exist for the field 'cf[10051]'.");
        this.issueTableAssertions.assertSearchWithResults("cf[10050] in (\"New Version 1\")", "HSP-18", "HSP-17");
        this.jqlAssertions.assertFitsFilterForm("cf[10050] = \"New Version 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        IssueNavigatorAssertions.FilterFormParam param1 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000");
        IssueNavigatorAssertions.FilterFormParam param2 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10050", "10000");
        this.jqlAssertions.assertFitsFilterForm("cf[10050] in (\"New Version 1\") AND project = \"Homosapien\"", param1, param2);
        this.jqlAssertions.assertTooComplex("cf[10051] in (\"TestValue\")");
        this.jqlAssertions.assertFitsFilterForm("cf[10051] = \"TestValue\"", new IssueNavigatorAssertions.FilterFormParam[0]);
    }

    @Test
    public void testBadCustomFieldName() throws Exception {
        this.issueTableAssertions.assertSearchWithResults("summary ~ match", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("cf[10070] ~ match", "HSP-8");
        this.issueTableAssertions.assertSearchWithResults("cf[10071] ~ match", "HSP-14");
    }
}

