/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.assertions.JqlAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@RestoreOnce(value="TestCustomFieldDoesItFitMultiple.xml")
@LoginAs(user="admin")
public class TestCustomFieldDoesItFitMultiple
extends BaseJiraFuncTest {
    @Inject
    protected Administration administration;
    @Inject
    private JqlAssertions jqlAssertions;
    @Inject
    private FuncTestLogger logger;
    private static final String TYPE_BUG = "1";
    private static final String TYPE_TASK = "3";

    @Before
    public void setUpTest() {
        this.backdoor.darkFeatures().disableForSite(FeatureFlag.featureFlag((String)"jira.customfields.dual.list.box"));
    }

    @Test
    public void testCascadingSelect() throws Exception {
        String customFieldId = "10000";
        IssueNavigatorAssertions.FilterFormParam diffParent1 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10000", "10097");
        IssueNavigatorAssertions.FilterFormParam diffParent2 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10000", "10101");
        IssueNavigatorAssertions.FilterFormParam diffChild2 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10000:1", "10099");
        IssueNavigatorAssertions.FilterFormParam diffChild4 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10000:1", "10105");
        this.jqlAssertions.assertFitsFilterForm("project = twentyone and CSF in cascadeOption(10101)", diffParent2);
        this.jqlAssertions.assertFitsFilterForm("project = twentyone and CSF in cascadeOption(10101, 10105)", diffParent2, diffChild4);
        this.jqlAssertions.assertFitsFilterForm("issuetype = bug and CSF in cascadeOption(10097)", diffParent1);
        this.jqlAssertions.assertFitsFilterForm("issuetype = bug and CSF in cascadeOption(10097, 10099)", diffParent1, diffChild2);
        this.jqlAssertions.assertFitsFilterForm("project = twentyone and issuetype = bug and CSF in cascadeOption(10101)", diffParent2);
        this.jqlAssertions.assertFitsFilterForm("project = twentyone and issuetype = bug and CSF in cascadeOption(10101, 10105)", diffParent2, diffChild4);
        this.jqlAssertions.assertFitsFilterForm("issuetype = bug and CSF in cascadeOption(10101)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("issuetype = bug and CSF in cascadeOption(10101, 10104)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("issuetype = bug and CSF in cascadeOption(10101, 10105)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("project = twentyone and CSF in cascadeOption(10097)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("project = twentyone and CSF in cascadeOption(10097, 10098)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("project = twentyone and CSF in cascadeOption(10097, 10099)", new IssueNavigatorAssertions.FilterFormParam[0]);
        IssueNavigatorAssertions.FilterFormParam formParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10000", "10100");
        String proj1 = "10031";
        String proj2 = "10020";
        String fieldConfigSchemeId = "10061";
        List<CustomFieldContext> contexts = this.generateContexts(proj1, proj2, TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("CSF = 10100", proj1, proj2, TYPE_BUG, TYPE_TASK);
        this.administration.customFields().removeConfigurationSchemeContextById("10000", "10060");
        this.assertQueriesInContexts(contexts, queries, formParam, "10000", fieldConfigSchemeId);
    }

    @Test
    public void testDatePicker() throws Exception {
        String customFieldId = "10001";
        String fieldConfigSchemeId = "10031";
        IssueNavigatorAssertions.FilterFormParam afterAbs = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10001:after", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeAbs = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10001:before", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeRel = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10001:next", "1d");
        IssueNavigatorAssertions.FilterFormParam afterRel = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10001:previous", "1d");
        IssueNavigatorAssertions.FilterFormParam projParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10011");
        this.jqlAssertions.assertFitsFilterForm("project = TWO AND DP >= '2009-05-11' AND DP <= '2009-05-11'", projParam, afterAbs, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("project = TWO AND DP >= '2009-05-11' AND DP <= '1d'", projParam, afterAbs, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("project = TWO AND DP >= '1d' AND DP <= '2009-05-11'", projParam, afterRel, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("project = TWO AND DP >= '1d' AND DP <= '1d'", projParam, afterRel, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("project = TWO AND DP >= '2009-05-11' AND DP <= '2009-05-11' AND DP >= '1d'", projParam, afterAbs, beforeAbs, afterRel);
        this.jqlAssertions.assertFitsFilterForm("project = TWO AND DP >= '2009-05-11' AND DP <= '2009-05-11' AND DP <= '1d'", projParam, afterAbs, beforeAbs, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("project = TWO AND DP >= '1d' AND DP <= '2009-05-11' AND DP >= '2009-05-11'", projParam, afterRel, beforeAbs, afterAbs);
        this.jqlAssertions.assertFitsFilterForm("project = TWO AND DP >= '1d' AND DP <= '1d' AND DP <= '2009-05-11'", projParam, afterRel, beforeRel, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("project = TWO AND DP >= '1d' AND DP <= '1d' AND DP >= '2009-05-11' AND DP <= '2009-05-11'", projParam, afterRel, beforeRel, afterAbs, beforeAbs);
        this.jqlAssertions.assertTooComplex("project = TWO AND (DP >= '1d' OR DP <= '1d')");
        this.jqlAssertions.assertTooComplex("project = TWO AND DP >= '1d' AND DP >= '2d'");
        this.jqlAssertions.assertTooComplex("project = TWO AND DP <= '1d' AND DP <= '2d'");
        this.jqlAssertions.assertTooComplex("project = TWO AND DP > '1d' AND DP <= '1d' AND DP >= '2009-05-11' AND DP <= '2009-05-11'");
        this.jqlAssertions.assertTooComplex("project = TWO AND DP >= 1234567890 AND DP <= '1d' AND DP >= '2009-05-11' AND DP <= '2009-05-11'");
        this.jqlAssertions.assertFitsFilterForm("(project = TWO AND DP <= '1d') AND (status = Open AND DP <= '2009-05-11')", projParam, IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", TYPE_BUG), beforeRel, beforeAbs);
        this.jqlAssertions.assertTooComplex("project = TWO OR DP <= '1d'");
        String proj1 = "10011";
        String proj2 = "10012";
        List<CustomFieldContext> contexts = this.generateContexts("10011", "10012", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("DP <= '1d'", "10011", "10012", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, beforeRel, "10001", "10031");
    }

    @Test
    public void testDateTime() throws Exception {
        String customFieldId = "10002";
        String fieldConfigSchemeId = "10032";
        IssueNavigatorAssertions.FilterFormParam afterAbs = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10002:after", "11/May/09 12:00 AM");
        IssueNavigatorAssertions.FilterFormParam beforeAbs = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10002:before", "11/May/09 12:00 AM");
        IssueNavigatorAssertions.FilterFormParam beforeRel = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10002:next", "1d");
        IssueNavigatorAssertions.FilterFormParam afterRel = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10002:previous", "1d");
        IssueNavigatorAssertions.FilterFormParam projParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10012");
        this.jqlAssertions.assertFitsFilterForm("project = THREE AND DT >= '2009-05-11' AND DT <= '2009-05-11'", projParam, afterAbs, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("project = THREE AND DT >= '2009-05-11' AND DT <= '1d'", projParam, afterAbs, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("project = THREE AND DT >= '1d' AND DT <= '2009-05-11'", projParam, afterRel, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("project = THREE AND DT >= '1d' AND DT <= '1d'", projParam, afterRel, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("project = THREE AND DT >= '2009-05-11' AND DT <= '2009-05-11' AND DT >= '1d'", projParam, afterAbs, beforeAbs, afterRel);
        this.jqlAssertions.assertFitsFilterForm("project = THREE AND DT >= '2009-05-11' AND DT <= '2009-05-11' AND DT <= '1d'", projParam, afterAbs, beforeAbs, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("project = THREE AND DT >= '1d' AND DT <= '2009-05-11' AND DT >= '2009-05-11'", projParam, afterRel, beforeAbs, afterAbs);
        this.jqlAssertions.assertFitsFilterForm("project = THREE AND DT >= '1d' AND DT <= '1d' AND DT <= '2009-05-11'", projParam, afterRel, beforeRel, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("project = THREE AND DT >= '1d' AND DT <= '1d' AND DT >= '2009-05-11' AND DT <= '2009-05-11'", projParam, afterRel, beforeRel, afterAbs, beforeAbs);
        this.jqlAssertions.assertTooComplex("project = THREE AND (DT >= '1d' OR DT <= '1d')");
        this.jqlAssertions.assertTooComplex("project = THREE AND DT >= '1d' AND DT >= '2d'");
        this.jqlAssertions.assertTooComplex("project = THREE AND DT <= '1d' AND DT <= '2d'");
        this.jqlAssertions.assertTooComplex("project = THREE AND DT > '1d' AND DT <= '1d' AND DT >= '2009-05-11' AND DT <= '2009-05-11'");
        this.jqlAssertions.assertTooComplex("project = THREE AND DT >= 1234567890 AND DT <= '1d' AND DT >= '2009-05-11' AND DT <= '2009-05-11'");
        this.jqlAssertions.assertFitsFilterForm("(project = THREE AND DT <= '1d') AND (status = Open AND DT <= '2009-05-11')", projParam, IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", TYPE_BUG), beforeRel, beforeAbs);
        this.jqlAssertions.assertTooComplex("project = THREE OR DT <= '1d'");
        String proj1 = "10012";
        String proj2 = "10013";
        List<CustomFieldContext> contexts = this.generateContexts("10012", "10013", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("DT <= '1d'", "10012", "10013", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, beforeRel, "10002", "10032");
    }

    @Test
    public void testFreeTextField() throws Exception {
        String customFieldId = "10003";
        String fieldConfigSchemeId = "10033";
        IssueNavigatorAssertions.FilterFormParam cfParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10003", "qwerty");
        this.jqlAssertions.assertTooComplex("project = FOUR OR FTF ~ 'qwerty'");
        this.jqlAssertions.assertTooComplex("project = FOUR AND FTF ~ 'qwerty' AND FTF ~ 'qwerty2'");
        String proj1 = "10013";
        String proj2 = "10014";
        List<CustomFieldContext> contexts = this.generateContexts("10013", "10014", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("FTF ~ 'qwerty'", "10013", "10014", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam, "10003", "10033");
    }

    @Test
    public void testGroupPicker() throws Exception {
        String customFieldId = "10004";
        String fieldConfigSchemeId = "10034";
        IssueNavigatorAssertions.FilterFormParam cfParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10004", "jira-users");
        this.jqlAssertions.assertTooComplex("project = FIVE OR GP = 'jira-users'");
        this.jqlAssertions.assertTooComplex("project = FIVE AND GP = 'jira-users' AND GP = 'jira-users'");
        String proj1 = "10014";
        String proj2 = "10015";
        List<CustomFieldContext> contexts = this.generateContexts("10014", "10015", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("GP = 'jira-users'", "10014", "10015", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam, "10004", "10034");
    }

    @Test
    public void testImportId() throws Exception {
        String customFieldId = "10005";
        String fieldConfigSchemeId = "10035";
        IssueNavigatorAssertions.FilterFormParam cfParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10005", "123456");
        this.jqlAssertions.assertTooComplex("project = SIX OR II = 123456");
        this.jqlAssertions.assertTooComplex("project = SIX AND II = 123456 AND II = 123456");
        String proj1 = "10015";
        String proj2 = "10016";
        List<CustomFieldContext> contexts = this.generateContexts("10015", "10016", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("II = 123456", "10015", "10016", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam, "10005", "10035");
    }

    @Test
    public void testMultiCheckbox() throws Exception {
        String customFieldId = "10006";
        String fieldConfigSchemeId = "10036";
        String proj1 = "10016";
        String proj2 = "10017";
        IssueNavigatorAssertions.FilterFormParam cfParam3a = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10006", "10031");
        IssueNavigatorAssertions.FilterFormParam cfParam3b = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10006", "10110");
        IssueNavigatorAssertions.FilterFormParam cfParam4 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10006", "10032");
        IssueNavigatorAssertions.FilterFormParam cfParam5 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10006", "10111");
        IssueNavigatorAssertions.FilterFormParam cfParamCombined1 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10006", "10031", "10032");
        IssueNavigatorAssertions.FilterFormParam cfParamCombined2 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10006", "10110", "10111");
        IssueNavigatorAssertions.FilterFormParam projParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10016");
        IssueNavigatorAssertions.FilterFormParam typeParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", TYPE_BUG);
        this.jqlAssertions.assertFitsFilterForm("project = SEVEN AND MC = opt4", cfParam4, projParam);
        this.jqlAssertions.assertInvalidValue("project = SEVEN AND MC = opt5");
        this.jqlAssertions.assertFitsFilterForm("type = Bug AND MC = opt5", cfParam5, typeParam);
        this.jqlAssertions.assertInvalidValue("type = Bug AND MC = opt4");
        this.jqlAssertions.assertFitsFilterForm("project = SEVEN AND MC = opt3", projParam, cfParam3a);
        this.jqlAssertions.assertFitsFilterForm("project = SEVEN AND MC IN (opt3, opt4)", projParam, cfParamCombined1);
        this.jqlAssertions.assertInvalidValue("project = SEVEN AND MC IN (opt3, opt5)");
        this.jqlAssertions.assertFitsFilterForm("type = Bug AND MC = opt3", typeParam, cfParam3b);
        this.jqlAssertions.assertFitsFilterForm("type = Bug AND MC IN (opt3, opt5)", typeParam, cfParamCombined2);
        this.jqlAssertions.assertInvalidValue("type = Bug AND MC IN (opt3, opt4)");
        this.jqlAssertions.assertFitsFilterForm("project = SEVEN AND type = Bug AND MC = opt3", projParam, typeParam, cfParam3a);
        this.jqlAssertions.assertFitsFilterForm("project = SEVEN AND type = Bug AND MC IN (opt3, opt4)", projParam, typeParam, cfParamCombined1);
        this.jqlAssertions.assertInvalidValue("project = SEVEN AND type = Bug AND MC IN (opt3, opt5)");
        this.jqlAssertions.assertTooComplex("project = SEVEN OR MC = opt4");
        this.jqlAssertions.assertTooComplex("project = SEVEN AND MC = opt4 AND MC = opt4");
        this.jqlAssertions.assertTooComplex("project = SEVEN AND (MC = opt4 OR MC = opt4)");
        this.administration.customFields().removeConfigurationSchemeContextById("10006", "10070");
        List<CustomFieldContext> contexts = this.generateContexts("10016", "10017", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("MC = opt4", "10016", "10017", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam4, "10006", "10036");
    }

    @Test
    public void testMultiGroupPicker() throws Exception {
        String customFieldId = "10007";
        String fieldConfigSchemeId = "10037";
        IssueNavigatorAssertions.FilterFormParam cfParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10007", "jira-users");
        this.jqlAssertions.assertTooComplex("project = EIGHT OR MGP = 'jira-users'");
        this.jqlAssertions.assertTooComplex("project = EIGHT AND MGP = 'jira-users' AND MGP = 'jira-users'");
        String proj1 = "10017";
        String proj2 = "10018";
        List<CustomFieldContext> contexts = this.generateContexts("10017", "10018", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("MGP = 'jira-users'", "10017", "10018", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam, "10007", "10037");
    }

    @Test
    public void testMultiSelect() throws Exception {
        String customFieldId = "10008";
        String fieldConfigSchemeId = "10038";
        String proj1 = "10018";
        String proj2 = "10019";
        IssueNavigatorAssertions.FilterFormParam projParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10018");
        IssueNavigatorAssertions.FilterFormParam typeParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", TYPE_BUG);
        IssueNavigatorAssertions.FilterFormParam cfParam3a = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10008", "10033");
        IssueNavigatorAssertions.FilterFormParam cfParam3b = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10008", "10060");
        IssueNavigatorAssertions.FilterFormParam cfParam4 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10008", "10034");
        IssueNavigatorAssertions.FilterFormParam cfParam5 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10008", "10061");
        IssueNavigatorAssertions.FilterFormParam cfParamCombined1 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10008", "10033", "10034");
        IssueNavigatorAssertions.FilterFormParam cfParamCombined2 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10008", "10060", "10061");
        this.jqlAssertions.assertFitsFilterForm("project = NINE AND MS = select4", cfParam4, projParam);
        this.jqlAssertions.assertInvalidValue("project = NINE AND MS = select5");
        this.jqlAssertions.assertFitsFilterForm("type = Bug AND MS = select5", cfParam5, typeParam);
        this.jqlAssertions.assertInvalidValue("type = Bug AND MS = select4");
        this.jqlAssertions.assertFitsFilterForm("project = NINE AND MS = select3", projParam, cfParam3a);
        this.jqlAssertions.assertFitsFilterForm("project = NINE AND MS IN (select3, select4)", projParam, cfParamCombined1);
        this.jqlAssertions.assertInvalidValue("project = NINE AND MS IN (select3, select5)");
        this.jqlAssertions.assertFitsFilterForm("type = Bug AND MS = select3", typeParam, cfParam3b);
        this.jqlAssertions.assertFitsFilterForm("type = Bug AND MS IN (select3, select5)", typeParam, cfParamCombined2);
        this.jqlAssertions.assertInvalidValue("type = Bug AND MS IN (select3, select4)");
        this.jqlAssertions.assertFitsFilterForm("project = NINE AND type = Bug AND MS = select3", projParam, typeParam, cfParam3a);
        this.jqlAssertions.assertFitsFilterForm("project = NINE AND type = Bug AND MS IN (select3, select4)", projParam, typeParam, cfParamCombined1);
        this.jqlAssertions.assertInvalidValue("project = NINE AND type = Bug AND MS IN (select3, select5)");
        this.jqlAssertions.assertTooComplex("project = NINE OR MS = select4");
        this.jqlAssertions.assertTooComplex("project = NINE AND MS = select4 AND MS = select4");
        this.jqlAssertions.assertTooComplex("project = NINE AND (MS = select4 OR MS = select4)");
        this.administration.customFields().removeConfigurationSchemeContextById("10008", "10018");
        List<CustomFieldContext> contexts = this.generateContexts("10018", "10019", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("MS = select4", "10018", "10019", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam4, "10008", "10038");
    }

    @Test
    public void testMultiUserPicker() throws Exception {
        String customFieldId = "10009";
        String fieldConfigSchemeId = "10039";
        IssueNavigatorAssertions.FilterFormParam cfParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10009", "admin");
        this.jqlAssertions.assertTooComplex("project = TEN OR MUP = admin");
        this.jqlAssertions.assertTooComplex("project = TEN AND MUP = admin AND MUP = fred");
        String proj1 = "10019";
        String proj2 = "10020";
        List<CustomFieldContext> contexts = this.generateContexts("10019", "10020", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("MUP = admin", "10019", "10020", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam, "10009", "10039");
    }

    @Test
    public void testNumberField() throws Exception {
        String customFieldId = "10010";
        String fieldConfigSchemeId = "10040";
        String proj1 = "10020";
        String proj2 = "10021";
        IssueNavigatorAssertions.FilterFormParam cfParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10010", "10");
        IssueNavigatorAssertions.FilterFormParam cfParamMin = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10010:greaterThan", "10");
        IssueNavigatorAssertions.FilterFormParam cfParamMax = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10010:lessThan", "20");
        IssueNavigatorAssertions.FilterFormParam projParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10020");
        this.jqlAssertions.assertTooComplex("project = ELEVEN OR NF = 10");
        this.jqlAssertions.assertTooComplex("project = ELEVEN AND NF = 10 AND NF = 12");
        String oldSearcher = this.administration.customFields().setCustomFieldSearcher("10010", "com.atlassian.jira.plugin.system.customfieldtypes:numberrange");
        this.jqlAssertions.assertFitsFilterForm("project = ELEVEN AND NF >= 10 AND NF <= 20", projParam, cfParamMin, cfParamMax);
        this.jqlAssertions.assertTooComplex("project = ELEVEN AND (NF >= 10 OR NF <= 20)");
        this.jqlAssertions.assertTooComplex("project = ELEVEN AND NF >= 10 AND NF >= 20");
        this.jqlAssertions.assertTooComplex("project = ELEVEN AND NF <= 10 AND NF <= 20");
        this.jqlAssertions.assertTooComplex("project = ELEVEN AND NF > 10 AND NF <= 20");
        this.jqlAssertions.assertFitsFilterForm("(project = ELEVEN AND NF >= 10) AND (status = Open AND NF <= 20)", projParam, IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", TYPE_BUG), cfParamMin, cfParamMax);
        this.administration.customFields().setCustomFieldSearcher("10010", oldSearcher);
        List<CustomFieldContext> contexts = this.generateContexts("10020", "10021", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("NF = 10", "10020", "10021", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam, "10010", "10040");
    }

    @Test
    public void testProjectPicker() throws Exception {
        String customFieldId = "10011";
        String fieldConfigSchemeId = "10041";
        IssueNavigatorAssertions.FilterFormParam cfParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10011", "10012");
        this.jqlAssertions.assertTooComplex("project = TWELVE OR PP = three");
        this.jqlAssertions.assertTooComplex("project = TWELVE AND PP = three AND PP = four");
        String proj1 = "10021";
        String proj2 = "10022";
        List<CustomFieldContext> contexts = this.generateContexts("10021", "10022", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("PP = three", "10021", "10022", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam, "10011", "10041");
    }

    @Test
    public void testRadioButton() throws Exception {
        String customFieldId = "10012";
        String fieldConfigSchemeId = "10022";
        String proj1 = "10022";
        String proj2 = "10023";
        IssueNavigatorAssertions.FilterFormParam projParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10022");
        IssueNavigatorAssertions.FilterFormParam typeParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", TYPE_BUG);
        IssueNavigatorAssertions.FilterFormParam cfParam1a = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10012", "10006");
        IssueNavigatorAssertions.FilterFormParam cfParam1b = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10012", "10080");
        IssueNavigatorAssertions.FilterFormParam cfParam2 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10012", "10007");
        IssueNavigatorAssertions.FilterFormParam cfParam3 = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10012", "10035");
        this.jqlAssertions.assertFitsFilterForm("project = THIRTEEN AND RB = rad2", cfParam2, projParam);
        this.jqlAssertions.assertInvalidValue("project = THIRTEEN AND RB = rad3");
        this.jqlAssertions.assertFitsFilterForm("type = Bug AND RB = rad3", cfParam3, typeParam);
        this.jqlAssertions.assertInvalidValue("type = Bug AND RB = rad2");
        this.jqlAssertions.assertFitsFilterForm("project = THIRTEEN AND RB = rad1", projParam, cfParam1a);
        this.jqlAssertions.assertFitsFilterForm("project = THIRTEEN AND RB IN (rad1, rad2)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertInvalidValue("project = THIRTEEN AND RB IN (rad1, rad3)");
        this.jqlAssertions.assertFitsFilterForm("type = Bug AND RB = rad1", typeParam, cfParam1b);
        this.jqlAssertions.assertFitsFilterForm("type = Bug AND RB IN (rad1, rad3)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertInvalidValue("type = Bug AND RB IN (rad1, rad2)");
        this.jqlAssertions.assertFitsFilterForm("project = THIRTEEN AND type = Bug AND RB = rad1", projParam, typeParam, cfParam1a);
        this.jqlAssertions.assertFitsFilterForm("project = THIRTEEN AND type = Bug AND RB IN (rad1, rad2)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertInvalidValue("project = THIRTEEN AND type = Bug AND RB IN (rad1, rad3)");
        this.jqlAssertions.assertTooComplex("project = THIRTEEN OR RB = rad2");
        this.jqlAssertions.assertTooComplex("project = THIRTEEN AND RB = rad2 AND RB = rad2");
        this.jqlAssertions.assertTooComplex("project = THIRTEEN AND (RB = rad2 OR RB = rad2)");
        this.administration.customFields().removeConfigurationSchemeContextById("10012", "10042");
        List<CustomFieldContext> contexts = this.generateContexts("10022", "10023", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("RB = rad2", "10022", "10023", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam2, "10012", "10022");
    }

    @Test
    public void testReadOnlyTextField() throws Exception {
        String customFieldId = "10013";
        String fieldConfigSchemeId = "10043";
        IssueNavigatorAssertions.FilterFormParam cfParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10013", "text");
        this.jqlAssertions.assertTooComplex("project = FOURTEEN OR ROTF ~ text");
        this.jqlAssertions.assertTooComplex("project = FOURTEEN AND ROTF ~ text AND ROTF ~ four");
        String proj1 = "10023";
        String proj2 = "10024";
        List<CustomFieldContext> contexts = this.generateContexts("10023", "10024", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("ROTF ~ text", "10023", "10024", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam, "10013", "10043");
    }

    @Test
    public void testSingleVersionPicker() throws Exception {
        String customFieldId = "10015";
        String fieldConfigSchemeId = "10045";
        String proj1 = "10025";
        String proj2 = "10029";
        IssueNavigatorAssertions.FilterFormParam cfParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10015", "10010");
        IssueNavigatorAssertions.FilterFormParam projParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10025");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN OR SVP = 10010");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP = 10010 AND SVP = 10010");
        this.jqlAssertions.assertFitsFilterForm("project = SIXTEEN AND SVP = v1", projParam, cfParam);
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP = 10010");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP != 10010");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP >= 10010");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP > 10010");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP <= 10010");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP < 10010");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP is EMPTY");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP is not EMPTY");
        this.jqlAssertions.assertFitsFilterForm("project = SIXTEEN AND SVP in (v1, v2)", projParam, IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10015", "v1", "v2"));
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP in (10010, 10011)");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP not in (10010, 10011)");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP in releasedVersions(SIXTEEN)");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP in releasedVersions()");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP not in releasedVersions()");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP in unreleasedVersions(SIXTEEN)");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP in unreleasedVersions()");
        this.jqlAssertions.assertTooComplex("project = SIXTEEN AND SVP not in unreleasedVersions()");
        List<CustomFieldContext> contexts = this.generateContexts("10025", "10029", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueriesForVersion("SVP = v1", "10010", "10013", "10015", "10025", "10029", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, null, "10015", "10045");
    }

    @Test
    public void testTextField() throws Exception {
        String customFieldId = "10016";
        String fieldConfigSchemeId = "10046";
        IssueNavigatorAssertions.FilterFormParam cfParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10016", "text");
        this.jqlAssertions.assertTooComplex("project = SEVENTEEN OR TF ~ text");
        this.jqlAssertions.assertTooComplex("project = SEVENTEEN AND TF ~ text AND TF ~ xxxx");
        String proj1 = "10026";
        String proj2 = "10027";
        List<CustomFieldContext> contexts = this.generateContexts("10026", "10027", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("TF ~ text", "10026", "10027", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam, "10016", "10046");
    }

    @Test
    public void testUserPicker() throws Exception {
        String customFieldId = "10018";
        String fieldConfigSchemeId = "10047";
        IssueNavigatorAssertions.FilterFormParam cfParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10018", "admin");
        this.jqlAssertions.assertTooComplex("project = EIGHTEEN OR UP = admin");
        this.jqlAssertions.assertTooComplex("project = EIGHTEEN AND UP = admin AND UP = fred");
        String proj1 = "10027";
        String proj2 = "10028";
        List<CustomFieldContext> contexts = this.generateContexts("10027", "10028", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("UP = admin", "10027", "10028", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam, "10018", "10047");
    }

    @Test
    public void testUrlField() throws Exception {
        String customFieldId = "10017";
        String fieldConfigSchemeId = "10048";
        IssueNavigatorAssertions.FilterFormParam cfParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10017", "http://www.atlassian.com");
        this.jqlAssertions.assertTooComplex("project = NINETEEN OR URL = 'http://www.atlassian.com'");
        this.jqlAssertions.assertTooComplex("project = NINETEEN AND URL = 'http://www.atlassian.com' AND URL = 'http://www.atlassian.com'");
        String proj1 = "10028";
        String proj2 = "10029";
        List<CustomFieldContext> contexts = this.generateContexts("10028", "10029", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueries("URL = 'http://www.atlassian.com'", "10028", "10029", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, cfParam, "10017", "10048");
    }

    @Test
    public void testVersionPicker() throws Exception {
        String customFieldId = "10019";
        String fieldConfigSchemeId = "10049";
        String proj1 = "10029";
        String proj2 = "10025";
        IssueNavigatorAssertions.FilterFormParam cfParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10019", "10013");
        IssueNavigatorAssertions.FilterFormParam projParam = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10029");
        this.jqlAssertions.assertTooComplex("project = TWENTY OR VP = 10013");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP = 10013 AND VP = 10013");
        this.jqlAssertions.assertFitsFilterForm("project = TWENTY AND VP = v1", projParam, cfParam);
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP = 10013");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP != 10013");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP >= 10013");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP > 10013");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP <= 10013");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP < 10013");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP is EMPTY");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP is not EMPTY");
        this.jqlAssertions.assertFitsFilterForm("project = TWENTY AND VP in (v1, v2)", projParam, IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_10019", "10013", "10014"));
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP in (10013, 10014)");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP not in (10013, 10014)");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP in releasedVersions(TWENTY)");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP in releasedVersions()");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP not in releasedVersions()");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP in unreleasedVersions(TWENTY)");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP in unreleasedVersions()");
        this.jqlAssertions.assertTooComplex("project = TWENTY AND VP not in unreleasedVersions()");
        List<CustomFieldContext> contexts = this.generateContexts("10029", "10025", TYPE_BUG, TYPE_TASK);
        List<Query> queries = this.generateQueriesForVersion("VP = v1", "10013", "10010", "10019", "10029", "10025", TYPE_BUG, TYPE_TASK);
        this.assertQueriesInContexts(contexts, queries, null, "10019", "10049");
    }

    private void assertQueriesInContexts(List<CustomFieldContext> contexts, List<Query> queries, IssueNavigatorAssertions.FilterFormParam cfParam, String customFieldId, String fieldConfigSchemeId) {
        for (CustomFieldContext context : contexts) {
            List<String> issueTypes = context.getIssueTypes();
            String[] issueTypeIds = issueTypes == null ? new String[]{} : issueTypes.toArray(new String[issueTypes.size()]);
            List<String> projects = context.getProjects();
            String[] projectIds = projects == null ? new String[]{} : projects.toArray(new String[projects.size()]);
            this.logger.log((Object)"");
            this.logger.log((Object)("Setting up context: " + context));
            this.logger.log((Object)"");
            this.administration.customFields().editConfigurationSchemeContextById(customFieldId, fieldConfigSchemeId, null, issueTypeIds, projectIds);
            for (Query query : queries) {
                String jql = query.getJql();
                if (query.shouldFit(context)) {
                    ArrayList<IssueNavigatorAssertions.FilterFormParam> params = new ArrayList<IssueNavigatorAssertions.FilterFormParam>();
                    if (cfParam != null) {
                        params.add(cfParam);
                    }
                    params.addAll(query.getParams());
                    this.jqlAssertions.assertFitsFilterForm(jql, params.toArray(new IssueNavigatorAssertions.FilterFormParam[params.size()]));
                    continue;
                }
                this.jqlAssertions.assertInvalidContext(jql);
            }
        }
    }

    private List<CustomFieldContext> generateContexts(String proj1, String proj2, String type1, String type2) {
        ArrayList<CustomFieldContext> contexts = new ArrayList<CustomFieldContext>();
        contexts.add(new CustomFieldContext(Arrays.asList(proj1), null));
        contexts.add(new CustomFieldContext(Arrays.asList(proj1, proj2), null));
        contexts.add(new CustomFieldContext(Arrays.asList(proj1), Arrays.asList(type1)));
        contexts.add(new CustomFieldContext(Arrays.asList(proj1, proj2), Arrays.asList(type1)));
        contexts.add(new CustomFieldContext(Arrays.asList(proj1), Arrays.asList(type1, type2)));
        contexts.add(new CustomFieldContext(Arrays.asList(proj1, proj2), Arrays.asList(type1, type2)));
        contexts.add(new CustomFieldContext(null, Arrays.asList(type1)));
        contexts.add(new CustomFieldContext(null, Arrays.asList(type1, type2)));
        return contexts;
    }

    private List<Query> generateQueries(String cfClause, String proj1, String proj2, String type1, String type2) {
        List<List<String>> projects = this.generateCombinationLists(proj1, proj2);
        List<List<String>> issueTypes = this.generateCombinationLists(type1, type2);
        ArrayList<Query> list = new ArrayList<Query>();
        for (List<String> issueType : issueTypes) {
            for (List<String> project : projects) {
                if (issueType == null && project == null) continue;
                list.add(new Query(project, issueType, cfClause));
            }
        }
        return list;
    }

    private List<Query> generateQueriesForVersion(String cfClause, final String version1, final String version2, final String customFieldId, final String proj1, final String proj2, String type1, String type2) {
        List<List<String>> projects = this.generateCombinationLists(proj1, proj2);
        List<List<String>> issueTypes = this.generateCombinationLists(type1, type2);
        ArrayList<Query> list = new ArrayList<Query>();
        for (List<String> issueType : issueTypes) {
            for (final List<String> project : projects) {
                if (issueType == null && project == null) continue;
                list.add(new Query(project, issueType, cfClause){

                    @Override
                    public List<IssueNavigatorAssertions.FilterFormParam> getParams() {
                        List<IssueNavigatorAssertions.FilterFormParam> paramList = super.getParams();
                        if (project != null) {
                            if (project.contains(proj1) && project.contains(proj2)) {
                                paramList.add(IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_" + customFieldId, version1, version2));
                            } else if (project.contains(proj1)) {
                                paramList.add(IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_" + customFieldId, version1));
                            } else if (project.contains(proj2)) {
                                paramList.add(IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("customfield_" + customFieldId, version2));
                            }
                        }
                        return paramList;
                    }
                });
            }
        }
        return list;
    }

    private List<List<String>> generateCombinationLists(String s1, String s2) {
        ArrayList<List<String>> projects = new ArrayList<List<String>>();
        projects.add(null);
        projects.add(Collections.singletonList(s1));
        projects.add(Collections.singletonList(s2));
        projects.add(Arrays.asList(s1, s2));
        return projects;
    }

    private static class CustomFieldContext {
        private List<String> projects;
        private List<String> issueTypes;

        private CustomFieldContext(List<String> projects, List<String> issueTypes) {
            this.projects = projects;
            this.issueTypes = issueTypes;
        }

        public List<String> getProjects() {
            return this.projects;
        }

        public List<String> getIssueTypes() {
            return this.issueTypes;
        }

        public String toString() {
            return "CustomFieldContext{projects=" + this.projects + ", issueTypes=" + this.issueTypes + '}';
        }
    }

    private static class Query {
        private List<String> projects;
        private List<String> issueTypes;
        private String cfClause;

        private Query(List<String> projects, List<String> issueTypes, String cfClause) {
            this.projects = projects;
            this.issueTypes = issueTypes;
            this.cfClause = cfClause;
        }

        public String getJql() {
            StringBuilder sb = new StringBuilder(this.cfClause);
            this.addClauseToJql(sb, "project", this.projects);
            this.addClauseToJql(sb, "type", this.issueTypes);
            return sb.toString();
        }

        public List<IssueNavigatorAssertions.FilterFormParam> getParams() {
            String[] values;
            ArrayList<IssueNavigatorAssertions.FilterFormParam> params = new ArrayList<IssueNavigatorAssertions.FilterFormParam>();
            if (this.projects != null) {
                values = new String[this.projects.size()];
                values = this.projects.toArray(values);
                params.add(IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", values));
            }
            if (this.issueTypes != null) {
                values = new String[this.issueTypes.size()];
                values = this.issueTypes.toArray(values);
                params.add(IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", values));
            }
            return params;
        }

        public boolean shouldFit(CustomFieldContext context) {
            boolean fit = true;
            if (context.getProjects() != null) {
                boolean bl = fit = this.projects != null && context.getProjects().containsAll(this.projects);
            }
            if (context.getIssueTypes() != null) {
                fit &= this.issueTypes != null && context.getIssueTypes().containsAll(this.issueTypes);
            }
            return fit;
        }

        private void addClauseToJql(StringBuilder sb, String clauseName, List<String> operands) {
            if (operands != null) {
                sb.append(" AND ").append(clauseName);
                if (operands.size() == 1) {
                    sb.append(" = ").append(operands.get(0));
                } else {
                    sb.append(" IN (").append(StringUtils.join(operands, (String)", ")).append(")");
                }
            }
        }

        public String toString() {
            return this.getJql();
        }
    }
}

