/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@LoginAs(user="admin")
public class TestFilters
extends BaseJiraFuncTest {
    @Inject
    private IssueTableAssertions issueTableAssertions;

    @Test
    @Restore(value="TestCustomFieldOptionsNoConfig.xml")
    public void testRunFilterWithCustomFieldOptionWithNoAssociatedConfig() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().loadFilter(10000L);
        this.tester.assertElementNotPresent("issuetable");
    }

    @Test
    @Restore(value="TestJqlFilters.xml")
    public void testInvalidatedFilters() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.loadInvalidatedFilter(10000L, "project = homosapien", "The value 'homosapien' does not exist for the field 'project'.", true);
        this.loadInvalidatedFilter(10001L, "issuetype = Bug", "The value 'Bug' does not exist for the field 'issuetype'.", true);
        this.loadInvalidatedFilter(10010L, "resolution = Duplicate", "The value 'Duplicate' does not exist for the field 'resolution'.", true);
        this.loadInvalidatedFilter(10011L, "votes > 0", "Field 'votes' does not exist or you do not have permission to view it.", true);
        this.loadInvalidatedFilter(10014L, "workratio = 10", "Field 'workratio' does not exist or you do not have permission to view it.", true);
        this.loadInvalidatedFilter(10020L, "affectedVersion = \"1.0\"", "The value '1.0' does not exist for the field 'affectedVersion'.", true);
        this.loadInvalidatedFilter(10021L, "fixVersion = \"1.0\"", "The value '1.0' does not exist for the field 'fixVersion'.", true);
        this.loadInvalidatedFilter(10022L, "status = \"Not Used\"", "The value 'Not Used' does not exist for the field 'status'.", true);
        this.loadInvalidatedFilter(10023L, "key = \"MKY-1\"", "An issue with key 'MKY-1' does not exist for field 'key'.", true);
        this.loadInvalidatedFilter(10024L, "component = CompA", "The value 'CompA' does not exist for the field 'component'.", true);
        this.loadInvalidatedFilter(10025L, "issue in watchedIssues()", "Function 'watchedIssues' cannot be called as watching issues is currently disabled.", true);
        this.loadInvalidatedFilter(10026L, "issue in votedIssues()", "Function 'votedIssues' cannot be called as voting on issues is currently disabled.", true);
        this.loadInvalidatedFilter(10027L, "issue in linkedIssues(\"MKY-2\")", "Function 'linkedIssues' cannot be called as issue linking is currently disabled.", true);
        this.loadInvalidatedFilter(10028L, "parent = \"MKY-2\"", "Field 'parent' does not exist or you do not have permission to view it.", true);
        this.loadInvalidatedFilter(10030L, "type in subtaskIssueTypes()", "Function 'subTaskIssueTypes' is invalid as sub-tasks are currently disabled.", true);
        this.loadInvalidatedFilter(10032L, "filter = 10031", "A value with ID '10031' does not exist for the field 'filter'.", true);
        this.loadInvalidatedFilter(10034L, "originalEstimate >= 5h", "Field 'originalEstimate' does not exist or you do not have permission to view it.", true);
        this.loadInvalidatedFilter(10035L, "remainingEstimate > 5h", "Field 'remainingEstimate' does not exist or you do not have permission to view it.", true);
        this.loadInvalidatedFilter(10036L, "timespent > 5h", "Field 'timespent' does not exist or you do not have permission to view it.", true);
        this.loadInvalidatedFilter(10038L, "affectedVersion in releasedVersions(deleted)", "Could not resolve the project 'deleted' provided to function 'releasedVersions'.", true);
        this.loadInvalidatedFilter(10039L, "affectedVersion in unreleasedVersions(deleted)", "Could not resolve the project 'deleted' provided to function 'unreleasedVersions'.", true);
        this.loadInvalidatedFilter(10040L, "level = SL1", "The value 'SL1' does not exist for the field 'level'.", true);
        this.loadInvalidatedFilter(10012L, "reporter = fred", "The value 'fred' does not exist for the field 'reporter'.", false);
        this.loadInvalidatedFilter(10013L, "assignee = fred", "The value 'fred' does not exist for the field 'assignee'.", false);
        this.loadInvalidatedFilter(10033L, "reporter in membersOf(\"jira-developers\")", "Function 'membersOf' cannot be called by user without 'Browse Users' global permission.", true);
        int userPickerKey = (Integer)GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.inverse().get((Object)GlobalPermissionKey.USER_PICKER);
        this.backdoor.permissions().addGlobalPermission(userPickerKey, "jira-administrators");
        this.loadInvalidatedFilter(10033L, "reporter in membersOf(\"jira-developers\")", "Function 'membersOf' can not generate a list of usernames for group 'jira-developers'; the group does not exist.", true);
        this.backdoor.permissions().removeGlobalPermission(userPickerKey, "jira-administrators");
    }

    @Test
    @Restore(value="TestJqlIllegalFilters.xml")
    public void testIllegalFilters() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.issueTableAssertions.assertSearchWithError(10000L, "The operator '~' is not supported by the 'cs' field.");
        this.issueTableAssertions.assertSearchWithError(10000L, "cs ~ cs ORDER BY key", "The operator '~' is not supported by the 'cs' field.");
    }

    private void loadInvalidatedFilter(long filterId, String JQL, String errorMessage, boolean expectError) {
        if (expectError) {
            this.issueTableAssertions.assertSearchWithError(filterId, errorMessage);
            this.issueTableAssertions.assertSearchWithError(filterId, JQL + " ORDER BY key", errorMessage);
        } else {
            this.issueTableAssertions.assertSearchWithWarning(filterId, errorMessage);
            this.issueTableAssertions.assertSearchWithWarning(filterId, JQL + " ORDER BY key", errorMessage);
        }
    }
}

