/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.UserPropertyClient;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestJqlRecentFieldsLoading
extends BaseJiraFuncTest {
    protected UserPropertyClient propertyClient;

    @Before
    public void setUp() {
        this.propertyClient = new UserPropertyClient(this.environmentData);
    }

    @Test
    public void shouldHaveDefaultRecentFieldsOnPage() {
        this.tester.gotoPage("issues/?jql=");
        this.tester.assertTextPresent("WRM._unparsedData[\"jira.core:jqlautocomplete-data.jql.autocomplete.recentFields\"]=\"{\\u0022key\\u0022:\\u0022jqlValues\\u0022,\\u0022value\\u0022:[\\u0022affectedVersion\\u0022,\\u0022assignee\\u0022,\\u0022component\\u0022,\\u0022description\\u0022,\\u0022issue\\u0022,\\u0022labels\\u0022,\\u0022parent\\u0022,\\u0022priority\\u0022,\\u0022project\\u0022,\\u0022reporter\\u0022,\\u0022resolution\\u0022,\\u0022status\\u0022,\\u0022summary\\u0022,\\u0022type\\u0022,\\u0022watcher\\u0022]}\"");
    }

    @Test
    public void shouldGetRecentFieldsFromUserProperties() {
        this.propertyClient.put("admin", "jqlValues", "[\"assignee\",\"project\"]");
        this.tester.gotoPage("issues/?jql=");
        this.tester.assertTextPresent("WRM._unparsedData[\"jira.core:jqlautocomplete-data.jql.autocomplete.recentFields\"]=\"{\\u0022key\\u0022:\\u0022jqlValues\\u0022,\\u0022value\\u0022:[\\u0022assignee\\u0022,\\u0022project\\u0022]}\"");
    }
}

