/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebResponse;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@LoginAs(user="admin")
public class TestQueryTooComplex
extends BaseJiraFuncTest {
    private static final int CLAUSES = 70000;
    private String reallyBloodyLongQuery;
    private String statusjQlQuery;
    @Inject
    private IssueTableAssertions issueTableAssertions;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.reallyBloodyLongQuery = this.createLongQuery();
        this.statusjQlQuery = "status was Open";
    }

    private String createLongQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("comment ~ monkey");
        for (int i = 0; i < 70000; ++i) {
            stringBuilder.append(" and comment ~ ").append(i);
        }
        return stringBuilder.toString();
    }

    @Test
    public void testSearchRequestView() throws Exception {
        this.administration.restoreData("TestQueryTooComplex.xml");
        this.viewSearchRequestViewForSearchFilter(10000, 400, "One of the clauses in your search matches too many results. If a clause returns too many results, the entire search will fail. Please try refining or removing the clauses in your search and run it again.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void viewSearchRequestViewForSearchFilter(int filterId, int responseCode, String errorMessage) {
        try {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
            this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=1000");
            WebResponse response = this.tester.getDialog().getResponse();
            Assert.assertEquals((long)responseCode, (long)response.getResponseCode());
            this.tester.assertTextPresent(errorMessage);
        }
        finally {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
        }
    }

    @Test
    public void testChangeHistoryJqlTooComplex() throws Exception {
        this.administration.restoreBlankInstance();
        this.issueTableAssertions.assertSearchTooComplex(this.statusjQlQuery);
    }
}

