/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.assertions.JqlAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@LoginAs(user="admin")
@RestoreOnce(value="TestSystemFieldDoesItFitMultiple.xml")
public class TestSystemFieldDoesItFitMultiple
extends BaseJiraFuncTest {
    @Inject
    private JqlAssertions jqlAssertions;
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testAffectedVersion() throws Exception {
        String fieldName = "affectedVersion";
        this.assertOrTooComplex("affectedVersion", "\"New Version 1\"", "\"New Version 4\"");
        this.assertAndTooComplex("affectedVersion", "\"New Version 1\"", "\"New Version 4\"");
        this.jqlAssertions.assertTooComplex("affectedVersion IN (10000, 100001)");
        this.assertAndWithHspFitsFilterForm("affectedVersion = \"New Version 1\"", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "New Version 1"));
        this.assertOrWithHspTooComplex("affectedVersion = \"New Version 1\"");
        this.assertAndWithHspTooComplex("affectedVersion != \"New Version 1\"");
        this.assertAndWithHspTooComplex("affectedVersion >= 10000");
        this.assertAndWithHspTooComplex("affectedVersion > 10000");
        this.assertAndWithHspTooComplex("affectedVersion <= 10000");
        this.assertAndWithHspTooComplex("affectedVersion < 10000");
        this.assertAndWithHspFitsFilterForm("affectedVersion is EMPTY", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "-1"));
        this.assertAndWithHspTooComplex("affectedVersion is not EMPTY");
        this.assertAndWithHspFitsFilterForm("affectedVersion in (\"New Version 1\", \"New Version 4\")", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "New Version 1", "New Version 4"));
        this.assertAndWithHspTooComplex("affectedVersion not in (\"New Version 1\", \"New Version 4\")");
        this.assertAndWithHspTooComplex("affectedVersion in releasedVersions(HSP)");
        this.assertAndWithHspFitsFilterForm("affectedVersion in releasedVersions()", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "-3"));
        this.assertAndWithHspTooComplex("affectedVersion not in releasedVersions()");
        this.assertAndWithHspTooComplex("affectedVersion in unreleasedVersions(HSP)");
        this.assertAndWithHspFitsFilterForm("affectedVersion in unreleasedVersions()", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "-2"));
        this.assertAndWithHspTooComplex("affectedVersion not in unreleasedVersions()");
        this.jqlAssertions.assertFitsFilterForm("affectedVersion = \"New Version 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("affectedVersion IN (\"New Version 1\", MonkeyVersion)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("project = MKY AND affectedVersion in releasedVersions()", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", null));
        this.jqlAssertions.assertFitsFilterForm("project = MKY AND affectedVersion = MonkeyVersion", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("project", "MKY"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "MonkeyVersion"));
        this.jqlAssertions.assertFitsFilterForm("project in (HSP, MKY) AND affectedVersion = \"New Version 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("project = HSP AND affectedVersion IN (\"New Version 1\", MonkeyVersion)", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("project", "MKY"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "10000", "MonkeyVersion"));
        this.jqlAssertions.assertFitsFilterForm("project = HSP AND (status = Open AND affectedVersion = MonkeyVersion)", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "MonkeyVersion"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "1"));
    }

    @Test
    public void testAssignee() throws Exception {
        String fieldName = "assignee";
        this.assertOrTooComplex("assignee", "admin", "fred");
        this.assertAndTooComplex("assignee", "admin", "fred");
        this.assertAndWithHspFitsFilterForm("assignee = fred", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("assignee", "fred"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("assigneeSelect", "specificuser"));
        this.assertOrWithHspTooComplex("assignee = fred");
    }

    @Test
    public void testQuery() throws Exception {
        this.assertOrTooComplex("text", "~", "ccc", "ccc");
        this.assertAndTooComplex("text", "~", "ccc", "ccc");
        this.assertOrTooComplex("text", "~", "ccc", "different");
        IssueNavigatorAssertions.FilterFormParam queryGood = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("text", "ccc");
        this.jqlAssertions.assertFitsFilterForm("text ~ ccc", queryGood);
        this.jqlAssertions.assertTooComplex("comment ~ ccc OR environment ~ ccc");
        this.jqlAssertions.assertTooComplex("comment ~ ccc OR summary ~ ccc");
        this.jqlAssertions.assertTooComplex("comment ~ ccc OR description ~ ccc OR environment ~ ccc");
        this.jqlAssertions.assertTooComplex("comment ~ ccc OR description ~ ccc OR summary ~ ccc");
        this.jqlAssertions.assertTooComplex("comment ~ ccc OR environment ~ ccc OR summary ~ ccc");
        this.jqlAssertions.assertTooComplex("comment ~ ccc OR description ~ ccc OR environment ~ ccc OR summary ~ ccc");
        this.jqlAssertions.assertTooComplex("description ~ ccc OR environment ~ ccc");
        this.jqlAssertions.assertTooComplex("description ~ ccc OR summary ~ ccc");
        this.jqlAssertions.assertTooComplex("description ~ ccc OR environment ~ ccc OR summary ~ ccc");
        this.jqlAssertions.assertTooComplex("environment ~ ccc OR summary ~ ccc");
        this.jqlAssertions.assertTooComplex("comment ~ ccc OR description !~ ccc");
        this.jqlAssertions.assertTooComplex("comment ~ ccc OR description ~ different");
        this.jqlAssertions.assertTooComplex("comment ~ ccc OR description is EMPTY");
        this.jqlAssertions.assertTooComplex("(comment ~ ccc OR description ~ ccc) OR (environment ~ ccc OR summary ~ ccc)");
    }

    @Test
    public void testComponent() throws Exception {
        String fieldName = "component";
        this.assertOrTooComplex("component", "\"New Component 1\"", "\"New Component 2\"");
        this.assertAndTooComplex("component", "\"New Component 1\"", "\"New Component 2\"");
        this.jqlAssertions.assertTooComplex("component IN (10000, 100001)");
        this.assertAndWithHspFitsFilterForm("component = \"New Component 1\"", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("component", "New Component 1"));
        this.assertOrWithHspTooComplex("component = \"New Component 1\"");
        this.assertAndWithHspTooComplex("component != \"New Component 1\"");
        this.assertAndWithHspFitsFilterForm("component is EMPTY", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("component", "-1"));
        this.assertAndWithHspTooComplex("component is not EMPTY");
        this.assertAndWithHspFitsFilterForm("component in (\"New Component 1\", \"New Component 2\")", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("component", "New Component 1", "New Component 2"));
        this.assertAndWithHspTooComplex("component not in (\"New Component 1\", \"New Component 2\")");
        this.jqlAssertions.assertFitsFilterForm("component = \"New Component 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("component IN (\"New Component 1\", MonkeyComponent)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("project = MKY AND component = MonkeyComponent", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("project", "MKY"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("component", "MonkeyComponent"));
        this.jqlAssertions.assertFitsFilterForm("project in (HSP, MKY) AND component = \"New Component 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("project = HSP AND component IN (\"New Component 1\", MonkeyComponent)", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("project", "MKY"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "New Component 1", "MonkeyComponent"));
        this.jqlAssertions.assertFitsFilterForm("project = HSP AND (status = Open AND component = MonkeyComponent)", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("component", "MonkeyComponent"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "1"));
    }

    @Test
    public void testCreated() throws Exception {
        IssueNavigatorAssertions.FilterFormParam afterAbs = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("created:after", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeAbs = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("created:before", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeRel = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("created:next", "1d");
        IssueNavigatorAssertions.FilterFormParam afterRel = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("created:previous", "1d");
        this.jqlAssertions.assertFitsFilterForm("created >= '2009-05-11' AND created <= '2009-05-11'", afterAbs, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("created >= '2009-05-11' AND created <= '1d'", afterAbs, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("created >= '1d' AND created <= '2009-05-11'", afterRel, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("created >= '1d' AND created <= '1d'", afterRel, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("created >= '2009-05-11' AND created <= '2009-05-11' AND created >= '1d'", afterAbs, beforeAbs, afterRel);
        this.jqlAssertions.assertFitsFilterForm("created >= '2009-05-11' AND created <= '2009-05-11' AND created <= '1d'", afterAbs, beforeAbs, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("created >= '1d' AND created <= '2009-05-11' AND created >= '2009-05-11'", afterRel, beforeAbs, afterAbs);
        this.jqlAssertions.assertFitsFilterForm("created >= '1d' AND created <= '1d' AND created <= '2009-05-11'", afterRel, beforeRel, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("created >= '1d' AND created <= '1d' AND created >= '2009-05-11' AND created <= '2009-05-11'", afterRel, beforeRel, afterAbs, beforeAbs);
        this.jqlAssertions.assertTooComplex("created >= '1d' OR created <= '1d'");
        this.jqlAssertions.assertTooComplex("created >= '1d' AND created >= '2d'");
        this.jqlAssertions.assertTooComplex("created <= '1d' AND created <= '2d'");
        this.jqlAssertions.assertTooComplex("created > '1d' AND created <= '1d' AND created >= '2009-05-11' AND created <= '2009-05-11'");
        this.jqlAssertions.assertTooComplex("created >= 1234567890 AND created <= '1d' AND created >= '2009-05-11' AND created <= '2009-05-11'");
        this.jqlAssertions.assertFitsFilterForm("(project = HSP AND created <= '1d') AND (status = Open AND created <= '2009-05-11')", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "1"), beforeRel, beforeAbs);
        this.assertAndWithHspFitsFilterForm("created >= '1d'", afterRel);
        this.assertOrWithHspTooComplex("created >= '1d'");
    }

    @Test
    public void testDueDate() throws Exception {
        IssueNavigatorAssertions.FilterFormParam afterAbs = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("duedate:after", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeAbs = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("duedate:before", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeRel = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("duedate:next", "1d");
        IssueNavigatorAssertions.FilterFormParam afterRel = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("duedate:previous", "1d");
        this.jqlAssertions.assertFitsFilterForm("due >= '2009-05-11' AND due <= '2009-05-11'", afterAbs, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("due >= '2009-05-11' AND due <= '1d'", afterAbs, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("due >= '1d' AND due <= '2009-05-11'", afterRel, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("due >= '1d' AND due <= '1d'", afterRel, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("due >= '2009-05-11' AND due <= '2009-05-11' AND due >= '1d'", afterAbs, beforeAbs, afterRel);
        this.jqlAssertions.assertFitsFilterForm("due >= '2009-05-11' AND due <= '2009-05-11' AND due <= '1d'", afterAbs, beforeAbs, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("due >= '1d' AND due <= '2009-05-11' AND due >= '2009-05-11'", afterRel, beforeAbs, afterAbs);
        this.jqlAssertions.assertFitsFilterForm("due >= '1d' AND due <= '1d' AND due <= '2009-05-11'", afterRel, beforeRel, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("due >= '1d' AND due <= '1d' AND due >= '2009-05-11' AND due <= '2009-05-11'", afterRel, beforeRel, afterAbs, beforeAbs);
        this.jqlAssertions.assertTooComplex("due >= '1d' OR due <= '1d'");
        this.jqlAssertions.assertTooComplex("due >= '1d' AND due >= '2d'");
        this.jqlAssertions.assertTooComplex("due <= '1d' AND due <= '2d'");
        this.jqlAssertions.assertTooComplex("due > '1d' AND due <= '1d' AND due >= '2009-05-11' AND due <= '2009-05-11'");
        this.jqlAssertions.assertTooComplex("due >= 1234567890 AND due <= '1d' AND due >= '2009-05-11' AND due <= '2009-05-11'");
        this.jqlAssertions.assertFitsFilterForm("(project = HSP AND due <= '1d') AND (status = Open AND due <= '2009-05-11')", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "1"), beforeRel, beforeAbs);
        this.assertAndWithHspFitsFilterForm("due >= '1d'", afterRel);
        this.assertOrWithHspTooComplex("due >= '1d'");
    }

    @Test
    public void testFixVersion() throws Exception {
        String fieldName = "fixVersion";
        this.assertOrTooComplex("fixVersion", "\"New Version 1\"", "\"New Version 4\"");
        this.assertAndTooComplex("fixVersion", "\"New Version 1\"", "\"New Version 4\"");
        this.jqlAssertions.assertTooComplex("fixVersion IN (10000, 100001)");
        this.assertAndWithHspFitsFilterForm("fixVersion = \"New Version 1\"", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "New Version 1"));
        this.assertOrWithHspTooComplex("fixVersion = \"New Version 1\"");
        this.assertAndWithHspTooComplex("fixVersion != \"New Version 1\"");
        this.assertAndWithHspTooComplex("fixVersion >= 10000");
        this.assertAndWithHspTooComplex("fixVersion > 10000");
        this.assertAndWithHspTooComplex("fixVersion <= 10000");
        this.assertAndWithHspTooComplex("fixVersion < 10000");
        this.assertAndWithHspFitsFilterForm("fixVersion is EMPTY", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "-1"));
        this.assertAndWithHspTooComplex("fixVersion is not EMPTY");
        this.assertAndWithHspFitsFilterForm("fixVersion in (\"New Version 1\", \"New Version 4\")", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "New Version 1", "New Version 4"));
        this.assertAndWithHspTooComplex("fixVersion not in (\"New Version 1\", \"New Version 4\")");
        this.assertAndWithHspTooComplex("fixVersion in releasedVersions(HSP)");
        this.assertAndWithHspFitsFilterForm("fixVersion in releasedVersions()", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "-3"));
        this.assertAndWithHspTooComplex("fixVersion not in releasedVersions()");
        this.assertAndWithHspTooComplex("fixVersion in unreleasedVersions(HSP)");
        this.assertAndWithHspFitsFilterForm("fixVersion in unreleasedVersions()", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "-2"));
        this.assertAndWithHspTooComplex("fixVersion not in unreleasedVersions()");
        this.jqlAssertions.assertFitsFilterForm("fixVersion = \"New Version 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("fixVersion IN (\"New Version 1\", MonkeyVersion)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("project = MKY AND fixVersion in releasedVersions()", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", null));
        this.jqlAssertions.assertFitsFilterForm("project = MKY AND fixVersion = MonkeyVersion", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("project", "MKY"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "MonkeyVersion"));
        this.jqlAssertions.assertFitsFilterForm("project in (HSP, MKY) AND fixVersion = \"New Version 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.jqlAssertions.assertFitsFilterForm("project = HSP AND fixVersion IN (\"New Version 1\", MonkeyVersion)", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("project", "MKY"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "10000", "MonkeyVersion"));
        this.jqlAssertions.assertFitsFilterForm("project = HSP AND (status = Open AND affectedVersion = MonkeyVersion)", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "MonkeyVersion"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "1"));
    }

    @Test
    public void testPriority() throws Exception {
        String fieldName = "priority";
        this.assertOrTooComplex("priority", "Blocker", "Critical");
        this.assertAndTooComplex("priority", "Blocker", "Critical");
        this.assertAndWithHspFitsFilterForm("priority = Blocker", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("priority", "1"));
        this.assertAndWithHspFitsFilterForm("priority IN (Blocker, Critical)", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("priority", "1", "2"));
        this.assertOrWithHspTooComplex("priority = Blocker");
    }

    @Test
    public void testProject() throws Exception {
        String fieldName = "project";
        this.assertOrTooComplex("project", "HSP", "MKY");
        this.assertAndTooComplex("project", "HSP", "MKY");
    }

    @Test
    public void testReporter() throws Exception {
        String fieldName = "reporter";
        this.assertOrTooComplex("reporter", "admin", "fred");
        this.assertAndTooComplex("reporter", "admin", "fred");
        this.assertAndWithHspFitsFilterForm("reporter = fred", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("reporter", "fred"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("reporterSelect", "specificuser"));
        this.assertOrWithHspTooComplex("reporter = fred");
    }

    @Test
    public void testResolution() throws Exception {
        String fieldName = "resolution";
        this.assertOrTooComplex("resolution", "Fixed", "Duplicate");
        this.assertAndTooComplex("resolution", "Fixed", "Duplicate");
        this.assertAndWithHspFitsFilterForm("resolution = Fixed", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolution", "1"));
        this.assertAndWithHspFitsFilterForm("resolution IN (Fixed, Duplicate)", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolution", "1", "3"));
        this.assertOrWithHspTooComplex("resolution = Fixed");
    }

    @Test
    public void testResolutionDate() throws Exception {
        IssueNavigatorAssertions.FilterFormParam afterAbs = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolutiondate:after", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeAbs = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolutiondate:before", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeRel = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolutiondate:next", "1d");
        IssueNavigatorAssertions.FilterFormParam afterRel = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolutiondate:previous", "1d");
        this.jqlAssertions.assertFitsFilterForm("resolved >= '2009-05-11' AND resolved <= '2009-05-11'", afterAbs, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("resolved >= '2009-05-11' AND resolved <= '1d'", afterAbs, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("resolved >= '1d' AND resolved <= '2009-05-11'", afterRel, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("resolved >= '1d' AND resolved <= '1d'", afterRel, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("resolved >= '2009-05-11' AND resolved <= '2009-05-11' AND resolved >= '1d'", afterAbs, beforeAbs, afterRel);
        this.jqlAssertions.assertFitsFilterForm("resolved >= '2009-05-11' AND resolved <= '2009-05-11' AND resolved <= '1d'", afterAbs, beforeAbs, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("resolved >= '1d' AND resolved <= '2009-05-11' AND resolved >= '2009-05-11'", afterRel, beforeAbs, afterAbs);
        this.jqlAssertions.assertFitsFilterForm("resolved >= '1d' AND resolved <= '1d' AND resolved <= '2009-05-11'", afterRel, beforeRel, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("resolved >= '1d' AND resolved <= '1d' AND resolved >= '2009-05-11' AND resolved <= '2009-05-11'", afterRel, beforeRel, afterAbs, beforeAbs);
        this.jqlAssertions.assertTooComplex("resolved >= '1d' OR resolved <= '1d'");
        this.jqlAssertions.assertTooComplex("resolved >= '1d' AND resolved >= '2d'");
        this.jqlAssertions.assertTooComplex("resolved <= '1d' AND resolved <= '2d'");
        this.jqlAssertions.assertTooComplex("resolved > '1d' AND resolved <= '1d' AND resolved >= '2009-05-11' AND resolved <= '2009-05-11'");
        this.jqlAssertions.assertTooComplex("resolved >= 1234567890 AND resolved <= '1d' AND resolved >= '2009-05-11' AND resolved <= '2009-05-11'");
        this.jqlAssertions.assertFitsFilterForm("(project = HSP AND resolved <= '1d') AND (status = Open AND resolved <= '2009-05-11')", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "1"), beforeRel, beforeAbs);
        this.assertAndWithHspFitsFilterForm("resolved >= '1d'", afterRel);
        this.assertOrWithHspTooComplex("resolved >= '1d'");
    }

    @Test
    public void testStatus() throws Exception {
        String fieldName = "status";
        this.assertOrTooComplex("status", "Open", "Resolved");
        this.assertAndTooComplex("status", "Open", "Resolved");
        this.assertAndWithHspFitsFilterForm("status = Open", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "1"));
        this.assertAndWithHspFitsFilterForm("status IN (Open, Resolved)", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "1", "5"));
        this.assertOrWithHspTooComplex("status = Open");
        this.assertAndWithHspFitsFilterForm("status = hsp_status", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "10001"));
        this.jqlAssertions.assertFitsFilterForm("project = HSP and status = mky_status", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("project", "HSP"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "mky_status"));
        this.jqlAssertions.assertFitsFilterForm("project = HSP and status = mky_bug_status", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("project", "HSP"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "mky_status"));
        this.jqlAssertions.assertFitsFilterForm("project = HSP and type = bug and status = mky_bug_status", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("project", "HSP"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "bug"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "mky_bug_status"));
        this.jqlAssertions.assertFitsFilterForm("project = MKY and type = improvement and status = mky_bug_status", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("project", "MKY"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "improvement"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "mky_bug_status"));
        this.jqlAssertions.assertFitsFilterForm("project = MKY and status = mky_bug_status", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "10002"));
        this.jqlAssertions.assertFitsFilterForm("project = MKY and type = bug and status = mky_bug_status", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "10002"));
    }

    @Test
    public void testType() throws Exception {
        this.administration.subtasks().enable();
        String fieldName = "type";
        this.assertOrTooComplex("type", "Bug", "Task");
        this.assertAndTooComplex("type", "Bug", "Task");
        this.assertAndWithHspFitsFilterForm("type = Bug", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "1"));
        this.assertOrWithHspTooComplex("type = Bug");
        this.assertAndWithHspFitsFilterForm("type in (Bug, Task)", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "1", "3"));
        this.assertAndWithHspFitsFilterForm("type in standardIssueTypes()", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "-2"));
        this.assertAndWithHspFitsFilterForm("type in subTaskIssueTypes()", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "-3"));
        this.assertAndWithHspFitsFilterForm("type = hsp_type", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "6"));
        this.assertAndWithHspFitsFilterForm("type = mky_type", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "mky_type"));
        this.assertAndWithHspFitsFilterForm("type in (mky_type, hsp_type)", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "mky_type", "hsp_type"));
        this.jqlAssertions.assertFitsFilterForm("project in (mky, hsp) and type in (mky_type, hsp_type)", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "6", "7"));
        this.jqlAssertions.assertFitsFilterForm("type in (mky_type, hsp_type)", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "6", "7"));
    }

    @Test
    public void testUpdated() throws Exception {
        IssueNavigatorAssertions.FilterFormParam afterAbs = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("updated:after", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeAbs = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("updated:before", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeRel = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("updated:next", "1d");
        IssueNavigatorAssertions.FilterFormParam afterRel = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("updated:previous", "1d");
        this.jqlAssertions.assertFitsFilterForm("updated >= '2009-05-11' AND updated <= '2009-05-11'", afterAbs, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("updated >= '2009-05-11' AND updated <= '1d'", afterAbs, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("updated >= '1d' AND updated <= '2009-05-11'", afterRel, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("updated >= '1d' AND updated <= '1d'", afterRel, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("updated >= '2009-05-11' AND updated <= '2009-05-11' AND updated >= '1d'", afterAbs, beforeAbs, afterRel);
        this.jqlAssertions.assertFitsFilterForm("updated >= '2009-05-11' AND updated <= '2009-05-11' AND updated <= '1d'", afterAbs, beforeAbs, beforeRel);
        this.jqlAssertions.assertFitsFilterForm("updated >= '1d' AND updated <= '2009-05-11' AND updated >= '2009-05-11'", afterRel, beforeAbs, afterAbs);
        this.jqlAssertions.assertFitsFilterForm("updated >= '1d' AND updated <= '1d' AND updated <= '2009-05-11'", afterRel, beforeRel, beforeAbs);
        this.jqlAssertions.assertFitsFilterForm("updated >= '1d' AND updated <= '1d' AND updated >= '2009-05-11' AND updated <= '2009-05-11'", afterRel, beforeRel, afterAbs, beforeAbs);
        this.jqlAssertions.assertTooComplex("updated >= '1d' OR updated <= '1d'");
        this.jqlAssertions.assertTooComplex("updated >= '1d' AND updated >= '2d'");
        this.jqlAssertions.assertTooComplex("updated <= '1d' AND updated <= '2d'");
        this.jqlAssertions.assertTooComplex("updated > '1d' AND updated <= '1d' AND updated >= '2009-05-11' AND updated <= '2009-05-11'");
        this.jqlAssertions.assertTooComplex("updated >= 1234567890 AND updated <= '1d' AND updated >= '2009-05-11' AND updated <= '2009-05-11'");
        this.jqlAssertions.assertFitsFilterForm("(project = HSP AND updated <= '1d') AND (status = Open AND updated <= '2009-05-11')", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "1"), beforeRel, beforeAbs);
        this.assertAndWithHspFitsFilterForm("updated >= '1d'", afterRel);
        this.assertOrWithHspTooComplex("updated >= '1d'");
    }

    @Test
    public void testWorkRatio() throws Exception {
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.jqlAssertions.assertFitsFilterForm("workratio >= '10' AND workratio <= '20'", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("workratio:min", "10"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("workratio:max", "20"));
        this.jqlAssertions.assertFitsFilterForm("(project = HSP AND workratio >= '10') AND workratio <= '20'", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("workratio:min", "10"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("workratio:max", "20"));
        this.jqlAssertions.assertTooComplex("workratio >= '10' OR workratio <= '10'");
        this.jqlAssertions.assertTooComplex("workratio >= '10' AND workratio >= '20'");
        this.jqlAssertions.assertTooComplex("workratio <= '10' AND workratio <= '20'");
        this.jqlAssertions.assertTooComplex("workratio > '10' AND workratio <= '20'");
        this.assertAndWithHspFitsFilterForm("workratio >= '10'", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("workratio:min", "10"));
        this.assertOrWithHspTooComplex("workratio >= '10'");
    }

    private void assertAndWithHspFitsFilterForm(String jqlQuery, IssueNavigatorAssertions.FilterFormParam ... formParams) {
        IssueNavigatorAssertions.FilterFormParam[] params = new IssueNavigatorAssertions.FilterFormParam[formParams.length + 1];
        params[0] = IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000");
        System.arraycopy(formParams, 0, params, 1, formParams.length);
        this.jqlAssertions.assertFitsFilterForm(String.format("project = HSP AND %s", jqlQuery), params);
    }

    private void assertOrTooComplex(String fieldName, String operand1, String operand2) {
        this.assertOrTooComplex(fieldName, "=", operand1, operand2);
    }

    private void assertOrTooComplex(String fieldName, String operator, String operand1, String operand2) {
        this.jqlAssertions.assertTooComplex(String.format("%1$s %2$s %3$s OR %1$s %2$s %4$s", fieldName, operator, operand1, operand2));
    }

    private void assertAndTooComplex(String fieldName, String operand1, String operand2) {
        this.jqlAssertions.assertTooComplex(String.format("%1$s = %2$s AND %1$s = %3$s", fieldName, operand1, operand2));
    }

    private void assertAndTooComplex(String fieldName, String operator, String operand1, String operand2) {
        this.jqlAssertions.assertTooComplex(String.format("%1$s %2$s %3$s AND %1$s %2$s %4$s", fieldName, operator, operand1, operand2));
    }

    private void assertAndWithHspTooComplex(String jqlQuery) {
        this.assertAndWithProjectTooComplex("HSP", jqlQuery);
    }

    private void assertOrWithHspTooComplex(String jqlQuery) {
        this.assertOrWithProjectTooComplex("HSP", jqlQuery);
    }

    private void assertAndWithProjectTooComplex(String project, String jqlQuery) {
        this.jqlAssertions.assertTooComplex(String.format("project = %s AND %s", project, jqlQuery));
    }

    private void assertOrWithProjectTooComplex(String project, String jqlQuery) {
        this.jqlAssertions.assertTooComplex(String.format("project = %s OR %s", project, jqlQuery));
    }
}

