/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.assertions.JqlAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@LoginAs(user="admin")
@RestoreOnce(value="TestSystemFieldDoesItFitSingle.xml")
public class TestSystemFieldDoesItFitSingle
extends BaseJiraFuncTest {
    @Inject
    JqlAssertions jqlAssertions;
    @Inject
    private Administration administration;

    @Test
    public void testAffectedVersion() throws Exception {
        String fieldName = "affectedVersion";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 10000", Result.tooComplex());
        matrix.put("!= 10000", Result.tooComplex());
        this.addComplexRelational(matrix, "10000");
        matrix.put("is EMPTY", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "-1")}));
        matrix.put("is not EMPTY", Result.tooComplex());
        matrix.put("in (10000, 10001)", Result.tooComplex());
        matrix.put("not in (10000, 10001)", Result.tooComplex());
        matrix.put("in releasedVersions(HSP)", Result.tooComplex());
        matrix.put("not in releasedVersions(HSP)", Result.tooComplex());
        matrix.put("in unreleasedVersions(HSP)", Result.tooComplex());
        matrix.put("not in unreleasedVersions(HSP)", Result.tooComplex());
        matrix.put("= 10010 and project = HSP", Result.tooComplex());
        matrix.put("= \"New Version 1\"", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "New Version 1")}));
        matrix.put("!= \"New Version 1\"", Result.tooComplex());
        matrix.put("in (\"New Version 1\", \"New Version 4\")", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "New Version 1"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "New Version 4")}));
        matrix.put("not in (\"New Version 1\", \"New Version 4\")", Result.tooComplex());
        matrix.put("= \"Archived Version\"", Result.tooComplex());
        matrix.put("in (\"New Version 1\", \"Archived Version\")", Result.tooComplex());
        matrix.put("= \"Archived In HSP\"", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "Archived In HSP")}));
        matrix.put("in (\"Archived In HSP\", \"New Version 1\")", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "Archived In HSP")}));
        this._testFitnessMatrix("affectedVersion", matrix);
    }

    @Test
    public void testAssignee() throws Exception {
        String fieldName = "assignee";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= fred", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("assignee", "fred"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("assigneeSelect", "specificuser")}));
        matrix.put("!= fred", Result.tooComplex());
        matrix.put("is EMPTY", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("assigneeSelect", "unassigned")}));
        matrix.put("is not EMPTY", Result.tooComplex());
        matrix.put("in (fred, admin)", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("assignee", "fred", "admin")}));
        matrix.put("not in (fred, admin)", Result.tooComplex());
        matrix.put("in membersOf('jira-users')", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("assignee", "jira-users"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("assigneeSelect", "specificgroup")}));
        matrix.put("= currentUser()", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("assigneeSelect", "issue_current_user")}));
        this._testFitnessMatrix("assignee", matrix);
    }

    @Test
    public void testCategory() throws Exception {
        String fieldName = "category";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 10000", Result.tooComplex());
        matrix.put("!= 10000", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("in (10000, 10001)", Result.tooComplex());
        matrix.put("not in (10000, 10001)", Result.tooComplex());
        this._testFitnessMatrix("category", matrix);
    }

    @Test
    public void testComment() throws Exception {
        this.jqlAssertions.assertFitsFilterForm("comment ~ ccc", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("comment", "ccc"));
        this.jqlAssertions.assertTooComplex("comment !~ ccc");
    }

    @Test
    public void testComponent() throws Exception {
        String fieldName = "component";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 10000", Result.tooComplex());
        matrix.put("!= 10000", Result.tooComplex());
        matrix.put("in (10000, 10001)", Result.tooComplex());
        matrix.put("not in (10000, 10001)", Result.tooComplex());
        matrix.put("= \"New Component 1\"", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("component", "New Component 1")}));
        matrix.put("!= \"New Component 1\"", Result.tooComplex());
        matrix.put("in (\"New Component 1\", \"New Component 2\")", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("component", "New Component 1"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("component", "New Component 2")}));
        matrix.put("not in (\"New Component 1\", \"New Component 1\")", Result.tooComplex());
        this._testFitnessMatrix("component", matrix);
    }

    @Test
    public void testCreated() throws Exception {
        String fieldName = "created";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= '2009-05-11'", Result.tooComplex());
        matrix.put("!= '2009-05-11'", Result.tooComplex());
        matrix.put("<= '2009-05-11'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("created:before", "11/May/09")}));
        matrix.put(">= '2009-05-11'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("created:after", "11/May/09")}));
        matrix.put("< '2009-05-11'", Result.tooComplex());
        matrix.put("> '2009-05-11'", Result.tooComplex());
        matrix.put("<= '1d'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("created:next", "1d")}));
        matrix.put(">= '1d'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("created:previous", "1d")}));
        matrix.put("< '1d'", Result.tooComplex());
        matrix.put("> '1d'", Result.tooComplex());
        matrix.put("in ('2009-05-11', '2009-05-12')", Result.tooComplex());
        matrix.put("not in ('2009-05-11', '2009-05-12')", Result.tooComplex());
        matrix.put("> now()", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("created", matrix);
    }

    @Test
    public void testDescription() throws Exception {
        this.jqlAssertions.assertFitsFilterForm("description ~ ccc", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("description", "ccc"));
        this.jqlAssertions.assertTooComplex("description !~ ccc");
        this.jqlAssertions.assertTooComplex("description is EMPTY");
        this.jqlAssertions.assertTooComplex("description is not EMPTY");
    }

    @Test
    public void testDueDate() throws Exception {
        String fieldName = "due";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= '2009-05-11'", Result.tooComplex());
        matrix.put("!= '2009-05-11'", Result.tooComplex());
        matrix.put("<= '2009-05-11'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("duedate:before", "11/May/09")}));
        matrix.put(">= '2009-05-11'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("duedate:after", "11/May/09")}));
        matrix.put("<= '1d'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("duedate:next", "1d")}));
        matrix.put(">= '1d'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("duedate:previous", "1d")}));
        matrix.put("in ('2009-05-11', '2009-05-12')", Result.tooComplex());
        matrix.put("not in ('2009-05-11', '2009-05-12')", Result.tooComplex());
        matrix.put(">= now()", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("due", matrix);
    }

    @Test
    public void testEnvironment() throws Exception {
        this.jqlAssertions.assertFitsFilterForm("environment ~ ccc", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("environment", "ccc"));
        this.jqlAssertions.assertTooComplex("environment !~ ccc");
        this.jqlAssertions.assertTooComplex("environment is EMPTY");
        this.jqlAssertions.assertTooComplex("environment is not EMPTY");
    }

    @Test
    public void testFixVersion() throws Exception {
        String fieldName = "fixVersion";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 10000", Result.tooComplex());
        matrix.put("!= 10000", Result.tooComplex());
        this.addComplexRelational(matrix, "10000");
        matrix.put("is EMPTY", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "-1")}));
        matrix.put("is not EMPTY", Result.tooComplex());
        matrix.put("in (10000, 10001)", Result.tooComplex());
        matrix.put("not in (10000, 10001)", Result.tooComplex());
        matrix.put("in releasedVersions(HSP)", Result.tooComplex());
        matrix.put("not in releasedVersions(HSP)", Result.tooComplex());
        matrix.put("in unreleasedVersions(HSP)", Result.tooComplex());
        matrix.put("not in unreleasedVersions(HSP)", Result.tooComplex());
        matrix.put("= 10010 and project = HSP", Result.tooComplex());
        matrix.put("= \"New Version 1\"", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "New Version 1")}));
        matrix.put("!= \"New Version 1\"", Result.tooComplex());
        matrix.put("in (\"New Version 1\", \"New Version 4\")", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "New Version 1"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "New Version 4")}));
        matrix.put("not in (\"New Version 1\", \"New Version 4\")", Result.tooComplex());
        matrix.put("= \"Archived Version\"", Result.tooComplex());
        matrix.put("in (\"New Version 1\", \"Archived Version\")", Result.tooComplex());
        matrix.put("= \"Archived In HSP\"", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "Archived In HSP")}));
        matrix.put("in (\"Archived In HSP\", \"New Version 1\")", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "Archived In HSP")}));
        this._testFitnessMatrix("fixVersion", matrix);
    }

    @Test
    public void testIssue() throws Exception {
        String fieldName = "issue";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 'HSP-1'", Result.tooComplex());
        matrix.put("!= 'HSP-1'", Result.tooComplex());
        this.addComplexRelational(matrix, "'HSP-1'");
        this.addComplexEmpty(matrix);
        matrix.put("in ('HSP-1', 'HSP-2')", Result.tooComplex());
        matrix.put("not in ('HSP-1', 'HSP-2')", Result.tooComplex());
        this._testFitnessMatrix("issue", matrix);
    }

    @Test
    public void testLevel() throws Exception {
        String fieldName = "level";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 10000", Result.tooComplex());
        matrix.put("!= 10000", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("in (10000, 10001)", Result.tooComplex());
        matrix.put("not in (10000, 10001)", Result.tooComplex());
        this._testFitnessMatrix("level", matrix);
    }

    @Test
    public void testTimeTracking() throws Exception {
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        String fieldName = "originalEstimate";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 10", Result.tooComplex());
        matrix.put("!= 10", Result.tooComplex());
        this.addComplexRelational(matrix, "10");
        this.addComplexEmpty(matrix);
        matrix.put("in (10, 20)", Result.tooComplex());
        matrix.put("not in (10, 20)", Result.tooComplex());
        this._testFitnessMatrix(fieldName, matrix);
        fieldName = "remainingEstimate";
        matrix = new LinkedHashMap();
        matrix.put("= 10", Result.tooComplex());
        matrix.put("!= 10", Result.tooComplex());
        this.addComplexRelational(matrix, "10");
        this.addComplexEmpty(matrix);
        matrix.put("in (10, 20)", Result.tooComplex());
        matrix.put("not in (10, 20)", Result.tooComplex());
        this._testFitnessMatrix(fieldName, matrix);
        fieldName = "timeSpent";
        matrix = new LinkedHashMap();
        matrix.put("= 10", Result.tooComplex());
        matrix.put("!= 10", Result.tooComplex());
        this.addComplexRelational(matrix, "10");
        this.addComplexEmpty(matrix);
        matrix.put("in (10, 20)", Result.tooComplex());
        matrix.put("not in (10, 20)", Result.tooComplex());
        this._testFitnessMatrix(fieldName, matrix);
        fieldName = "workRatio";
        matrix = new LinkedHashMap();
        matrix.put("= 10", Result.tooComplex());
        matrix.put("!= 10", Result.tooComplex());
        matrix.put("< 10", Result.tooComplex());
        matrix.put("<= 10", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("workratio:max", "10")}));
        matrix.put("> 10", Result.tooComplex());
        matrix.put(">= 10", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("workratio:min", "10")}));
        this.addComplexEmpty(matrix);
        matrix.put("in (10, 20)", Result.tooComplex());
        matrix.put("not in (10, 20)", Result.tooComplex());
        this._testFitnessMatrix(fieldName, matrix);
    }

    @Test
    public void testParent() throws Exception {
        String fieldName = "parent";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 'HSP-1'", Result.tooComplex());
        matrix.put("!= 'HSP-1'", Result.tooComplex());
        matrix.put("in ('HSP-1', 'HSP-2')", Result.tooComplex());
        matrix.put("not in ('HSP-1', 'HSP-2')", Result.tooComplex());
        this._testFitnessMatrix("parent", matrix);
    }

    @Test
    public void testPriority() throws Exception {
        String fieldName = "priority";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= Major", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("priority", "3")}));
        matrix.put("!= Major", Result.tooComplex());
        matrix.put("< Major", Result.tooComplex());
        matrix.put("<= Major", Result.tooComplex());
        matrix.put("> Major", Result.tooComplex());
        matrix.put(">= Major", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("in (Major, Critical)", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("priority", "2", "3")}));
        matrix.put("not in (Major, Critical)", Result.tooComplex());
        this._testFitnessMatrix("priority", matrix);
    }

    @Test
    public void testProject() throws Exception {
        String fieldName = "project";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= HSP", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000")}));
        matrix.put("!= HSP", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("in (HSP, MKY)", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000", "10001")}));
        matrix.put("not in (HSP, MKY)", Result.tooComplex());
        this._testFitnessMatrix("project", matrix);
    }

    @Test
    public void testReporter() throws Exception {
        String fieldName = "reporter";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= fred", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("reporter", "fred"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("reporterSelect", "specificuser")}));
        matrix.put("!= fred", Result.tooComplex());
        matrix.put("is EMPTY", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("reporterSelect", "issue_no_reporter")}));
        matrix.put("is not EMPTY", Result.tooComplex());
        matrix.put("in (fred, admin)", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("reporter", "fred", "admin")}));
        matrix.put("not in (fred, admin)", Result.tooComplex());
        matrix.put("in membersOf('jira-users')", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("reporter", "jira-users"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("reporterSelect", "specificgroup")}));
        matrix.put("= currentUser()", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("reporterSelect", "issue_current_user")}));
        this._testFitnessMatrix("reporter", matrix);
    }

    @Test
    public void testResolution() throws Exception {
        String fieldName = "resolution";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= Fixed", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolution", "1")}));
        matrix.put("!= Fixed", Result.tooComplex());
        this.addComplexRelational(matrix, "Fixed");
        matrix.put("= unresolved", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolution", "-1")}));
        matrix.put("is EMPTY", Result.tooComplex());
        matrix.put("is not EMPTY", Result.tooComplex());
        matrix.put("in (unresolved, Fixed, Duplicate)", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolution", "-1", "1", "3")}));
        matrix.put("not in (Fixed, Duplicate)", Result.tooComplex());
        this._testFitnessMatrix("resolution", matrix);
    }

    @Test
    public void testResolutionDate() throws Exception {
        String fieldName = "resolved";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= '2009-05-11'", Result.tooComplex());
        matrix.put("!= '2009-05-11'", Result.tooComplex());
        matrix.put("<= '2009-05-11'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolutiondate:before", "11/May/09")}));
        matrix.put(">= '2009-05-11'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolutiondate:after", "11/May/09")}));
        matrix.put("< '2009-05-11'", Result.tooComplex());
        matrix.put("> '2009-05-11'", Result.tooComplex());
        matrix.put("<= '1d'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolutiondate:next", "1d")}));
        matrix.put(">= '1d'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("resolutiondate:previous", "1d")}));
        matrix.put("< '1d'", Result.tooComplex());
        matrix.put("> '1d'", Result.tooComplex());
        matrix.put("in ('2009-05-11', '2009-05-12')", Result.tooComplex());
        matrix.put("not in ('2009-05-11', '2009-05-12')", Result.tooComplex());
        matrix.put("= now()", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("resolved", matrix);
    }

    @Test
    public void testSavedFilter() throws Exception {
        String fieldName = "savedFilter";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 10000", Result.tooComplex());
        matrix.put("!= 10000", Result.tooComplex());
        matrix.put("in (10000, 10001)", Result.tooComplex());
        matrix.put("not in (10000, 10001)", Result.tooComplex());
        this._testFitnessMatrix("savedFilter", matrix);
    }

    @Test
    public void testStatus() throws Exception {
        String fieldName = "status";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= Open", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "1")}));
        matrix.put("!= Open", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("in (Open, 'In Progress')", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "1", "3")}));
        matrix.put("not in (Open, 'In Progress')", Result.tooComplex());
        matrix.put("= mky_status", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "10001")}));
        matrix.put("= mky_bug_status", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("status", "10002")}));
        this._testFitnessMatrix("status", matrix);
    }

    @Test
    public void testSummary() throws Exception {
        this.jqlAssertions.assertFitsFilterForm("summary ~ ccc", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("summary", "ccc"));
        this.jqlAssertions.assertTooComplex("summary !~ ccc");
        this.jqlAssertions.assertTooComplex("summary is EMPTY");
        this.jqlAssertions.assertTooComplex("summary is not EMPTY");
    }

    @Test
    public void testText() throws Exception {
        this.jqlAssertions.assertFitsFilterForm("text ~ ccc", IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("text", "ccc"));
        this.jqlAssertions.assertTooComplex("text !~ ccc");
    }

    @Test
    public void testType() throws Exception {
        this.administration.activateSubTasks();
        String fieldName = "type";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= Bug", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "1")}));
        matrix.put("!= Bug", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("in (Bug, Task)", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "1", "3")}));
        matrix.put("not in (Bug, Task)", Result.tooComplex());
        matrix.put("in standardIssueTypes()", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "-2")}));
        matrix.put("not in standardIssueTypes()", Result.tooComplex());
        matrix.put("in subTaskIssueTypes()", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("type", "-3")}));
        matrix.put("not in subTaskIssueTypes()", Result.tooComplex());
        this._testFitnessMatrix("type", matrix);
    }

    @Test
    public void testUpdated() throws Exception {
        String fieldName = "updated";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= '2009-05-11'", Result.tooComplex());
        matrix.put("!= '2009-05-11'", Result.tooComplex());
        matrix.put("<= '2009-05-11'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("updated:before", "11/May/09")}));
        matrix.put(">= '2009-05-11'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("updated:after", "11/May/09")}));
        matrix.put("< '2009-05-11'", Result.tooComplex());
        matrix.put("> '2009-05-11'", Result.tooComplex());
        matrix.put("<= '1d'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("updated:next", "1d")}));
        matrix.put(">= '1d'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("updated:previous", "1d")}));
        matrix.put("< '1d'", Result.tooComplex());
        matrix.put("> '1d'", Result.tooComplex());
        matrix.put("in ('2009-05-11', '2009-05-12')", Result.tooComplex());
        matrix.put("not in ('2009-05-11', '2009-05-12')", Result.tooComplex());
        matrix.put("> now()", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("updated", matrix);
    }

    @Test
    public void testVotes() throws Exception {
        this.administration.generalConfiguration().enableVoting();
        String fieldName = "votes";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 10000", Result.tooComplex());
        matrix.put("!= 10000", Result.tooComplex());
        this.addComplexRelational(matrix, "10000");
        matrix.put("in (10000, 10001)", Result.tooComplex());
        matrix.put("not in (10000, 10001)", Result.tooComplex());
        this._testFitnessMatrix("votes", matrix);
    }

    @Test
    public void testVersionsAndComponents() throws Exception {
        String fieldName = "project";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put(" = HSP AND fixVersion in unreleasedVersions()", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("fixfor", "-2")}));
        matrix.put(" = HSP AND affectedVersion in unreleasedVersions()", new Result(new IssueNavigatorAssertions.FilterFormParam[]{IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("pid", "10000"), IssueNavigatorAssertions.FilterFormParam.createFilterFormParam("version", "-2")}));
        this._testFitnessMatrix("project", matrix);
    }

    private void addComplexRelational(Map<String, Result> matrix, String lit) {
        matrix.put("< " + lit, Result.tooComplex());
        matrix.put("<= " + lit, Result.tooComplex());
        matrix.put("> " + lit, Result.tooComplex());
        matrix.put(">= " + lit, Result.tooComplex());
    }

    private void addComplexEmpty(Map<String, Result> matrix) {
        matrix.put("is EMPTY", Result.tooComplex());
        matrix.put("is not EMPTY", Result.tooComplex());
    }

    private void _testFitnessMatrix(String fieldName, Map<String, Result> matrix) {
        for (Map.Entry<String, Result> entry : matrix.entrySet()) {
            String jqlQuery = String.format("%s %s", fieldName, entry.getKey());
            Result result = entry.getValue();
            if (result.isTooComplex) {
                this.jqlAssertions.assertTooComplex(jqlQuery);
                continue;
            }
            this.jqlAssertions.assertFitsFilterForm(jqlQuery, result.expectedFormData);
        }
    }

    private static class Result {
        private IssueNavigatorAssertions.FilterFormParam[] expectedFormData;
        private boolean isTooComplex;

        private Result() {
            this.expectedFormData = null;
            this.isTooComplex = true;
        }

        private Result(IssueNavigatorAssertions.FilterFormParam ... expectedFormData) {
            this.expectedFormData = expectedFormData;
            this.isTooComplex = false;
        }

        private static Result tooComplex() {
            Result result = new Result();
            result.isTooComplex = true;
            return result;
        }
    }
}

