/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.assertions.JqlAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@LoginAs(user="admin")
@Restore(value="TestUserNameSearching.xml")
public class TestUserNameSearching
extends BaseJiraFuncTest {
    @Inject
    private JqlAssertions jqlAssertions;
    @Inject
    private IssueTableAssertions issueTableAssertions;

    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testSystemFieldSearchByUserName() throws Exception {
        this._testSearchByUserNameFits("assignee", "assignee");
        this._testSearchByFullNameDoesntFit("assignee");
        this._testSearchByEmailDoesntFit("assignee");
        this._testSearchByEmailReturnsResultsByEmail("assignee");
    }

    @Test
    public void testUserPickerSearchByUserName() throws Exception {
        this._testSearchByUserNameFits("userpicker", "customfield_10000");
        this._testSearchByFullNameDoesntFit("userpicker");
        this._testSearchByEmailDoesntFit("userpicker");
        this._testSearchByEmailReturnsResultsByEmail("userpicker");
    }

    @Test
    public void testSearchingUsingDeletedUser() throws Exception {
        this.issueTableAssertions.assertSearchWithResults("assignee = \"deleteduser\"", "HSP-2");
    }

    @Test
    public void testSearchingUsingDeletedUserDoesntFit() throws Exception {
        String jql = "assignee = \"deleteduser\"";
        this.jqlAssertions.assertTooComplex(jql);
    }

    @Test
    public void testUserGroupPickerSearchByUserName() throws Exception {
        this._testSearchByUserNameFits("usergrouppicker", "customfield_10001");
        this._testSearchByFullNameDoesntFit("usergrouppicker");
        this._testSearchByEmailDoesntFit("usergrouppicker");
        this._testSearchByEmailReturnsResultsByEmail("usergrouppicker");
    }

    private void _testSearchByUserNameFits(String field, String formName) throws Exception {
        String jql = field + " = admin";
        this.jqlAssertions.assertFitsFilterForm(jql, IssueNavigatorAssertions.FilterFormParam.createFilterFormParam(formName, "admin"));
        this.issueTableAssertions.assertSearchWithResults(jql, "HSP-1");
    }

    private void _testSearchByFullNameDoesntFit(String field) throws Exception {
        String jql = field + " = " + "Administrator";
        this.jqlAssertions.assertTooComplex(jql);
        this.issueTableAssertions.assertSearchWithResults(jql, "HSP-1");
    }

    private void _testSearchByEmailDoesntFit(String field) throws Exception {
        String jql = field + " = 'admin@example.com'";
        this.jqlAssertions.assertTooComplex(jql);
        this.issueTableAssertions.assertSearchWithResults(jql, "HSP-1");
    }

    private void _testSearchByEmailReturnsResultsByEmail(String field) throws Exception {
        this.issueTableAssertions.assertSearchWithResults(field + " = 'email@example.com'", "HSP-3");
    }
}

