/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;
import java.io.IOException;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.SLOW_IMPORT})
@LoginAs(user="admin")
@Restore(value="TestUserQueriesCaseInsensitive.xml")
public class TestUserQueriesCaseInsensitive
extends BaseJiraFuncTest {
    @Inject
    private IssueTableAssertions jql;
    @Inject
    private Parser parse;
    @Inject
    private FuncTestLogger logger;

    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testUserQueries() throws Exception {
        Assert.assertEquals((Object)"Administrator from LDAP", (Object)this.parse.header().getFullUserName());
        this.logger.log((Object)"Running queries with (pseudo) LDAP directory first");
        this.runUserQueries();
        this.swapDirectories();
        Assert.assertEquals((Object)"Administrator in the Shadows", (Object)this.parse.header().getFullUserName());
        this.logger.log((Object)"Running queries with internal directory first");
        this.runUserQueries();
    }

    private void runUserQueries() {
        this.logger.log((Object)"Running assignee queries");
        this.jql.assertSearchWithResults("assignee = admin", "NO-1", "MKY-1", "JRA-2", "HSP-1", "CONF-1", "ABC-4");
        this.jql.assertSearchWithResults("assignee = Admin", "NO-1", "MKY-1", "JRA-2", "HSP-1", "CONF-1", "ABC-4");
        this.jql.assertSearchWithResults("assignee = fred", new String[0]);
        this.jql.assertSearchWithResults("assignee = Fred", new String[0]);
        this.logger.log((Object)"Running reporter queries");
        this.jql.assertSearchWithResults("reporter = admin", "NO-1", "JRA-2", "JRA-1", "CONF-1", "ABC-3", "ABC-2");
        this.jql.assertSearchWithResults("reporter = Admin", "NO-1", "JRA-2", "JRA-1", "CONF-1", "ABC-3", "ABC-2");
        this.jql.assertSearchWithResults("reporter = currentUser()", "NO-1", "JRA-2", "JRA-1", "CONF-1", "ABC-3", "ABC-2");
        this.logger.log((Object)"Running voter queries");
        this.jql.assertSearchWithResults("voter = admin", "MKY-1");
        this.jql.assertSearchWithResults("voter = Admin", "MKY-1");
        this.jql.assertSearchWithResults("voter = fred", "MKY-1", "JRA-2");
        this.jql.assertSearchWithResults("voter = Fred", "MKY-1", "JRA-2");
        this.logger.log((Object)"Running watcher queries");
        this.jql.assertSearchWithResults("watcher = admin", "JRA-2");
        this.jql.assertSearchWithResults("watcher = Admin", "JRA-2");
        this.logger.log((Object)"Running custom field queries");
        this.jql.assertSearchWithResults("\"QA done by\" = John", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.jql.assertSearchWithResults("\"QA done by\" = john", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.jql.assertSearchWithResults("\"Interested parties\" = admin", "JRA-1", "HSP-1");
        this.jql.assertSearchWithResults("\"Interested parties\" = Admin", "JRA-1", "HSP-1");
        this.jql.assertSearchWithResults("\"Interested parties\" = John", "JRA-2", "HSP-1", "CONF-1");
        this.jql.assertSearchWithResults("\"Interested parties\" = john", "JRA-2", "HSP-1", "CONF-1");
        this.logger.log((Object)"Running change history queries");
        this.jql.assertSearchWithResults("reporter was admin before \"2009-07-24\"", "NO-1", "JRA-2", "JRA-1", "CONF-1", "ABC-2");
        this.jql.assertSearchWithResults("reporter was Admin before \"2009-07-24\"", "NO-1", "JRA-2", "JRA-1", "CONF-1", "ABC-2");
        this.jql.assertSearchWithResults("reporter was not admin after \"2009-07-24\"", "MKY-1", "HSP-1", "ABC-4");
        this.jql.assertSearchWithResults("reporter was not Admin after \"2009-07-24\"", "MKY-1", "HSP-1", "ABC-4");
    }

    private void swapDirectories() throws IOException, SAXException {
        this.logger.log((Object)"Swap directory order");
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/directories/list");
        this.tester.setWorkingForm("");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        WebLink link = userDirectoryTable.getTableCell(2, 3).getLinkWith("up");
        this.navigation.clickLinkWithPost(link);
    }
}

