/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.priority;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.ChangeHistoryAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.CHANGE_HISTORY})
@Restore(value="TestChangeHistorySearch.xml")
@LoginAs(user="admin")
public class TestPriorityWasSearching
extends BaseJiraFuncTest {
    private static final String FIELD_NAME = "priority";
    private static final String[] ALL_ISSUES = new String[]{"HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
    private static final String INDEXING_LIMIT = "6";
    private static final long HSP_PROJECT_ID = 10000L;
    @Inject
    private ChangeHistoryAssertions changeHistoryAssertions;

    @Before
    public void setUpSearchLayout() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.systemProperties().setProperty("jira.safeguards.indexing.issue.changelogs", INDEXING_LIMIT);
        this.backdoor.indexing().reindexProject(10000L);
    }

    @After
    public void tearDown() {
        this.backdoor.systemProperties().unsetProperty("jira.safeguards.indexing.issue.changelogs");
    }

    @Test
    public void testWasEmptySearch() {
        this.changeHistoryAssertions.assertWasEmptySearchReturnsEmptyValuesUsingEmptyKeyword(FIELD_NAME, new String[0]);
    }

    @SinceBuildRule.SinceBuild(buildNumber=900004)
    @Test
    public void testWasNotEmptySearch() {
        this.changeHistoryAssertions.assertWasNotEmptySearchReturnsNotEmptyValuesWithEmptyKeyword(FIELD_NAME, ALL_ISSUES);
    }

    @Test
    public void testWasSearchUsingSingleValueOperandsReturnsExpectedValues() {
        String[] expectedIssues = this.exclude(ALL_ISSUES, "HSP-10");
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "major", expectedIssues);
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "minor", "HSP-7", "HSP-2");
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "catastrophic", "HSP-7", "HSP-1");
    }

    @Test
    public void testWasSearchUsingListOperands() {
        HashSet priorities = Sets.newHashSet((Object[])new String[]{"major", "minor"});
        String[] expectedIssues = this.exclude(ALL_ISSUES, "HSP-10");
        this.changeHistoryAssertions.assertWasInSearchReturnsExpectedValues(FIELD_NAME, priorities, expectedIssues);
        priorities = Sets.newHashSet((Object[])new String[]{"minor", "catastrophic"});
        this.changeHistoryAssertions.assertWasInSearchReturnsExpectedValues(FIELD_NAME, priorities, "HSP-7", "HSP-2", "HSP-1");
    }

    @SinceBuildRule.SinceBuild(buildNumber=900004)
    @Test
    public void testWasNotInSearchUsingListOperands() {
        HashSet priorities = Sets.newHashSet((Object[])new String[]{"minor", "catastrophic"});
        String[] expected = new String[]{"HSP-10", "HSP-9", "HSP-8", "HSP-6", "HSP-5", "HSP-4", "HSP-3"};
        this.changeHistoryAssertions.assertWasNotInSearchReturnsExpectedValues(FIELD_NAME, priorities, expected);
    }

    @Test
    public void testWasSearchForRenamedConstant() {
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "critical", "HSP-7");
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "catastrophic", "HSP-7", "HSP-1");
    }

    @Test
    public void testWasSearchUsingByPredicate() {
        String[] expected = new String[]{"HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.changeHistoryAssertions.assertWasBySearchReturnsExpectedValues(FIELD_NAME, "major", "admin", expected);
        expected = new String[]{"HSP-1"};
        this.changeHistoryAssertions.assertWasBySearchReturnsExpectedValues(FIELD_NAME, "catastrophic", "fred", expected);
        this.changeHistoryAssertions.assertWasBySearchUsingListOperandsReturnsExpectedValues(FIELD_NAME, "catastrophic", Sets.newHashSet((Object[])new String[]{"fred", "bob"}), "HSP-1");
    }

    @Test
    public void testWasSearchUsingDuringPredicate() {
        String[] expected = new String[]{"HSP-9", "HSP-8", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.changeHistoryAssertions.assertWasDuringSearchReturnsExpectedValues(FIELD_NAME, "major", "'2011/05/30'", "'2011/06/02'", expected);
    }

    @Test
    public void testWasSearchUsingBeforePredicate() {
        String[] expected = this.exclude(ALL_ISSUES, "HSP-10");
        this.changeHistoryAssertions.assertWasBeforeSearchReturnsExpectedValues(FIELD_NAME, "major", "'2011/06/01'", expected);
        expected = new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.changeHistoryAssertions.assertWasBeforeSearchReturnsExpectedValues(FIELD_NAME, "major", "'2010/06/02'", expected);
    }

    @Test
    public void testWasSearchUsingAfterPredicate() {
        String[] expected = this.exclude(ALL_ISSUES, "HSP-10");
        this.changeHistoryAssertions.assertWasAfterSearchReturnsExpectedValues(FIELD_NAME, "major", "'2011/05/01'", expected);
        expected = new String[]{"HSP-9", "HSP-8", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.changeHistoryAssertions.assertWasAfterSearchReturnsExpectedValues(FIELD_NAME, "major", "'2011/06/01 10:55'", expected);
    }

    @Test
    public void testWasSearchUsingOnPredicate() {
        String[] expected = this.exclude(ALL_ISSUES, "HSP-10");
        this.changeHistoryAssertions.assertWasOnSearchReturnsExpectedValues(FIELD_NAME, "major", "'2011/05/01'", expected);
        expected = new String[]{"HSP-9", "HSP-8", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.changeHistoryAssertions.assertWasOnSearchReturnsExpectedValues(FIELD_NAME, "major", "'2011/06/01'", expected);
    }

    @Test
    public void testWasSearchUsingLongOperandsIsInvalid() {
        String expectedError = "A value with ID '7' does not exist for the field 'priority'.";
        this.changeHistoryAssertions.assertInvalidSearchProducesError(FIELD_NAME, "7", "", "A value with ID '7' does not exist for the field 'priority'.");
    }

    @Test
    public void testWasSearchUsingLongOperandsIsValid() {
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "4", "HSP-7", "HSP-2");
    }

    @Test
    public void testWasSearchUsingUnclosedListIsInvalid() {
        String expectedError = "Error in the JQL Query: Expecting ')' before the end of the query.";
        this.changeHistoryAssertions.assertInvalidSearchProducesError(FIELD_NAME, "(major, minor", "", "Error in the JQL Query: Expecting ')' before the end of the query.");
    }

    @Test
    public void testWasSearchUsingIcorrectPriorityIsInvalid() {
        String expectedError = "The value 'urgent' does not exist for the field 'priority'.";
        this.changeHistoryAssertions.assertInvalidSearchProducesError(FIELD_NAME, "urgent", "", "The value 'urgent' does not exist for the field 'priority'.");
    }

    @Test
    public void testWasSearchUsingIncorrectPredicateIsInvalid() {
        String expectedError = "Error in the JQL Query: Expecting either 'OR' or 'AND' but got 'at'. (line 1, character 29)";
        this.changeHistoryAssertions.assertInvalidSearchProducesError(FIELD_NAME, "(major, minor)", "at '10:55'", "Error in the JQL Query: Expecting either 'OR' or 'AND' but got 'at'. (line 1, character 29)");
    }

    @Test
    public void testWasSearchUsingIncorrectFunctionIsInvalid() {
        String expectedError = "A value provided by the function 'currentLogin' is invalid for the field 'priority'.";
        this.changeHistoryAssertions.assertInvalidSearchProducesError(FIELD_NAME, "currentLogin()", "", "A value provided by the function 'currentLogin' is invalid for the field 'priority'.");
    }

    @Test
    public void testWasSearchForNotIndexedPriority() {
        String[] expectedIssues = this.exclude(ALL_ISSUES, "HSP-10");
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "major", expectedIssues);
    }

    @SinceBuildRule.SinceBuild(buildNumber=900004)
    @Test
    public void testWasSearchForIndexedPriority() {
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "blocker", "HSP-10");
    }

    private String[] exclude(String[] notFilteredArray, String ... elementsToFilterOut) {
        HashSet excludeElements = Sets.newHashSet((Object[])elementsToFilterOut);
        return (String[])Arrays.stream(notFilteredArray).filter(element -> !excludeElements.contains(element)).toArray(String[]::new);
    }
}

