/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.status;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@Restore(value="TestWasSearch.xml")
@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.CHANGE_HISTORY})
public class TestSearchChangesInStatus
extends BaseJiraFuncTest {
    @Inject
    private IssueTableAssertions issueTableAssertions;

    @Before
    public void setUpTest() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    @LoginAs(user="bob")
    public void ReturnsAllIssuesThatWereInASpecificStatus() {
        String[] openIssues = new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.issueTableAssertions.assertSearchWithResults("status was Open", openIssues);
    }

    @Test
    @LoginAs(user="bob")
    public void ReturnsAllIssuesThatWereNotEverInASpecificStatus() throws Exception {
        String[] openIssues = new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.issueTableAssertions.assertSearchWithResults("Status was not 'In Progress'", openIssues);
    }

    @Test
    @LoginAs(user="bob")
    public void ReturnsAllIssuesThatWereInASetOfSpecificStatuses() throws Exception {
        String[] openIssues = new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.issueTableAssertions.assertSearchWithResults("status was in (Open,'In Progress')", openIssues);
    }

    @Test
    @LoginAs(user="bob")
    public void ReturnsAllIssuesThatWereNotEverInASetOfSpecificStatuses() throws Exception {
        String[] openIssues = new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.issueTableAssertions.assertSearchWithResults("status was not in ('In Progress',Reopened,Closed)", openIssues);
    }

    @Test
    @LoginAs(user="bob")
    public void ReturnsZeroIssuesForAStatusThatHasNeverBeenSet() throws Exception {
        this.issueTableAssertions.assertSearchWithResults("status was Closed", new String[0]);
    }

    @Test
    @LoginAs(user="bob")
    public void IgnoresTheCaseOfTheStatusValue() throws Exception {
        this.issueTableAssertions.assertSearchWithResults("status was Open", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.issueTableAssertions.assertSearchWithResults("Status was open", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.issueTableAssertions.assertSearchWithResults("Status was oPEn", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
    }

    @Test
    @LoginAs(user="bob")
    public void ReturnsAnErrorForANonExistingStatus() {
        this.issueTableAssertions.assertSearchWithError("status was dingbat", "The value 'dingbat' does not exist for the field 'status'.");
    }

    @Test
    @LoginAs(user="fred")
    public void TakesIntoAccountUpdatesToTheStatusOfAnIssue() {
        String issueToBeUpdated = "HSP-1";
        String[] openIssues = new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.navigation.issue().closeIssue("HSP-1", "Fixed", "Fixed");
        this.issueTableAssertions.assertSearchWithResults("status was Open", openIssues);
        this.issueTableAssertions.assertSearchWithResults("status was Closed", "HSP-1");
    }

    @Test
    @LoginAs(user="admin")
    public void AddingANewStatusAllowsSearchingForIssuesInThatStatus() {
        this.tester.gotoPage("secure/admin/AddStatus!default.jspa");
        this.tester.setFormElement("name", "myStatus");
        this.tester.submit("Add");
        this.issueTableAssertions.assertSearchWithResults("status was myStatus", new String[0]);
    }

    @Test
    @LoginAs(user="admin")
    public void StatusFieldRename() {
        this.navigation.issue().closeIssue("HSP-1", "Fixed", "Fixed");
        this.issueTableAssertions.assertSearchWithResults("status was Closed", "HSP-1");
        this.tester.gotoPage("secure/admin/EditStatus!default.jspa?id=6");
        this.tester.setFormElement("name", "Shut");
        this.tester.submit("Update");
        this.issueTableAssertions.assertSearchWithResults("Status was Closed", "HSP-1");
        this.issueTableAssertions.assertSearchWithResults("Status was shut", "HSP-1");
    }
}

