/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.status.date;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.CHANGE_HISTORY})
@Restore(value="TestSearchIssueStatusOnADate.xml")
@LoginAs(user="admin")
public class TestSearchIssueStatusOnADate
extends BaseJiraFuncTest {
    @Before
    public void setUpTest() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testShouldReturnIssuesThatWereInThatStatusGivenThatTheIssuesTransitionedToThatStatusDuringTheDate() {
        this.navigation.issueNavigator().createSearch("project=svo and status was 'In Progress' ON '2009-12-12' order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVO-1", "SVO-2", "SVO-3");
    }

    @Test
    public void testReturnsIssuesThatWereInTheStatusGivenThatTheyTransitionedToThatStatusPriorToTheDate() {
        this.navigation.issueNavigator().createSearch("project=svo and status was 'In Progress' ON '2010-12-12' order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVO-3", "SVO-4", "SVO-5");
    }

    @Test
    public void testReturnsIssuesThatWereInTheStatusGivenThatTheyHaveNotTransitionedFromTheInitialStatusValue() {
        this.navigation.issueNavigator().createSearch("project=svo and status was 'Open' ON '2008-12-12' order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVO-6");
    }

    @Test
    public void testDoesNotReturnIssuesThatWereNotInTheStatusGivenThatTheyTransitionedToThatStatusOnADifferentDate() {
        this.navigation.issueNavigator().createSearch("project=svo and status was 'Closed' ON '2010-12-12' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsDoNotContain("SVO-7", "SVO-8");
    }

    @Test
    public void testDoesNotReturnIssuesThatWereNeverInThatStatus() {
        this.navigation.issueNavigator().createSearch("project=svo and status was 'Closed' ON '2010-12-12' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsDoNotContain("SVO-9", "SVO-10", "SVO-11");
    }

    @Test
    public void testReturnsIssuesThatWereSetToThatStatusWithMoreThanOneDateValue() {
        this.navigation.issueNavigator().createSearch("project=svo and status was Closed on '2010-12-10' order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVO-7", "SVO-17");
        this.navigation.issueNavigator().createSearch("project=svo and status was Closed on ('2010-12-10') order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVO-7", "SVO-17");
        this.navigation.issueNavigator().createSearch("project=svo and status was Closed on ('2010-12-10','2010-12-11') order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVO-7", "SVO-16", "SVO-17");
        this.navigation.issueNavigator().createSearch("project=svo and status was Closed on ('2010-12-12', '2010-12-12') order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVO-17");
        this.navigation.issueNavigator().createSearch("project=svo and status was Closed on ('2010-12-12', '2010-12-13') order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVO-8", "SVO-17");
        this.navigation.issueNavigator().createSearch("project=svo and status was Closed on ('2010-12-10', '2010-12-12', '2010-12-13') order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVO-7", "SVO-8", "SVO-17");
        this.navigation.issueNavigator().createSearch("project=svo and status was Closed on ('2010-12-19', '2010-12-10', '2010-12-12', '2010-12-13') order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVO-7", "SVO-8", "SVO-17");
    }

    @Test
    public void testReturnsIssuesThatWereSetToThatStatusAtOrJustAfterTheBeginningOfTheDateOrAtOrJustAfterTheEndOfTheDate() {
        this.navigation.issueNavigator().createSearch("project=svo and status was 'Resolved' ON '2010-12-12' order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVO-12", "SVO-13", "SVO-14");
    }

    @Test
    public void testDoesNotReturnIssuesThatWereInThatStatusJustBeforeOrAfterTheEndOfTheDate() {
        this.navigation.issueNavigator().createSearch("project=svo and status was 'Reopened' ON '2010-12-12' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsDoNotContain("SVO-17");
        this.navigation.issueNavigator().createSearch("project=svo and status was 'Reopened' ON '2010-12-16' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsDoNotContain("SVO-18");
    }
}

