/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.osgi;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.OsgiBundleControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.osgi.OsgiTestUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebTest(value={Category.FUNC_TEST, Category.INFRASTRUCTURE, Category.OSGI})
@LoginAs(user="admin")
public class TestOsgiExports
extends BaseJiraFuncTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestOsgiExports.class);
    private static final String[] CORE_INTERNAL_PACKAGE_PREFIXES = new String[0];
    public static final String ORG_APACHE_FELIX_FRAMEWORK = "org.apache.felix.framework";
    public static final Integer SYSTEM_BUNDLE_ID = 0;
    private static final Set<String> JDK_PACKAGES_IGNORED_PREFIXES = Stream.of("com.sun.jarsigner", "com.sun.java.accessibility.util", "com.sun.javadoc", "com.sun.jdi", "com.sun.jndi", "com.sun.management", "com.sun.net", "com.sun.nio", "com.sun.security", "com.sun.source", "com.sun.tools", "java.", "javax.", "jdk.", "netscape.javascript", "org.omg.", "sun.").collect(Collectors.toSet());
    private static final Set<String> DEV_MODE_IGNORED_PACKAGES = Stream.of("com.atlassian.instrumentation.driver", "com.atlassian.instrumentation.instruments", "com.atlassian.jira.dev.reference.plugin.components", "com.atlassian.labs.restbrowser.plugin", "com.atlassian.labs.restbrowser.provider", "com.atlassian.labs.restbrowser.rest.model", "com.atlassian.labs.restbrowser.rest.services", "com.atlassian.labs.restbrowser.servlet", "com.atlassian.labs.restbrowser.util").collect(Collectors.toSet());
    private static final Set<String> TEST_PLUGIN_IGNORED_PACKAGES = Stream.of("com.atlassian.functest.api", "com.atlassian.functest.junit", "com.atlassian.migration.agent.testsupport", "com.atlassian.migration.agent.testsupport.appassessment", "groovy.lang", "groovy.text", "groovy.text.markup", "groovy.xml", "io.netty.buffer", "io.netty.channel", "io.netty.channel.socket", "io.netty.handler.ssl", "junit.framework", "org.junit", "org.junit.experimental", "org.junit.experimental.categories", "org.junit.experimental.max", "org.junit.experimental.results", "org.junit.experimental.runners", "org.junit.experimental.theories", "org.junit.experimental.theories.internal", "org.junit.experimental.theories.suppliers", "org.junit.internal", "org.junit.internal.builders", "org.junit.internal.matchers", "org.junit.internal.requests", "org.junit.internal.runners", "org.junit.internal.runners.model", "org.junit.internal.runners.rules", "org.junit.internal.runners.statements", "org.junit.matchers", "org.junit.rules", "org.junit.runner", "org.junit.runner.manipulation", "org.junit.runner.notification", "org.junit.runners", "org.junit.runners.model", "org.junit.runners.parameterized", "org.junit.validator").collect(Collectors.toSet());
    private static OsgiBundleControl osgiBundleControl;
    private static Set<String> expectedSystemBundleExports;
    private static Set<String> expectedPublicApiExports;
    private static Set<String> expectedDeprecatedExports;

    @BeforeClass
    public static void readExpectedExports() {
        expectedSystemBundleExports = OsgiTestUtils.readOsgiPackagesFromFile(OsgiTestUtils.systemPackagesFilename());
        Assertions.assertThat(expectedSystemBundleExports).isNotEmpty();
        expectedPublicApiExports = OsgiTestUtils.readOsgiPackagesFromFile(OsgiTestUtils.publicApiPackagesFilename());
        Assertions.assertThat(expectedPublicApiExports).isNotEmpty();
        expectedDeprecatedExports = OsgiTestUtils.readOsgiPackagesFromFile(OsgiTestUtils.deprecatedPackagesFilename());
        Assertions.assertThat(expectedDeprecatedExports).isNotEmpty();
    }

    @Before
    public void setUpTest() {
        osgiBundleControl = new OsgiBundleControl(this.environmentData);
    }

    @AfterClass
    public static void generateBundleFiles() throws IOException {
        TestOsgiExports.saveToFile(TestOsgiExports.getSystemBundleExports(), OsgiTestUtils.systemPackagesFilename());
        TestOsgiExports.saveToFile(TestOsgiExports.getActualPublicApiExports(), OsgiTestUtils.publicApiPackagesFilename());
        JsonNode internalJson = (JsonNode)TestOsgiExports.getBundlesTarget().request().get(JsonNode.class);
        Path allBundlesFile = Paths.get("target", "internal-osgi-bundles.json");
        try {
            LOG.info("Writing OSGi bundle info to {}", (Object)allBundlesFile.toAbsolutePath());
            new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue(allBundlesFile.toFile(), (Object)internalJson);
        }
        catch (IOException e) {
            LOG.warn("Failed to write bundle info to {}", (Object)allBundlesFile);
        }
    }

    private static void saveToFile(Set<String> packages, String filename) throws IOException {
        Path packagesFile = Paths.get("target", filename);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(packagesFile.toFile()));){
            for (String publicPackage : packages) {
                out.write(publicPackage);
                out.newLine();
            }
        }
    }

    @Test
    public void testSystemBundleExportsMissingExports() {
        Sets.SetView missingExports = Sets.difference(expectedSystemBundleExports, TestOsgiExports.getSystemBundleExports());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)missingExports).describedAs("\nThe following \"Export-Package\"s were expected in the system OSGi bundle, but are missing.\nThis may mean that:\n - 'compile'-scoped dependencies have been removed or changed,\n - core packages were removed,\n - or packageScanningConfiguration in DefaultPackageScannerConfiguration started excluding too much.\nAll public exports from the system bundle are available to plugins, they're effectively part of the platform.\nThis tests both internal and public system bundle exports, so if something disappeared here but not in public API test,\nit will affect only internal plugins.Check whether removing these packages from the OSGi environment is likely to break plugins.\nIf they SHOULD be removed, contact #team-borg and likely remove them from %s in the test.\n", new Object[]{OsgiTestUtils.systemPackagesFilename()})).isEmpty();
    }

    @Test
    public void testSystemBundleExportsUnexpectedExports() {
        Sets.SetView extraExports = Sets.difference(TestOsgiExports.getSystemBundleExports(), expectedSystemBundleExports);
        ((ListAssert)Assertions.assertThat(extraExports.stream().sorted()).describedAs("\nThe following \"Export-Package\"s were unexpectedly present in the system OSGi bundle.\nThis may mean that:\n - 'compile'-scoped dependencies have been added or changed,\n - core packages were added,\n - or packageScanningConfiguration in DefaultPackageScannerConfiguration is too lenient.\nAll public exports from the system bundle are available to plugins, they're effectively part of the platform.\nThis tests both internal and public system bundle exports, so if something appeared here but not in public API test,\nit will affect only internal plugins - no need to worry.However, if the package is also present in public API test, consider if it should be public API.\nIf it should be added as public, contact #team-borg and likely add them to %s in the test.\n", new Object[]{OsgiTestUtils.systemPackagesFilename()})).isEmpty();
    }

    private static Set<String> getSystemBundleExports() {
        OsgiPackageExports exports = TestOsgiExports.getBundlePackageExports(SYSTEM_BUNDLE_ID);
        Assertions.assertThat((Object)exports).extracting(OsgiPackageExports::getBundleName).isEqualTo((Object)ORG_APACHE_FELIX_FRAMEWORK);
        Set<String> actualExports = exports.getExportedPackages().stream().filter(export -> JDK_PACKAGES_IGNORED_PREFIXES.stream().noneMatch(export::startsWith)).filter(export -> !DEV_MODE_IGNORED_PACKAGES.contains(export)).collect(Collectors.toSet());
        Assertions.assertThat(actualExports).isNotEmpty();
        return actualExports;
    }

    @Test
    public void testPublicApiExportsMissingExports() {
        Sets.SetView missingExports = Sets.difference(expectedPublicApiExports, TestOsgiExports.getActualPublicApiExports());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)missingExports).describedAs("\nThe following \"Export-Package\"s were expected in the OSGi system, but are missing.\nThis may mean that:\n - 'compile'-scoped dependencies have been removed or changed,\n - public core packages were removed,\n - public plugin packages were removed,\n - or packageScanningConfiguration in DefaultPackageScannerConfiguration started excluding too much.\nAll public exports from core and plugins are available to 3rd party plugins, they're effectively part of the platform.\nThis tests public exports from core and plugins, so if something disappeared here,\nit might affect 3rd party vendors plugins.Check whether removing these packages from the OSGi environment is likely to break plugins.\nIf they SHOULD be removed, contact #team-borg and likely remove them from %s in the test.\n", new Object[]{OsgiTestUtils.publicApiPackagesFilename()})).isEmpty();
    }

    @Test
    public void testPublicApiExportsUnexpectedExports() {
        Sets.SetView extraExports = Sets.difference(TestOsgiExports.getActualPublicApiExports(), expectedPublicApiExports);
        ((ListAssert)Assertions.assertThat(extraExports.stream().sorted()).describedAs("\nThe following \"Export-Package\"s were unexpectedly present in the OSGi system.\nThis may mean that:\n - 'compile'-scoped dependencies have been added or changed,\n - public core packages were added,\n - public plugin packages were added,\n - or packageScanningConfiguration in DefaultPackageScannerConfiguration is too lenient.\nAll public exports from core and plugins are available to 3rd party plugins, they're effectively part of the platform.\nThis tests public exports from core and plugins, so if something appeared here,\nit should be considered if we really want it to be accessible by vendors.Check whether adding these packages as public exports to OSGi is really needed.\nIf they SHOULD be added, contact #team-borg and likely add them to %s in the test.\n", new Object[]{OsgiTestUtils.publicApiPackagesFilename()})).isEmpty();
    }

    @Test
    public void testPublicApiExportsDeprecatedPackages() {
        Set<String> realNonDeprecatedPackages = TestOsgiExports.getActualPublicApiExportsWithoutDeprecatedPackages();
        Sets.SetView realDeprecatedPackages = Sets.difference(expectedPublicApiExports, realNonDeprecatedPackages);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)realDeprecatedPackages).describedAs("\nActual deprecated exports differ from the expected ones.\nThis usually means 'compile'-scoped dependencies or a plugin have been added or changed,\nor packageScanningConfiguration in DefaultPackageScannerConfiguration is deprecating too much or too little.\nThe deprecated packages are to be removed in the major release, so if it happened earlier plugins might break.\nConsult %s to see which packages should be currently deprecated.Contact #team-borg if you think this is wrong.", new Object[]{OsgiTestUtils.deprecatedPackagesFilename()})).containsExactlyInAnyOrderElementsOf(expectedDeprecatedExports);
    }

    @Test
    public void testThatPluginsDoNotImportCoreInternalPackages() {
        Stream<OsgiPackageImports> bundlesWithCoreInternalImports = TestOsgiExports.getOsgiPackageImports().stream().map(imports -> imports.withPackagesMatching(CORE_INTERNAL_PACKAGE_PREFIXES)).filter(OsgiPackageImports::hasImports);
        ((ListAssert)Assertions.assertThat(bundlesWithCoreInternalImports).describedAs("The following plugins import internal packages from Jira core", new Object[0])).isEmpty();
    }

    private static List<OsgiPackageImports> getOsgiPackageImports() {
        return (List)TestOsgiExports.getBundlesTarget().request().get((GenericType)new GenericType<List<OsgiPackageImports>>(){});
    }

    private static OsgiPackageExports getBundlePackageExports(int bundleId) {
        return (OsgiPackageExports)TestOsgiExports.getBundlesTarget().path(String.valueOf(bundleId)).request().get(OsgiPackageExports.class);
    }

    public static Set<String> getActualPublicApiExports() {
        return TestOsgiExports.getAllPublicBundlePackageExports().stream().flatMap(exports -> exports.getPublicPackages().stream()).filter(export -> !TEST_PLUGIN_IGNORED_PACKAGES.contains(export)).filter(export -> !DEV_MODE_IGNORED_PACKAGES.contains(export)).filter(export -> JDK_PACKAGES_IGNORED_PREFIXES.stream().noneMatch(export::startsWith)).collect(Collectors.toCollection(TreeSet::new));
    }

    public static Set<String> getActualPublicApiExportsWithoutDeprecatedPackages() {
        return TestOsgiExports.getAllPublicPackageExportsWithoutDeprecatedExports().stream().flatMap(exports -> exports.getPublicPackages().stream()).filter(export -> !TEST_PLUGIN_IGNORED_PACKAGES.contains(export)).filter(export -> !DEV_MODE_IGNORED_PACKAGES.contains(export)).filter(export -> JDK_PACKAGES_IGNORED_PREFIXES.stream().noneMatch(export::startsWith)).collect(Collectors.toCollection(TreeSet::new));
    }

    private static List<OsgiPackageExports> getAllPublicBundlePackageExports() {
        return (List)TestOsgiExports.getBundlesTarget().request().get((GenericType)new GenericType<List<OsgiPackageExports>>(){});
    }

    private static List<OsgiPackageExports> getAllPublicPackageExportsWithoutDeprecatedExports() {
        return (List)TestOsgiExports.getBundlesTarget().queryParam("treatDeprecatedPackagesAsPublic", new Object[]{"false"}).request().get((GenericType)new GenericType<List<OsgiPackageExports>>(){});
    }

    private static WebTarget getBundlesTarget() {
        return osgiBundleControl.getBundles();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class OsgiPackageExports {
        private final String bundleName;
        private final Set<String> exportedPackages;
        private final Set<String> publicPackages;

        @JsonCreator
        public OsgiPackageExports(@JsonProperty(value="bundleName") String bundleName, @JsonProperty(value="exportedPackages") Set<String> exportedPackages, @JsonProperty(value="publicPackages") Set<String> publicPackages) {
            this.bundleName = bundleName;
            this.exportedPackages = exportedPackages;
            this.publicPackages = publicPackages;
        }

        public String getBundleName() {
            return this.bundleName;
        }

        public Set<String> getExportedPackages() {
            return this.exportedPackages;
        }

        public Set<String> getPublicPackages() {
            return this.publicPackages;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class OsgiPackageImports {
        private final String bundleName;
        private final Set<String> packages;

        @JsonCreator
        public OsgiPackageImports(@JsonProperty(value="bundleName") String bundleName, @JsonProperty(value="importedPackages") Set<String> packages) {
            this.bundleName = bundleName;
            this.packages = packages;
        }

        boolean hasImports() {
            return !this.packages.isEmpty();
        }

        OsgiPackageImports withPackagesMatching(String ... packagePrefixes) {
            return new OsgiPackageImports(this.bundleName, Arrays.stream(packagePrefixes).flatMap(packagePrefix -> this.packages.stream().filter(packageName -> packageName.startsWith((String)packagePrefix))).collect(Collectors.toSet()));
        }

        public String toString() {
            return String.format("Bundle [%s] imports packages %s", this.bundleName, this.packages);
        }
    }
}

