/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRuleChain;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.PluginsControlExt;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

@WebTest(value={Category.FUNC_TEST, Category.PLUGINS})
@LoginAs(user="admin")
@Ignore(value="DELTA-782")
public class TestPluginEnableAndDisableTime
extends BaseJiraFuncTest {
    @Rule
    public RuleChain funcTestRuleChain = FuncTestRuleChain.forTest(this);
    @Inject
    private FuncTestLogger logger;
    private final String PLUGIN_OBR_URL = "https://packages.atlassian.com/maven-public/com/atlassian/jira/tests/dep-plugin-two-thousand/1.0.1/dep-plugin-two-thousand-1.0.1.obr";
    private final String FIRST_PLUGIN_KEY = "com.atlassian.jira.tests.dep-plugin-one-thousand";
    private final String SECOND_PLUGIN_KEY = "com.atlassian.jira.tests.dep-plugin-two-thousand";
    private static final long STATUS_TIMEOUT_MILLIS = 30000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="JC-389 flaky test")
    @Test
    @Restore(value="TestPluginEnableAndDisableTime.xml")
    public void testIfPluginsEnableDisableTime() throws Exception {
        this.setupPlugins();
        int numUsers = 5;
        ExecutorService executor = Executors.newFixedThreadPool(11);
        HttpGet searchIssue = new HttpGet(this.environmentData.getBaseUrl().toString() + "/rest/api/2/search?jql=summary%20~%20%22test%22%20ORDER%20BY%20createdDate&startAt=0&maxResults=10&os_authType=basic&os_username=admin&os_password=admin");
        HttpGet viewIssue = new HttpGet(this.environmentData.getBaseUrl().toString() + "/browse/TEST-1?os_authType=basic&os_username=admin&os_password=admin");
        try {
            for (int i = 0; i < 5; ++i) {
                executor.submit(() -> this.generateLoad((HttpRequestBase)searchIssue));
                executor.submit(() -> this.generateLoad((HttpRequestBase)viewIssue));
            }
            TimeUnit.SECONDS.sleep(2L);
            Future<?> enabling = executor.submit(() -> this.getBackdoor().plugins().enablePlugin("com.atlassian.jira.tests.dep-plugin-two-thousand"));
            this.waitUntil(enabling::isDone);
            this.waitForEnablingPlugins();
            Future<?> disabling = executor.submit(() -> this.getBackdoor().plugins().disablePlugin("com.atlassian.jira.tests.dep-plugin-one-thousand"));
            this.waitUntil(disabling::isDone);
            this.waitForDisablingPlugins();
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void setupPlugins() throws MalformedURLException {
        PluginsControlExt plugins = this.getBackdoor().plugins();
        plugins.uploadPlugin(new URL("https://packages.atlassian.com/maven-public/com/atlassian/jira/tests/dep-plugin-two-thousand/1.0.1/dep-plugin-two-thousand-1.0.1.obr"));
        this.waitForEnablingPlugins();
        plugins.disablePlugin("com.atlassian.jira.tests.dep-plugin-one-thousand");
        plugins.disablePlugin("com.atlassian.jira.tests.dep-plugin-two-thousand");
        this.waitForDisablingPlugins();
    }

    private boolean isPluginEnabled(String pluginKey) {
        PluginsControlExt plugins = this.getBackdoor().plugins();
        Optional<PluginsControlExt.PluginBean> optPlugin = plugins.getPlugin(pluginKey);
        return optPlugin.isPresent() && optPlugin.get().getEnabled() != false;
    }

    private void waitForEnablingPlugins() {
        this.waitUntil(() -> this.isPluginEnabled("com.atlassian.jira.tests.dep-plugin-one-thousand"));
        this.waitUntil(() -> this.isPluginEnabled("com.atlassian.jira.tests.dep-plugin-two-thousand"));
    }

    private void waitForDisablingPlugins() {
        this.waitUntil(() -> !this.isPluginEnabled("com.atlassian.jira.tests.dep-plugin-one-thousand"));
        this.waitUntil(() -> !this.isPluginEnabled("com.atlassian.jira.tests.dep-plugin-two-thousand"));
    }

    private void waitUntil(Callable<Boolean> condition) {
        Awaitility.await().atMost(30000L, TimeUnit.MILLISECONDS).pollInterval(Duration.FIVE_HUNDRED_MILLISECONDS).until(condition);
    }

    private void generateLoad(HttpRequestBase request) {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            while (!Thread.interrupted()) {
                try {
                    httpClient.execute((HttpUriRequest)request).getEntity().getContent().close();
                }
                catch (Exception e) {
                    this.logger.log((Throwable)e);
                }
            }
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
        }
    }
}

