/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.webresource;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.TerminologyClient;
import com.atlassian.jira.functest.framework.backdoor.WebResourcesControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.v2.i18n.terminology.TerminologyRequestBean;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST})
@LoginAs(user="admin")
public class TestJiraWebResourceIntegration
extends BaseJiraFuncTest {
    private static final FeatureFlag TERMINOLOGY_CHANGES = FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.TERMINOLOGY_CHANGES.featureKey());
    private TerminologyClient terminologyClient;
    private WebResourcesControl webResourceClient;

    @Before
    public void setup() {
        this.backdoor.restoreBlankInstance(LicenseKeys.COMMERCIAL_CORE_ACTIVE_DC);
        this.terminologyClient = this.backdoor.getTerminologyClient();
        this.webResourceClient = this.backdoor.getWebResourcesControl();
        this.backdoor.darkFeatures().enableForSite(TERMINOLOGY_CHANGES);
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().resetForSite(TERMINOLOGY_CHANGES);
    }

    @Test
    public void i18nHashCodeShouldChangeIfTerminologyChanged() {
        ImmutableList inputEpicToTooth = ImmutableList.of((Object)new TerminologyRequestBean(" EpIC  ", "  tOOth ", " \t teETH"));
        this.terminologyClient.setTerminologyEntries((Collection<TerminologyRequestBean>)inputEpicToTooth);
        String initialHashCode = this.webResourceClient.getI18nHashCode();
        ImmutableList inputEpicToFeature = ImmutableList.of((Object)new TerminologyRequestBean(" EpIC  ", "feature", "feature"));
        this.terminologyClient.setTerminologyEntries((Collection<TerminologyRequestBean>)inputEpicToFeature);
        String newHashCode = this.webResourceClient.getI18nHashCode();
        Assert.assertThat((Object)newHashCode, (Matcher)IsNot.not((Matcher)CoreMatchers.equalTo((Object)initialHashCode)));
    }
}

