/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.EnableAnalytics;
import com.atlassian.jira.functest.framework.backdoor.EventClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.jayway.awaitility.Awaitility;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.COMPONENTS_AND_VERSIONS})
public class TestArchiveProjectComponentEvents
extends BaseJiraFuncTest {
    private static final String PROJECT = "PROJ";
    private int COMPONENTS_COUNT = 2;
    private List<String> ids;

    @Before
    public void setUp() {
        this.restoreInstance();
        this.ids = this.createComponents(this.COMPONENTS_COUNT);
    }

    private void restoreInstance() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.project().addProject("Project", PROJECT, "admin");
    }

    private List<String> createComponents(int count) {
        for (int i = 0; i < count; ++i) {
            this.backdoor.components().create(new Component().name("Component-" + i).description("project component").project(PROJECT));
        }
        return (List)this.backdoor.project().getComponentsForProject(PROJECT).stream().map(component -> component.id.toString()).collect(CollectorsUtil.toImmutableList());
    }

    @Test
    @EnableAnalytics
    public void testArchivedProjectComponentEventTriggered() {
        EventClient.EventPoller poller = this.backdoor.events().createPoller();
        Component component = this.backdoor.components().get(this.ids.get(0));
        this.backdoor.components().putResponse(component.archived(true));
        MatcherAssert.assertThat(poller.events(), (Matcher)Matchers.hasItems((Object[])new String[]{"com.atlassian.jira.event.bc.project.component.ProjectComponentArchivedEvent", "com.atlassian.jira.bc.project.component.ArchivedProjectComponentAnalyticEvent"}));
        this.assertEvent("jira.project.component.archive");
        this.backdoor.events().stopAllPollers();
    }

    @Test
    @EnableAnalytics
    public void testRestoredProjectComponentEventTriggered() {
        EventClient.EventPoller poller = this.backdoor.events().createPoller();
        Component component = this.backdoor.components().get(this.ids.get(1));
        this.backdoor.components().putResponse(component.archived(true));
        this.backdoor.components().putResponse(component.archived(false));
        MatcherAssert.assertThat(poller.events(), (Matcher)Matchers.hasItems((Object[])new String[]{"com.atlassian.jira.bc.project.component.RestoredProjectComponentAnalyticEvent", "com.atlassian.jira.event.bc.project.component.ProjectComponentRestoredEvent"}));
        this.assertEvent("jira.project.component.restore");
        this.backdoor.events().stopAllPollers();
    }

    private void assertEvent(String name) {
        Awaitility.await().until(() -> this.backdoor.analyticsEventsControl().matchEvents(name), Matchers.iterableWithSize((int)1));
    }
}

