/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
@SinceBuildRule.SinceBuild(buildNumber=960000)
public class TestArchivedStatistics
extends BaseJiraFuncTest {
    @Before
    public void setUp() {
        this.backdoor.restoreBlankInstance();
    }

    @Test
    public void testNoIssues() {
        Assertions.assertThat((Integer)this.backdoor.search().getSearch((SearchRequest)new SearchRequest()).total).isEqualTo(0);
        Assertions.assertThat((int)this.backdoor.archivedStatistics().getTotalArchivedIssuesCount()).isEqualTo(0);
        Assertions.assertThat((int)this.backdoor.archivedStatistics().getIssuesInArchivedProjectsCount()).isEqualTo(0);
        Assertions.assertThat((int)this.backdoor.archivedStatistics().getArchivedIssuesCount()).isEqualTo(0);
    }

    @Test
    public void testAllArchiveTypes() {
        IssueCreateResponse activeIssue = this.createIssue("HSP", "active issue");
        IssueCreateResponse archivedIssue = this.createIssue("HSP", "archived issue");
        IssueCreateResponse issueInAnArchivedProject = this.createIssue("MKY", "issue in an archived project");
        IssueCreateResponse archivedIssueInAnArchivedProject = this.createIssue("MKY", "archived issue in an archived project");
        this.backdoor.issues().archiveIssue(archivedIssue.key());
        this.backdoor.issues().archiveIssue(archivedIssueInAnArchivedProject.key());
        this.backdoor.project().archiveProject("MKY");
        Assertions.assertThat((int)this.backdoor.archivedStatistics().getTotalArchivedIssuesCount()).isEqualTo(3);
        Assertions.assertThat((int)this.backdoor.archivedStatistics().getIssuesInArchivedProjectsCount()).isEqualTo(2);
        Assertions.assertThat((int)this.backdoor.archivedStatistics().getArchivedIssuesCount()).isEqualTo(2);
    }

    private IssueCreateResponse createIssue(String projectKey, String summary) {
        return this.backdoor.issues().createIssue(projectKey, summary);
    }
}

