/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.assertions.ViewIssueAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.CustomFieldConfig;
import com.atlassian.jira.testkit.beans.CustomFieldResponse;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.util.ProgressPageControl;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SCHEMES, Category.PERMISSIONS, Category.PROJECTS, Category.ISSUE_TYPES, Category.SCREENS, Category.FIELDS, Category.CUSTOM_FIELDS, Category.SECURITY})
@LoginAs(user="admin")
public class TestDeleteProject
extends BaseJiraFuncTest {
    public static final String DELETE_BUTTON_NAME = "delete";
    public static final String REFRESH_BUTTON_NAME = "refresh";
    public static final String ACKNOWLEDGE_BUTTON_NAME = "acknowledge";
    public static final String FORM_NAME = "project-delete-form";
    public static final String DELETE_PROJECT_HEADER = "Delete project";
    public static final String DELETE_PROJECT_HEADER_WITH_PROJECT_NAME = "Delete project: ";
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private ViewIssueAssertions viewIssueAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestDeleteProject.xml");
    }

    @Test
    public void testPCPDeleteProjectRedirectsToViewProjects() {
        this.tester.gotoPage("secure/project/DeleteProject!default.jspa?pid=10000&pcp=true");
        this.tester.assertTextPresent("If you want to save the project data before you delete it, you can");
        this.tester.assertElementPresent("delete-project-confirm-submit");
        this.tester.submit(DELETE_BUTTON_NAME);
        ProgressPageControl.waitAndReload(this.tester, FORM_NAME, REFRESH_BUTTON_NAME, ACKNOWLEDGE_BUTTON_NAME);
        this.tester.assertElementPresent("browse-projects-page");
        this.tester.assertTextNotPresent("homosapien");
    }

    @Test
    public void testPCPDeleteDeletedProjectAndShowError() {
        this.tester.gotoPage("secure/project/DeleteProject!default.jspa?pid=10000&pcp=true");
        try {
            this.backdoor.project().deleteProject("HSP");
        }
        finally {
            this.tester.submit(DELETE_BUTTON_NAME);
            this.assertions.getJiraFormAssertions().assertFormErrMsg("Project with id '10,000' does not exist. Perhaps it was deleted?");
        }
    }

    @Test
    public void testDeleteProjectNoPermission() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("secure/project/DeleteProject.jspa?pid=10000&confirm=true&returnUrl=ViewProjects.jspa");
        this.tester.assertTextPresent("Welcome to jWebTest JIRA installation");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.assertTextPresent("homosapien");
    }

    @Test
    public void testDeleteProject() {
        this.administration.restoreData("TestDeleteProjectEnterprise.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.assertTextPresent("homosapien");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertTextPresent("Test issue 1");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.assertTextPresent("JIRA needs to be more Web 2.0");
        WorkflowSchemeData draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.clickLink("delete_project_10000");
        this.tester.assertTextPresent(DELETE_PROJECT_HEADER_WITH_PROJECT_NAME);
        this.tester.submit(DELETE_BUTTON_NAME);
        this.tester.assertTextPresent(DELETE_PROJECT_HEADER);
        ProgressPageControl.waitAndReload(this.tester, FORM_NAME, REFRESH_BUTTON_NAME, ACKNOWLEDGE_BUTTON_NAME);
        this.tester.submit();
        this.tester.assertTextNotPresent("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.assertTextPresent("Notification Schemes");
        this.tester.assertTextPresent("The table below shows the notification schemes currently configured for this server");
        this.tester.assertTextNotPresent("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.assertTextPresent("Permission Schemes");
        this.tester.assertTextPresent("Permission Schemes allow you to create a set of permissions and apply this set of permissions to any project.");
        this.tester.assertTextNotPresent("homosapien");
        List customFields = this.backdoor.customFields().getCustomFields(true);
        Assert.assertThat((Object)customFields, (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)((CustomFieldConfig)((CustomFieldResponse)customFields.get(0)).getConfig().get(0)).getProjects(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        this.navigation.issue().viewIssue("HSP-1");
        this.viewIssueAssertions.assertIssueNotFound();
        this.navigation.issue().viewIssue("HSP-2");
        this.viewIssueAssertions.assertIssueNotFound();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.assertTextPresent("Issue Security Schemes allow you to control who can and cannot view issues.");
        this.tester.assertTextNotPresent("homosapien");
        WorkflowSchemeData customerWorflowScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Customer workflow");
        Assert.assertNotNull((Object)customerWorflowScheme);
        Assert.assertFalse((boolean)customerWorflowScheme.isActive());
        WorkflowSchemeData copyOfCustomerWorkflowScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Copy of Customer workflow");
        Assert.assertNotNull((Object)copyOfCustomerWorkflowScheme);
        Assert.assertFalse((boolean)copyOfCustomerWorkflowScheme.isActive());
        Assert.assertEquals((Object)"(This copy was automatically generated from a draft, when workflow scheme 'Customer workflow' was made inactive.)", (Object)copyOfCustomerWorkflowScheme.getDescription());
        Assert.assertEquals((Object)draft.getMappings(), (Object)copyOfCustomerWorkflowScheme.getMappings());
        this.assertNoDraft("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
        this.tester.assertTextPresent("The table below shows the current Field Configuration Schemes and the projects they are associated with.");
        this.tester.assertTextNotPresent("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCREEN_SCHEME);
        this.textAssertions.assertTextPresent(this.locator.css("h2"), "Issue Type Screen Schemes");
        this.tester.assertTextNotPresent("homosapien");
    }

    @Test
    public void testDeleteProjectNotExists() {
        this.navigation.gotoAdmin();
        this.tester.gotoPage("secure/project/DeleteProject.jspa?pid=20000&confirm=true&returnUrl=ViewProjects.jspa&atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent(DELETE_PROJECT_HEADER);
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Project with id '20,000' does not exist. Perhaps it was deleted?");
    }

    @Test
    public void testDeleteProjectWithoutWorkflowSchemeDraft() {
        this.administration.restoreData("TestDeleteProjectEnterprise.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.clickLink("delete_project_10010");
        this.tester.assertTextPresent("Delete project: without draft WF scheme");
        this.tester.submit(DELETE_BUTTON_NAME);
        this.tester.assertTextPresent(DELETE_PROJECT_HEADER);
        ProgressPageControl.waitAndReload(this.tester, FORM_NAME, REFRESH_BUTTON_NAME, ACKNOWLEDGE_BUTTON_NAME);
        this.navigation.gotoAdminSection(Navigation.AdminSection.WORKFLOW_SCHEMES);
        this.tester.assertTextPresent("Workflow Schemes allow you to define which workflows apply to given issue types and projects.");
        this.tester.assertTextNotPresent("without draft WF scheme");
        this.tester.assertTextNotPresent("Copy of ");
        WorkflowSchemeData customerWorflowScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("without draft WF scheme");
        Assert.assertNull((Object)customerWorflowScheme);
        WorkflowSchemeData copyOfCustomerWorkflowScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Copy of without draft WF scheme");
        Assert.assertNull((Object)copyOfCustomerWorkflowScheme);
        this.assertNoDraft("without draft WF scheme");
    }

    @Test
    public void testDeleteProjectWithWorkflowSchemeDraftWithTheSameNameAsExistingWorkflowScheme() {
        this.administration.restoreData("TestDeleteProjectEnterprise.xml");
        this.testDraftCopyRenaming("Copy of Customer workflow", "Customer workflow", "Copy 2 of Customer workflow");
    }

    @Test
    public void testDeleteProjectWithWorkflowSchemeDraftWithTheSameNameAsExistingWorkflowSchemeAbbreviating() {
        this.administration.restoreData("TestDeleteProjectEnterprise.xml");
        String existingSchemeName = "Copy of " + StringUtils.repeat((String)"1", (int)244) + "...";
        String originalSchemeName = StringUtils.repeat((String)"1", (int)255);
        String expectedCopyName = "Copy 2 of " + StringUtils.repeat((String)"1", (int)242) + "...";
        this.backdoor.workflowSchemes().createScheme(new WorkflowSchemeData().setName(originalSchemeName));
        this.administration.project().associateWorkflowScheme("homosapien", originalSchemeName);
        this.administration.project().createWorkflowSchemeDraft("HSP");
        this.testDraftCopyRenaming(existingSchemeName, originalSchemeName, expectedCopyName);
    }

    private void testDraftCopyRenaming(String existingSchemeName, String originalSchemeName, String expectedCopyName) {
        this.backdoor.workflowSchemes().createScheme(new WorkflowSchemeData().setName(existingSchemeName));
        WorkflowSchemeData draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.clickLink("delete_project_10000");
        this.tester.assertTextPresent(DELETE_PROJECT_HEADER_WITH_PROJECT_NAME);
        this.tester.submit(DELETE_BUTTON_NAME);
        this.tester.assertTextPresent(DELETE_PROJECT_HEADER);
        ProgressPageControl.waitAndReload(this.tester, FORM_NAME, REFRESH_BUTTON_NAME, ACKNOWLEDGE_BUTTON_NAME);
        WorkflowSchemeData originalScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound(originalSchemeName);
        Assert.assertNotNull((Object)originalScheme);
        Assert.assertFalse((boolean)originalScheme.isActive());
        WorkflowSchemeData existingScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound(existingSchemeName);
        Assert.assertNotNull((Object)existingScheme);
        Assert.assertFalse((boolean)existingScheme.isActive());
        WorkflowSchemeData copiedScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound(expectedCopyName);
        Assert.assertNotNull((Object)copiedScheme);
        Assert.assertFalse((boolean)copiedScheme.isActive());
        Assert.assertEquals((Object)("(This copy was automatically generated from a draft, when workflow scheme '" + originalSchemeName + "' was made inactive.)"), (Object)copiedScheme.getDescription());
        Assert.assertEquals((Object)draft.getMappings(), (Object)copiedScheme.getMappings());
        this.assertNoDraft("homosapien");
    }

    @Test
    public void testDeleteProjectWithWorkflowSchemeDraftUsedByAnotherProject() {
        this.administration.restoreData("TestDeleteProjectEnterprise.xml");
        this.administration.project().associateWorkflowScheme("monkey", "Customer workflow");
        WorkflowSchemeData draftBeforeDelete = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.clickLink("delete_project_10000");
        this.tester.assertTextPresent("Delete project: homosapien");
        this.tester.submit(DELETE_BUTTON_NAME);
        this.tester.assertTextPresent(DELETE_PROJECT_HEADER);
        ProgressPageControl.waitAndReload(this.tester, FORM_NAME, REFRESH_BUTTON_NAME, ACKNOWLEDGE_BUTTON_NAME);
        WorkflowSchemeData copyOfCustomerWorkflowScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Copy of Customer workflow");
        Assert.assertNull((Object)copyOfCustomerWorkflowScheme);
        WorkflowSchemeData draftAfterDelete = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("monkey");
        Assert.assertNotNull((Object)draftAfterDelete);
        Assert.assertEquals((Object)draftBeforeDelete.getId(), (Object)draftAfterDelete.getId());
        Assert.assertEquals((Object)draftBeforeDelete.getName(), (Object)draftAfterDelete.getName());
        Assert.assertEquals((Object)draftBeforeDelete.getDescription(), (Object)draftAfterDelete.getDescription());
        Assert.assertEquals((Object)draftBeforeDelete.getMappings(), (Object)draftAfterDelete.getMappings());
    }

    private void assertNoDraft(String projectName) {
        WorkflowSchemeData draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound(projectName);
        Assert.assertNull((Object)draft);
    }
}

