/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.PROJECTS, Category.ROLES, Category.SECURITY})
@LoginAs(user="admin")
public class TestMultipleProjectsWithIssueSecurityWithRoles
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestMultipleProjectsWithIssueSecurityWithRoles.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testIssueWithSecurityLevelNotAccessibleInNavigator() {
        this.navigation.logout();
        this.navigation.login("nondeveloper", "nondeveloper");
        this.navigation.issueNavigator().gotoNavigator();
        this.textAssertions.assertTextPresent(this.locator.page(), "Test Issue 1 (TP2)");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Test Issue 2 (TP1)");
        this.textAssertions.assertTextPresent(this.locator.page(), "Test Issue 1 (TP1)");
        this.textAssertions.assertTextPresent(this.locator.page(), "My Bug");
        this.navigation.issue().gotoIssue("TPONE-2");
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.logout();
        this.navigation.login("developer", "developer");
        this.navigation.issueNavigator().gotoNavigator();
        this.textAssertions.assertTextPresent(this.locator.page(), "Test Issue 1 (TP2)");
        this.textAssertions.assertTextPresent(this.locator.page(), "Test Issue 2 (TP1)");
        this.textAssertions.assertTextPresent(this.locator.page(), "Test Issue 1 (TP1)");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "My Bug");
    }
}

