/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestPrioritySchemeAssignment
extends BaseJiraFuncTest {
    private long projectA;
    private long projectB;
    private long schemeId;

    @Before
    public void setup() {
        this.schemeId = this.backdoor.prioritySchemes().createPriorityScheme("test", "", (List<String>)ImmutableList.of((Object)"Minor", (Object)"Major"));
        this.projectA = this.backdoor.project().addProject("Project A", "AA", "admin");
        this.projectB = this.backdoor.project().addProject("Project B", "BB", "admin");
    }

    @Test
    public void testAssignPriorityScheme() {
        this.backdoor.prioritySchemes().assignProject(this.schemeId, this.projectA);
        this.backdoor.prioritySchemes().assignProject(this.schemeId, this.projectB);
        List<Long> list = this.backdoor.prioritySchemes().getProjectWithScheme(this.schemeId);
        Assert.assertThat(list, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.equalTo((Object)this.projectA), Matchers.equalTo((Object)this.projectB)}));
    }

    @Test
    public void testUnassignPriorityScheme() {
        this.backdoor.prioritySchemes().assignProject(this.schemeId, this.projectA);
        this.backdoor.prioritySchemes().assignProject(this.schemeId, this.projectB);
        this.backdoor.prioritySchemes().unassignProject(this.schemeId, this.projectA);
        List<Long> projectsInScheme = this.backdoor.prioritySchemes().getProjectWithScheme(this.schemeId);
        Assert.assertThat(projectsInScheme, (Matcher)Matchers.contains((Object[])new Long[]{this.projectB}));
    }
}

