/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestProjectCategory
extends BaseJiraFuncTest {
    private static final String CATEGORY_NAME = "New Project Category For Testing";
    private static final String CATEGORY_DESCRIPTION = "Testing for project category";
    @Inject
    private FuncTestLogger logger;

    @Test
    public void testAddProjectCategory() {
        this.logger.log((Object)"Project Category: Add project category");
        this.createProjectCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        this.tester.assertTextPresent(CATEGORY_NAME);
    }

    @Test
    public void testDeleteProjectCategory() {
        this.logger.log((Object)"Project Category: Delete project category");
        this.createProjectCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        this.deleteProjectCategory(CATEGORY_NAME);
        this.tester.assertTextNotPresent(CATEGORY_NAME);
    }

    @Test
    public void testPlaceProjectInProjectCategory() {
        this.logger.log((Object)"Project Category: Place a project in a project category");
        String projectKey = "CAT";
        long projectId = this.backdoor.project().addProject("Project with category", "CAT", "admin");
        this.createProjectCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        this.navigation.gotoPage("/secure/project/SelectProjectCategory!default.jspa?pid=" + projectId);
        this.tester.selectOption("projectCategoryId", CATEGORY_NAME);
        this.tester.submit("Select");
        Assert.assertThat((Object)this.backdoor.project().getProjectCategoryName("CAT"), (Matcher)Matchers.equalTo((Object)CATEGORY_NAME));
    }

    @Test
    public void testAddDuplicateCategory() {
        this.logger.log((Object)"Project Category: Attempt to create a project category with a duplicate name");
        this.createProjectCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        this.createProjectCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("The project category 'New Project Category For Testing' already exists");
    }

    @Test
    public void testAddInvalidCategory() {
        this.logger.log((Object)"Project Category: Attempt to create a project category with an invalid name");
        this.createProjectCategory("", "");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("Please specify a name");
    }

    private void createProjectCategory(String categoryName, String categoryDescription) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CATEGORIES);
        this.tester.setFormElement("name", categoryName);
        this.tester.setFormElement("description", categoryDescription);
        this.tester.submit("Add");
    }

    private void deleteProjectCategory(String categoryName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CATEGORIES);
        this.tester.clickLink("del_" + categoryName);
        this.tester.submit("Delete");
    }
}

