/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.parser.SystemInfoParser;
import com.atlassian.jira.functest.framework.rule.IssueTypeUrls;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.table.AndCell;
import com.atlassian.jira.webtests.table.ImageCell;
import com.atlassian.jira.webtests.table.LinkCell;
import com.atlassian.jira.webtests.table.TextCell;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.COMPONENTS_AND_VERSIONS, Category.PROJECTS})
@LoginAs(user="admin")
public class TestProjectComponentQuickSearch
extends BaseJiraFuncTest {
    @Rule
    public IssueTypeUrls issueTypeUrls = new IssueTypeUrls();
    String appServer;
    private String bugIcon;
    private String taskIcon;
    private String improvementIcon;
    private String newFeatureIcon;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private SystemInfoParser systemInfoParser;

    @Before
    public void setUp() {
        this.administration.restoreData("TestProjectComponentQuickSearch.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.appServer = this.systemInfoParser.getSystemInfo().getAppServer();
        this.bugIcon = this.issueTypeUrls.getIssueTypeUrl("bug");
        this.taskIcon = this.issueTypeUrls.getIssueTypeUrl("task");
        this.improvementIcon = this.issueTypeUrls.getIssueTypeUrl("improvement");
        this.newFeatureIcon = this.issueTypeUrls.getIssueTypeUrl("new feature");
    }

    @Test
    public void testProjectComponentQuickSearchMultipleProjects() throws Exception {
        WebTable issueTable = this.assertComponentQuickSearch("", 5);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasMKY_35(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        this.assertIssueTableHasHSP_45(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced("c:one", 1);
        this.assertIssueTableHasHSP_12345(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced(" c:two ", 2);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced("three c:three", 3);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasMKY_35(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced("c:four four", 4);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        this.assertIssueTableHasHSP_45(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced("five c:five five", 5);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasMKY_35(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        this.assertIssueTableHasHSP_45(issueTable);
    }

    @Test
    public void testProjectComponentQuickSearchHomosapienProject() throws Exception {
        WebTable issueTable = this.assertComponentQuickSearch("hsp c:one", 1);
        this.assertIssueTableHasHSP_12345(issueTable);
        issueTable = this.assertComponentQuickSearch(" c:two homosapien ", 2);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        issueTable = this.assertComponentQuickSearch("three HSP c:three", 2);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        issueTable = this.assertComponentQuickSearch("c:four four HOMOSAPIEN", 3);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasHSP_45(issueTable);
        issueTable = this.assertComponentQuickSearch("hsp five c:five five", 3);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasHSP_45(issueTable);
    }

    @Test
    public void testProjectComponentQuickSearchMonkey() throws Exception {
        WebTable issueTable = this.assertComponentQuickSearch("c:one MONKEY", 2);
        this.assertIssueTableHasMKY_35(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        issueTable = this.assertComponentQuickSearch(" MKY c:two ", 2);
        this.assertIssueTableHasMKY_35(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        issueTable = this.assertComponentQuickSearch("monkey three c:three", 1);
        this.assertIssueTableHasMKY_35(issueTable);
        issueTable = this.assertComponentQuickSearch("c:four mky four", 1);
        this.assertIssueTableHasMKY_45(issueTable);
        issueTable = this.assertComponentQuickSearch("five c:five five monkey", 2);
        this.assertIssueTableHasMKY_35(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
    }

    private WebTable assertComponentQuickSearch(String searchInput, int numOfResults) throws SAXException {
        this.runQuickSearch(searchInput);
        this.assertions.getIssueNavigatorAssertions().assertIssueNavigatorDisplaying(this.locator.page(), "1", String.valueOf(numOfResults), String.valueOf(numOfResults));
        WebTable issueTable = this.tester.getDialog().getResponse().getTableWithID("issuetable");
        Assert.assertEquals((long)(numOfResults + 1), (long)issueTable.getRowCount());
        this.assertions.getTableAssertions().assertTableRowEquals(issueTable, 0, new Object[]{"T", "Key", "Summary", "Assignee", "Reporter", "P", "Status", "Resolution", "Created", "Updated", "Due"});
        return issueTable;
    }

    private WebTable assertComponentQuickSearchOnAdvanced(String searchInput, int numOfResults) throws SAXException {
        this.runQuickSearch(searchInput);
        this.assertAdvacnedIssueNavigatorDisplaying("1", String.valueOf(numOfResults), String.valueOf(numOfResults));
        WebTable issueTable = this.tester.getDialog().getResponse().getTableWithID("issuetable");
        Assert.assertEquals((long)(numOfResults + 1), (long)issueTable.getRowCount());
        this.assertions.getTableAssertions().assertTableRowEquals(issueTable, 0, new Object[]{"T", "Key", "Summary", "Assignee", "Reporter", "P", "Status", "Resolution", "Created", "Updated", "Due"});
        return issueTable;
    }

    private void assertAdvacnedIssueNavigatorDisplaying(String from, String to, String of) {
        this.tester.assertTextPresent("<span class=\"results-count-start\">" + from + "</span>&ndash;<span class=\"results-count-end\">" + to + "</span> of <span class=\"results-count-total results-count-link\">" + of + "</span>");
    }

    private void assertIssueTableHasHSP_45(WebTable issueTable) {
        this.assertions.getTableAssertions().assertTableContainsRowOnce(issueTable, new Object[]{new AndCell(new LinkCell("/browse/HSP-1", ""), new ImageCell(this.bugIcon)), new LinkCell("/browse/HSP-1", "HSP-1"), "homo four five", "Administrator", "Administrator", new ImageCell("/images/icons/priorities/major.svg"), new TextCell("Open"), "Unresolved", "23/Nov/07", "23/Nov/07", ""});
    }

    private void assertIssueTableHasHSP_12345(WebTable issueTable) {
        this.assertions.getTableAssertions().assertTableContainsRowOnce(issueTable, new Object[]{new AndCell(new LinkCell("/browse/HSP-2", ""), new ImageCell(this.taskIcon)), new LinkCell("/browse/HSP-2", "HSP-2"), "one two homo three four five", "Administrator", "Administrator", new ImageCell("/images/icons/priorities/major.svg"), new TextCell("Open"), "Unresolved", "23/Nov/07", "23/Nov/07", ""});
    }

    private void assertIssueTableHasHSP_2345(WebTable issueTable) {
        this.assertions.getTableAssertions().assertTableContainsRowOnce(issueTable, new Object[]{new AndCell(new LinkCell("/browse/HSP-3", ""), new ImageCell(this.improvementIcon)), new LinkCell("/browse/HSP-3", "HSP-3"), "two three homo four five", "Administrator", "Administrator", new ImageCell("/images/icons/priorities/major.svg"), new TextCell("Open"), "Unresolved", "23/Nov/07", "23/Nov/07", ""});
    }

    private void assertIssueTableHasMKY_35(WebTable issueTable) {
        this.assertions.getTableAssertions().assertTableContainsRowOnce(issueTable, new Object[]{new AndCell(new LinkCell("/browse/MKY-2", ""), new ImageCell(this.newFeatureIcon)), new LinkCell("/browse/MKY-2", "MKY-2"), "three monk five", "Administrator", "Administrator", new ImageCell("/images/icons/priorities/major.svg"), new TextCell("Open"), "Unresolved", "23/Nov/07", "23/Nov/07", ""});
    }

    private void assertIssueTableHasMKY_45(WebTable issueTable) {
        this.assertions.getTableAssertions().assertTableContainsRowOnce(issueTable, new Object[]{new AndCell(new LinkCell("/browse/MKY-1", ""), new ImageCell(this.bugIcon)), new LinkCell("/browse/MKY-1", "MKY-1"), "monk five four", "Administrator", "Administrator", new ImageCell("/images/icons/priorities/major.svg"), new TextCell("Open"), "Unresolved", "23/Nov/07", "23/Nov/07", ""});
    }

    private void runQuickSearch(String searchInput) {
        this.navigation.gotoDashboard();
        this.tester.setWorkingForm("quicksearch");
        this.tester.setFormElement("searchString", searchInput);
        this.tester.submit();
    }
}

