/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.PermissionSchemesMatcher;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.testkit.beans.PermissionSchemeBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleClient;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS, Category.ROLES})
@LoginAs(user="admin")
public class TestProjectRoles
extends BaseJiraFuncTest {
    private static final Long ROLE_ID = 10000L;
    private static final Long PROJECT_ID = 10000L;
    private static final String ROLE_DESC = "this is a test role";
    private static final String ROLE_NAME = "test role";
    private static final String ROLE_NAME_UPPER_CASE = "Test role";
    private static final String ROLE_UPDATED_NAME = "testing role";
    private static final String ROLE_UPDATED_DESC = "this is an updated description";
    private static final String EDIT_USER_ACTORS = "edit_10000_atlassian-user-role-actor";
    private static final String EDIT_GROUP_ACTORS = "edit_10000_atlassian-group-role-actor";
    private static final String DELETE_ROLE = "delete_test role";
    private static final Long OTHER_PERMISSION_SCHEME_ID = 10000L;
    @Inject
    protected HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    @RestoreBlankInstance
    public void testProjectRoleOperations() {
        this.administration.roles().create(ROLE_NAME, ROLE_DESC);
        this.editProjectRole(ROLE_UPDATED_NAME);
        this.editProjectRole(ROLE_NAME_UPPER_CASE);
        this.ensureErrorForDuplicateRoleName();
        this.administration.roles().delete(ROLE_NAME);
        this.textAssertions.assertTextNotPresent(this.locator.id("project-role-test role"), ROLE_NAME);
        this.textAssertions.assertTextNotPresent(this.locator.id("project-role-test role"), ROLE_DESC);
    }

    public ParsedResponse addGroupToProjectRole(String groupName, String projectKey, String roleName) {
        ProjectRoleClient projectRoleClient = new ProjectRoleClient((JIRAEnvironmentData)this.environmentData);
        return projectRoleClient.addActors(projectKey, roleName, new String[]{groupName}, null);
    }

    public ParsedResponse addUserToProjectRole(String userName, String projectKey, String roleName) {
        ProjectRoleClient projectRoleClient = new ProjectRoleClient((JIRAEnvironmentData)this.environmentData);
        return projectRoleClient.addActors(projectKey, roleName, null, new String[]{userName});
    }

    @Test
    @Restore(value="TestProjectRoles.xml")
    public void testCreateIssueWithRolePermissions() {
        this.navigation.gotoDashboard();
        this.tester.assertLinkNotPresent("create_link");
        this.addUserToProjectRole("admin", "HSP", ROLE_NAME);
        this.navigation.gotoDashboard();
        this.tester.assertLinkPresent("create_link");
        this.tester.clickLink("create_link");
        this.assertions.getProjectFieldsAssertions().assertProjectsEquals(new String[]{"homosapien"});
        this.addUserToProjectRole("admin", "MKY", ROLE_NAME);
        this.tester.assertLinkPresent("create_link");
        this.tester.clickLink("create_link");
        this.assertions.getProjectFieldsAssertions().assertProjectsEquals(new String[]{"homosapien", "monkey"});
    }

    @Test
    @Restore(value="TestProjectRoles.xml")
    public void testCreateIssueWithRolePermissionsForGroup() {
        this.navigation.gotoDashboard();
        this.tester.assertLinkNotPresent("create_link");
        this.addGroupToProjectRole("jira-administrators", "HSP", ROLE_NAME);
        this.navigation.gotoDashboard();
        this.tester.assertLinkPresent("create_link");
        this.tester.clickLink("create_link");
        this.assertions.getProjectFieldsAssertions().assertProjectsEquals(new String[]{"homosapien"});
        this.addGroupToProjectRole("jira-administrators", "MKY", ROLE_NAME);
        this.navigation.gotoDashboard();
        this.tester.assertLinkPresent("create_link");
        this.tester.clickLink("create_link");
        this.assertions.getProjectFieldsAssertions().assertProjectsEquals(new String[]{"homosapien", "monkey"});
    }

    @Test
    @Restore(value="TestProjectRoles.xml")
    public void testAddDefaultUsersAndDefaultGroupsToRole() {
        this.addAdministratorToDefaultRole();
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("manage_test role");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.setFormElement("userNames", "detkin");
        this.tester.submit("add");
        this.textAssertions.assertTextSequence(this.locator.css(".jiraform .aui-message.aui-message-error"), "detkin", "could not be found");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("manage_test role");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.setFormElement("userNames", "admin");
        this.tester.submit("add");
        this.textAssertions.assertTextSequence(this.locator.css(".jiraform .aui-message.aui-message-error"), "admin", "already a member");
        this.addGroupsToDefaultRole();
        this.deleteDefaultUsersForRole();
        this.deleteDefaultGroupsForRole();
    }

    @Test
    @Restore(value="TestProjectRoles.xml")
    public void testDeleteProjectRoleRemovesSchemeEntries() {
        PermissionSchemeBean permissionScheme = this.backdoor.permissionSchemes().getAssignedPermissions(0L);
        Assert.assertTrue((String)"Should have on test_role in permission scheme", (boolean)PermissionSchemesMatcher.hasPermissionCount(JiraPermissionHolderType.PROJECT_ROLE.getKey(), String.valueOf(ROLE_ID), 1).matches((Object)permissionScheme));
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.deleteProjectRole(true);
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLinkWithText("Notifications");
        this.tester.assertTextNotPresent(ROLE_NAME);
        permissionScheme = this.backdoor.permissionSchemes().getAssignedPermissions(0L);
        Assert.assertTrue((String)"Should not have the test_role in the permisison scheme", (boolean)PermissionSchemesMatcher.hasPermissionCount(JiraPermissionHolderType.PROJECT_ROLE.getKey(), String.valueOf(ROLE_ID), 0).matches((Object)permissionScheme));
        this.administration.issueSecuritySchemes().getScheme("Default Issue Security Scheme");
        this.tester.assertTextNotPresent(ROLE_NAME);
    }

    @Test
    @Restore(value="TestProjectRoles.xml")
    public void testDeleteProjectRoleWorkflowConditions() {
        this.administration.workflows().goTo().workflowSteps("Copy of jira workflow");
        this.tester.clickLinkWithText("Start Progress");
        this.tester.assertTextPresent("Only users in project role <b>test role</b> can execute this transition.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.setFormElement("name", "");
        this.tester.clickLink(DELETE_ROLE);
        this.tester.assertTextPresent("The following <strong>1</strong> workflow actions contain conditions that rely on the project role <strong>test role</strong>. If you delete this project role, these conditions will always fail.");
        this.tester.submit("Delete");
        this.administration.workflows().goTo().workflowSteps("Copy of jira workflow");
        this.tester.clickLinkWithText("Start Progress");
        this.tester.assertTextPresent("Project Role (id=10000) is missing, now this condition will always fail.");
        this.tester.gotoPage("/secure/admin/workflows/EditWorkflowTransitionConditionParams!default.jspa?workflowStep=1&workflowTransition=4&count=2&workflowName=Copy+of+jira+workflow&workflowMode=live");
        this.tester.selectOption("jira.projectrole.id", "Users");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Only users in project role <b>Users</b> can execute this transition.");
    }

    @Test
    @Restore(value="TestProjectRoleViewUsages.xml")
    public void testProjectRoleBrowserForNotLoggedInUser() {
        this.navigation.logout();
        try {
            this.tester.gotoPage("/secure/project/UserRoleActorAction.jspa?projectRoleId=" + ROLE_ID + "&projectId=" + PROJECT_ID);
            this.tester.assertTextPresent("You must log in to access this page.");
            this.tester.gotoPage(this.page.addXsrfToken("/secure/project/UserRoleActorAction!AddUsers.jspa?projectRoleId=" + ROLE_ID + "&projectId=" + PROJECT_ID));
            this.tester.assertTextPresent("You must log in to access this page.");
            this.tester.gotoPage(this.page.addXsrfToken("/secure/project/UserRoleActorAction!RemoveUsers.jspa?projectRoleId=" + ROLE_ID + "&projectId=" + PROJECT_ID));
            this.tester.assertTextPresent("You must log in to access this page.");
            this.tester.gotoPage("/secure/project/GroupRoleActorAction.jspa?projectRoleId=" + ROLE_ID + "&projectId=" + PROJECT_ID);
            this.tester.assertTextPresent("You must log in to access this page.");
            this.tester.gotoPage(this.page.addXsrfToken("/secure/project/GroupRoleActorAction!AddGroups.jspa?projectRoleId=" + ROLE_ID + "projectId=" + PROJECT_ID));
            this.tester.assertTextPresent("You must log in to access this page.");
            this.tester.gotoPage(this.page.addXsrfToken("/secure/project/GroupRoleActorAction!RemoveGroups.jspa?projectRoleId=" + ROLE_ID + "projectId=" + PROJECT_ID));
            this.tester.assertTextPresent("You must log in to access this page.");
        }
        finally {
            this.navigation.login("admin");
        }
    }

    @Test
    @Restore(value="TestProjectRoleViewUsages.xml")
    public void testViewUsages() {
        this.backdoor.darkFeatures().enableForSite("jira.project.config.old.roles.screen");
        this.gotoViewUsagesForUsersProjectRole();
        this.assertions.getLinkAssertions().assertLinkPresentWithExactTextById("relatednotificationschemes", "Default Notification Scheme");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactTextById("relatednotificationschemes", "Other Notification Scheme");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactTextById("relatedpermissionschemes", "Default Permission Scheme");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactTextById("relatedpermissionschemes", "Other Permission Scheme");
        this.textAssertions.assertTextSequence(this.locator.table("relatedpermissionschemes"), new String[]{"Default Permission Scheme", "homosapien", "3 (View)", "monkey", "2 (View)", "test", "1 (View)", "Other Permission Scheme", "None", "None"});
        this.tester.assertLinkPresentWithText("test issue security scheme");
        this.tester.assertLinkPresentWithText("jira workflow");
        this.tester.assertLinkPresentWithText("Start Progress");
        this.tester.assertLinkPresentWithText("Stop Progress");
        this.tester.clickLinkWithText("Default Notification Scheme");
        this.tester.assertTextPresent("Edit Notifications &mdash; Default Notification Scheme");
        this.tester.assertLinkPresentWithText("Add notification");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("Other Notification Scheme");
        this.tester.assertTextPresent("Edit Notifications &mdash; Other Notification Scheme");
        this.tester.assertLinkPresentWithText("Add notification");
        this.gotoViewUsagesForUsersProjectRole();
        Assert.assertEquals((Object)this.getEditPermissionsUrl(0L), (Object)this.page.getLinksWithExactText("Default Permission Scheme")[0].getURLString());
        Assert.assertEquals((Object)this.getEditPermissionsUrl(OTHER_PERMISSION_SCHEME_ID), (Object)this.page.getLinksWithExactText("Other Permission Scheme")[0].getURLString());
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("test issue security scheme");
        this.tester.assertTextPresent("Edit Issue Security Levels");
        this.tester.assertTextPresent("test security level");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("Start Progress");
        this.tester.assertTextPresent("Transition: Start Progress");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("Stop Progress");
        this.tester.assertTextPresent("Transition: Stop Progress");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("homosapien");
        this.assertions.getSidebarAssertions().assertProjectName("homosapien");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLink("view_project_role_actors_10000");
        this.tester.assertElementPresent("project-config-panel-people");
    }

    private void gotoViewUsagesForUsersProjectRole() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("view_Users");
    }

    private void addGroupsToDefaultRole() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("manage_test role");
        this.tester.assertTextPresent("None selected");
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.assertTextPresent("Add Default Groups to Project Role: test role");
        this.tester.setFormElement("groupNames", "jira-users, jira-developers, jira-administrators");
        this.tester.submit("add");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("jira-administrators");
        this.tester.assertTextPresent("jira-users");
        this.tester.assertTextPresent("jira-developers");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("Project Role Browser");
    }

    private void addAdministratorToDefaultRole() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("manage_test role");
        this.tester.assertTextPresent("None selected.");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.assertTextPresent("Add Default Users to Project Role: test role");
        this.tester.setFormElement("userNames", "admin, fred");
        this.tester.submit("add");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("Administrator");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("Project Role Browser");
    }

    private void deleteDefaultUsersForRole() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("manage_test role");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.assertTextPresent("Add Default Users to Project Role: test role");
        this.tester.checkCheckbox("removeusers_admin", ".");
        this.tester.checkCheckbox("removeusers_fred", ".");
        this.tester.submit("remove");
        this.tester.assertTextPresent("There are currently no users added to this project role.");
    }

    private void deleteDefaultGroupsForRole() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("manage_test role");
        this.deleteGroupsFromRoleForm("Add Default Groups to Project Role: test role");
    }

    private void deleteGroupsFromRoleForm(String textPresent) {
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.assertTextPresent(textPresent);
        this.tester.checkCheckbox("removegroups_jira-users", ".");
        this.tester.checkCheckbox("removegroups_jira-developers", ".");
        this.tester.checkCheckbox("removegroups_jira-administrators", ".");
        this.tester.submit("remove");
        this.tester.assertTextPresent("There are currently no groups added to this project role");
    }

    private void deleteProjectRole(boolean checkAssociatedSchemes) {
        this.tester.clickLink(DELETE_ROLE);
        this.tester.assertTextPresent("Are you sure you would like to delete project role");
        this.tester.assertTextPresent(ROLE_NAME);
        if (checkAssociatedSchemes) {
            this.tester.assertLinkPresentWithText("Default Notification Scheme");
            this.tester.assertLinkPresentWithText("Default Permission Scheme");
            this.tester.assertLinkPresentWithText("Default Issue Security Scheme");
            this.tester.assertTextPresent("Copy of jira workflow");
            this.tester.assertLinkPresentWithText("Start Progress");
        }
        this.tester.submit("Delete");
        this.textAssertions.assertTextNotPresent(this.locator.id("project-role-test role"), ROLE_NAME);
        this.textAssertions.assertTextNotPresent(this.locator.id("project-role-test role"), ROLE_DESC);
    }

    private void ensureErrorForDuplicateRoleName() {
        this.tester.setFormElement("name", ROLE_NAME);
        this.tester.setFormElement("description", "");
        this.tester.submit("Add Project Role");
        this.tester.assertTextPresent("A project role with name &#39;test role&#39; already exists.");
    }

    private void editProjectRole(String newRoleName) {
        this.administration.roles().edit(ROLE_NAME).setName(newRoleName);
        this.administration.roles().edit(newRoleName).setDescription(ROLE_UPDATED_DESC);
        this.tester.assertTextPresent(newRoleName);
        this.tester.assertTextPresent(ROLE_UPDATED_DESC);
        this.administration.roles().edit(newRoleName).setName(ROLE_NAME);
        this.administration.roles().edit(ROLE_NAME).setDescription(ROLE_DESC);
    }

    private String getEditPermissionsUrl(Long schemeId) {
        return this.getEnvironmentData().getContext() + "/secure/admin/EditPermissions!default.jspa?schemeId=" + Long.toString(schemeId);
    }
}

