/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.security;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.PermissionSchemesControl;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.testkit.client.restclient.WatchersClient;
import com.atlassian.jira.webtests.ztests.project.security.DataTestProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.math.Quantiles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.WebApplicationException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class TestOptimisedUserSearch
extends BaseJiraFuncTest {
    private static final String GROUP_EXCLUSIVE_YYY = "exclusive-group-yyy";
    private static final String GROUP_EXCLUSIVE_YYYU = "exclusive-group-yyyu";
    private static final String GROUP_FOR_TEXT_SEARCH_WITH_SEP_USERS = "group-for-text-search";
    private static final String PYRAMID_MASTER_GROUP = "pyramid_group_level_0_no_0_members_3";
    private static final int TOTAL_USER_COUNT_IN_PYRAMID_GROUP = 50;
    private static final String FLAT_MASTER_GROUP = "flat_master";
    private static final String BIG_GROUP_PREFIX = "big_group_";
    private static final int NUMBER_OF_BIG_GROUPS = 20;
    private static final String USER_YEVGENI = TestOptimisedUserSearch.ldapUser("yyyevgeni");
    private static final String USER_YURI = TestOptimisedUserSearch.ldapUser("yyyuri");
    private static final String USER_YUSTYN = TestOptimisedUserSearch.ldapUser("yyyustyn");
    protected static final String USER_ALICE = TestOptimisedUserSearch.ldapUser("alice");
    protected static final String USER_BOB = TestOptimisedUserSearch.ldapUser("bob");
    private static final String USER_SEPTIMUS = TestOptimisedUserSearch.ldapUser("septimus");
    private static final String USER_SEPTEMBER = TestOptimisedUserSearch.ldapUser("september");
    private static final String USER_SEPHIRA = TestOptimisedUserSearch.ldapUser("sephira");
    private static final String USER_SEPP = TestOptimisedUserSearch.ldapUser("sepp");
    private static final String INTERNAL_GROUP = "internal_group";
    protected static final String USER_ALBERT = TestOptimisedUserSearch.internalUser("albert");
    protected static final String USER_ANNA = TestOptimisedUserSearch.internalUser("Anna");
    private static final String USER_ZACHARY = TestOptimisedUserSearch.internalUser("zachary");
    private static final String USER_ZUZANNA = TestOptimisedUserSearch.internalUser("Zuzanna");
    private static final String USER_ELON_ACTIVE = TestOptimisedUserSearch.internalUser("elon_active");
    private static final String USER_ELON_ANONYMIZED = TestOptimisedUserSearch.internalUser("elon_anonymized");
    private static final String USER_ELON_INACTIVE = TestOptimisedUserSearch.internalUser("elon_inactive");
    private static final String USER_STEVE_EXISTING = TestOptimisedUserSearch.internalUser("steve_existing");
    private static final String USER_STEVE_DELETED = TestOptimisedUserSearch.internalUser("steve_deleted");
    private static final String USER_NATASHA_IN_GROUP = TestOptimisedUserSearch.internalUser("natasha_in_group");
    private static final String USER_NATASHA_ALONE = TestOptimisedUserSearch.internalUser("natasha_alone");
    private static final String USER_FOREVER_ALONE = TestOptimisedUserSearch.internalUser("falone");
    private static final List<String> INTERNAL_USERS = ImmutableList.of((Object)USER_ALBERT, (Object)USER_ANNA, (Object)USER_ZACHARY, (Object)USER_ZUZANNA, (Object)USER_ELON_ACTIVE, (Object)USER_ELON_ANONYMIZED, (Object)USER_ELON_INACTIVE, (Object)USER_STEVE_EXISTING, (Object)USER_STEVE_DELETED, (Object)USER_NATASHA_IN_GROUP, (Object)USER_NATASHA_ALONE);
    private static final String EXPLICIT_USER_PREFIX = "explicit_user_";
    private static final String LDAP_USER_SUFFIX = "_ldap_user";
    private static final int NUMBER_OF_EXPLICIT_USERS = 5000;
    protected static final String PROJECT_KEY = "HSP";
    protected static final long PROJECT_ID = 10000L;
    private static final long ACCEPTABLE_SEARCH_WAIT_MS_FUNCTIONAL_TESTS = 400L;
    private static final long ACCEPTABLE_SEARCH_WAIT_MS_LOAD_TESTS = 1000L;
    private static final long ACCEPTABLE_SEARCH_WAIT_MS_COLD_CACHE = 10000L;
    private static final int NUMBER_OF_ATTEMPTS = Integer.getInteger("test.optimised.user.search.attempts.number", 11);
    protected PermissionSchemesControl permissionSchemesControl;
    protected WatchersClient watchersClient;
    protected UserAnonymizeControl userAnonymizeControl;
    protected String issueKey;
    protected Long permissionSchemeId;
    protected int maxResults;
    protected static final String MULTI_SELECT_CUSTOM_FIELD = "multiSelectCustomField";
    private String groupPickerCustomFieldId;
    private String multiGroupPickerCustomFieldId;
    private String selectCustomFieldId;
    protected String multiSelectCustomFieldId;
    private String userPickerCustomFieldId;
    protected String multiUserPickerCustomFieldId;
    private static final Map<String, List<Long>> testResults = new LinkedHashMap<String, List<Long>>();
    protected static final FuncTestLogger logger = new FuncTestLoggerImpl(2);
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() {
        this.maxResults = 60;
        this.permissionSchemesControl = this.backdoor.permissionSchemes();
        this.watchersClient = new WatchersClient((JIRAEnvironmentData)this.environmentData);
        this.userAnonymizeControl = new UserAnonymizeControl(this.environmentData);
        this.backdoor.usersAndGroups().addUserToGroup("admin", "jira-users");
        this.prepareCustomFields();
        this.createPermissionScheme();
        this.createIssue();
        this.addInternalDirectoryUsers();
        this.addInternalGroups();
    }

    @After
    public void tearDown() {
        this.runSafely(this::removeInternalDirectoryUsers);
        this.runSafely(this::cleanUpIssue);
        this.runSafely(this::removePermissionScheme);
        this.runSafely(this::removeInternalGroups);
    }

    @AfterClass
    public static void printResults() {
        logger.log((Object)"name, average, min, max, median, measures");
        testResults.forEach((k, v) -> logger.log((Object)(String.format("%s,%d,%d,%d,%d,", k, TestOptimisedUserSearch.getAverage(v), TestOptimisedUserSearch.getMin(v), TestOptimisedUserSearch.getMax(v), TestOptimisedUserSearch.getMedian(v)) + v)));
    }

    private void runSafely(Runnable r) {
        try {
            r.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareCustomFields() {
        this.groupPickerCustomFieldId = this.addCustomField("grouppicker", "grouppickersearcher");
        this.multiGroupPickerCustomFieldId = this.addCustomField("multigrouppicker", "grouppickersearcher");
        this.selectCustomFieldId = this.addCustomField("select", "multiselectsearcher");
        this.multiSelectCustomFieldId = this.addCustomField("multiselect", "multiselectsearcher");
        this.userPickerCustomFieldId = this.addCustomField("userpicker", "userpickergroupsearcher");
        this.multiUserPickerCustomFieldId = this.addCustomField("multiuserpicker", "userpickergroupsearcher");
    }

    private void createPermissionScheme() {
        this.permissionSchemeId = this.permissionSchemesControl.createScheme("MentionTestScheme" + System.currentTimeMillis() / 1000L, "Created by " + this.getClass().getSimpleName());
        Stream.of(10000L, 10001L).forEach(project -> this.backdoor.project().setPermissionScheme((long)project, this.permissionSchemeId));
        Stream.of(ProjectPermissions.BROWSE_PROJECTS, ProjectPermissions.CREATE_ISSUES, ProjectPermissions.EDIT_ISSUES, ProjectPermissions.DELETE_ISSUES, ProjectPermissions.ASSIGN_ISSUES, ProjectPermissions.ASSIGNABLE_USER, ProjectPermissions.MODIFY_REPORTER, ProjectPermissions.MANAGE_WATCHERS).forEach(permission -> this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), permission, "admin"));
    }

    private void createIssue() {
        IssueCreateResponse issueCreateResponse = this.backdoor.issues().createIssue(PROJECT_KEY, "test", "admin");
        this.issueKey = issueCreateResponse.key();
    }

    private void addInternalDirectoryUsers() {
        INTERNAL_USERS.forEach(username -> {
            this.backdoor.usersAndGroups().addUser(username);
            this.backdoor.usersAndGroups().addUserToGroup(username, "jira-users");
        });
        this.backdoor.usersAndGroups().addUser(USER_FOREVER_ALONE);
    }

    private void removeInternalDirectoryUsers() {
        INTERNAL_USERS.forEach(username -> this.backdoor.usersAndGroups().deleteUser(username));
        this.backdoor.usersAndGroups().deleteUser(USER_FOREVER_ALONE);
    }

    private void addInternalGroups() {
        this.backdoor.usersAndGroups().addGroup(INTERNAL_GROUP);
    }

    private void removeInternalGroups() {
        this.backdoor.usersAndGroups().deleteGroup(INTERNAL_GROUP);
    }

    private void cleanUpIssue() {
        this.backdoor.issues().deleteIssue(this.issueKey, false);
    }

    private void removePermissionScheme() {
        Stream.of(10000L, 10001L).forEach(project -> this.backdoor.project().setPermissionScheme((long)project, 0L));
        this.permissionSchemesControl.deleteScheme(this.permissionSchemeId.longValue());
    }

    protected abstract boolean issueAlreadyExists();

    protected abstract UserSearchResults getUserSearchResults();

    protected abstract UserSearchResults getUserSearchResults(String var1);

    protected abstract ProjectPermissionKey getPermission();

    @Test
    public void testSearchPerformanceWithUsers() {
        Stream.of(USER_YEVGENI, USER_YURI, USER_YUSTYN, USER_ALBERT, USER_ZACHARY).forEach(username -> this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), username));
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_YEVGENI, USER_YURI, USER_YUSTYN, USER_ZACHARY}));
    }

    @Test
    public void testSearchPerformanceWithGroup() {
        this.addAlbertAndZacharyToGroupExclusiveYyy();
        this.permissionSchemesControl.addGroupPermission(this.permissionSchemeId, this.getPermission(), GROUP_EXCLUSIVE_YYY);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_YEVGENI, USER_YURI, USER_YUSTYN, USER_ZACHARY}));
    }

    @Test
    public void testSearchPerformanceWithFiveExplicitUsersAndEveryone() {
        Stream.of(USER_YEVGENI, USER_YURI, USER_YUSTYN, USER_ALBERT, USER_ZACHARY).forEach(username -> this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), username));
        this.permissionSchemesControl.addEveryonePermission(this.permissionSchemeId, this.getPermission());
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.hasSize((int)this.maxResults));
    }

    @Test
    public void testSearchPerformanceWithApplicationRole() {
        String applicationRole = this.backdoor.applicationRoles().getSoftware().getKey();
        this.permissionSchemesControl.addApplicationRolePermission(this.permissionSchemeId.longValue(), this.getPermission(), applicationRole);
        this.addAlbertAndZacharyToGroupExclusiveYyy();
        try {
            this.backdoor.applicationRoles().putRole(applicationRole, GROUP_EXCLUSIVE_YYY, "jira-administrators");
            this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_YEVGENI, USER_YURI, USER_YUSTYN, USER_ZACHARY}));
        }
        catch (Throwable throwable) {
            this.backdoor.applicationRoles().putRole(applicationRole, "jira-users");
            throw throwable;
        }
        this.backdoor.applicationRoles().putRole(applicationRole, "jira-users");
    }

    @Test
    public void testSearchPerformanceWithProjectRoleUsers() {
        this.permissionSchemesControl.addProjectRolePermission(this.permissionSchemeId.longValue(), this.getPermission(), 10001L);
        this.backdoor.projectRole().setActors(PROJECT_KEY, "Developers", (Map)ImmutableMap.builder().put((Object)"atlassian-user-role-actor", (Object)new String[]{USER_YEVGENI, USER_YURI, USER_YUSTYN, USER_ALBERT, USER_ZACHARY}).build());
        this.backdoor.projectRole().setActors("MKY", "Developers", (Map)ImmutableMap.builder().put((Object)"atlassian-user-role-actor", (Object)new String[]{USER_ALICE}).build());
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_YEVGENI, USER_YURI, USER_YUSTYN, USER_ZACHARY}));
    }

    @Test
    public void testSearchPerformanceWithProjectRoleGroup() {
        this.addAlbertAndZacharyToGroupExclusiveYyy();
        this.permissionSchemesControl.addProjectRolePermission(this.permissionSchemeId.longValue(), this.getPermission(), 10001L);
        this.backdoor.projectRole().setActors(PROJECT_KEY, "Developers", (Map)ImmutableMap.builder().put((Object)"atlassian-group-role-actor", (Object)new String[]{GROUP_EXCLUSIVE_YYY}).build());
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_YEVGENI, USER_YURI, USER_YUSTYN, USER_ZACHARY}));
    }

    @Test
    public void testSearchPerformanceWithProjectLeadUser() {
        this.permissionSchemesControl.addProjectLeadPermission(this.permissionSchemeId.longValue(), this.getPermission());
        this.backdoor.project().setProjectLead(10000L, USER_YEVGENI);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_YEVGENI}));
        this.backdoor.project().setProjectLead(10000L, "admin");
    }

    @Test
    public void testSearchPerformanceWithProjectLeadUserButNoPermissions() {
        this.backdoor.project().setProjectLead(10000L, USER_YEVGENI);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin"}));
        this.backdoor.project().setProjectLead(10000L, "admin");
    }

    @Test
    public void testSearchPerformanceWithGroupPickerCustomField() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        this.backdoor.issues().setIssueFields(this.issueKey, new IssueFields().customField(this.getCfIdAsLong(this.groupPickerCustomFieldId), (Object)ImmutableMap.of((Object)"name", (Object)GROUP_EXCLUSIVE_YYYU)));
        this.permissionSchemesControl.addGroupCustomFieldPermission(this.permissionSchemeId, this.getPermission(), this.groupPickerCustomFieldId);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_YURI, USER_YUSTYN}));
        this.removeCustomFieldValue(this.groupPickerCustomFieldId);
    }

    @Test
    public void testSearchPerformanceWithMultiGroupPickerCustomFieldId() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        this.addAlbertAndZacharyToGroupExclusiveYyy();
        Map[] groups = new Map[]{ImmutableMap.of((Object)"name", (Object)GROUP_EXCLUSIVE_YYY), ImmutableMap.of((Object)"name", (Object)GROUP_EXCLUSIVE_YYYU)};
        this.backdoor.issues().setIssueFields(this.issueKey, new IssueFields().customField(this.getCfIdAsLong(this.multiGroupPickerCustomFieldId), (Object)groups));
        this.permissionSchemesControl.addGroupCustomFieldPermission(this.permissionSchemeId, this.getPermission(), this.multiGroupPickerCustomFieldId);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_YEVGENI, USER_YURI, USER_YUSTYN, USER_ZACHARY}));
    }

    @Test
    public void testSearchPerformanceWithSelectCustomField() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        this.addAlbertAndZacharyToGroupExclusiveYyy();
        try {
            this.backdoor.customFields().addOption(this.selectCustomFieldId, GROUP_EXCLUSIVE_YYY);
            this.setCustomFieldValue(this.issueKey, "selectCustomField", this.selectCustomFieldId, GROUP_EXCLUSIVE_YYY);
            this.permissionSchemesControl.addGroupCustomFieldPermission(this.permissionSchemeId, this.getPermission(), this.selectCustomFieldId);
            this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_YEVGENI, USER_YURI, USER_YUSTYN, USER_ZACHARY}));
        }
        finally {
            this.backdoor.customFields().deleteOption(this.selectCustomFieldId, GROUP_EXCLUSIVE_YYY);
        }
    }

    @Test
    public void testSearchPerformanceWithMultiSelectCustomField() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        this.addAlbertAndZacharyToGroupExclusiveYyy();
        try {
            this.backdoor.customFields().addOption(this.multiSelectCustomFieldId, GROUP_EXCLUSIVE_YYY);
            this.setCustomFieldValue(this.issueKey, MULTI_SELECT_CUSTOM_FIELD, this.multiSelectCustomFieldId, GROUP_EXCLUSIVE_YYY);
            this.permissionSchemesControl.addGroupCustomFieldPermission(this.permissionSchemeId, this.getPermission(), this.multiSelectCustomFieldId);
            this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_YEVGENI, USER_YURI, USER_YUSTYN, USER_ZACHARY}));
        }
        finally {
            this.backdoor.customFields().deleteOption(this.multiSelectCustomFieldId, GROUP_EXCLUSIVE_YYY);
        }
    }

    @Test
    public void testSearchPerformanceWithMultiSelectCustomFieldHavingSelectedOptionsThatAreNotAGroup() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        this.addAlbertAndZacharyToGroupExclusiveYyy();
        String NOT_A_GROUP = "random string that is not a group name";
        String ALSO_NOT_A_GROUP = "another coincidentally occurring verbal message";
        try {
            this.backdoor.customFields().addOption(this.multiSelectCustomFieldId, "random string that is not a group name");
            this.backdoor.customFields().addOption(this.multiSelectCustomFieldId, GROUP_EXCLUSIVE_YYY);
            this.backdoor.customFields().addOption(this.multiSelectCustomFieldId, "another coincidentally occurring verbal message");
            this.setCustomFieldValue(this.issueKey, MULTI_SELECT_CUSTOM_FIELD, this.multiSelectCustomFieldId, "random string that is not a group name", GROUP_EXCLUSIVE_YYY, "another coincidentally occurring verbal message");
            this.permissionSchemesControl.addGroupCustomFieldPermission(this.permissionSchemeId, this.getPermission(), this.multiSelectCustomFieldId);
            this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_YEVGENI, USER_YURI, USER_YUSTYN, USER_ZACHARY}));
        }
        finally {
            this.backdoor.customFields().deleteOption(this.multiSelectCustomFieldId, "random string that is not a group name");
            this.backdoor.customFields().deleteOption(this.multiSelectCustomFieldId, GROUP_EXCLUSIVE_YYY);
            this.backdoor.customFields().deleteOption(this.multiSelectCustomFieldId, "another coincidentally occurring verbal message");
        }
    }

    @Test
    public void testSearchPerformanceWithUserPickerCustomField() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        this.backdoor.issues().setIssueFields(this.issueKey, new IssueFields().customField(this.getCfIdAsLong(this.userPickerCustomFieldId), (Object)ImmutableMap.of((Object)"name", (Object)USER_ALICE)));
        this.permissionSchemesControl.addUserCustomFieldPermission(this.permissionSchemeId.longValue(), this.getPermission(), this.userPickerCustomFieldId);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALICE}));
    }

    @Test
    public void testSearchPerformanceWithMultiUserPickerCustomField() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        this.backdoor.issues().setIssueFields(this.issueKey, new IssueFields().customField(this.getCfIdAsLong(this.multiUserPickerCustomFieldId), (Object)new Map[]{ImmutableMap.of((Object)"name", (Object)USER_YEVGENI), ImmutableMap.of((Object)"name", (Object)USER_ALICE), ImmutableMap.of((Object)"name", (Object)USER_ALBERT), ImmutableMap.of((Object)"name", (Object)USER_ZACHARY)}));
        this.permissionSchemesControl.addUserCustomFieldPermission(this.permissionSchemeId.longValue(), this.getPermission(), this.multiUserPickerCustomFieldId);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_ALICE, USER_YEVGENI, USER_ZACHARY}));
    }

    @Test
    public void testSearchPerformanceWithGroupThatHasSixNestedGroups() {
        this.permissionSchemesControl.addGroupPermission(this.permissionSchemeId, this.getPermission(), PYRAMID_MASTER_GROUP);
        this.testSearchPerformance(TestType.LOAD, Matchers.hasSize((int)51));
    }

    @Test
    public void testSearchPerformanceWithGroupThatHasManyGroups() {
        this.permissionSchemesControl.addGroupPermission(this.permissionSchemeId, this.getPermission(), FLAT_MASTER_GROUP);
        this.testSearchPerformance(TestType.LOAD, Matchers.hasSize((int)this.maxResults));
    }

    @Test
    public void testSearchCorrectnessCaseSensitiveOrder() {
        Stream.of(USER_ALBERT, USER_ANNA, USER_ZACHARY, USER_ZUZANNA).forEach(username -> this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), username));
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_ANNA, USER_ZACHARY, USER_ZUZANNA}));
    }

    @Test
    public void testSearchCorrectnessCaseSensitiveOrderWithLimitedQueriesUserPermissions() {
        this.maxResults = 3;
        Stream.of(USER_ALBERT, USER_ANNA, USER_ZACHARY, USER_ZUZANNA).forEach(username -> this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), username));
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_ANNA}));
    }

    @Test
    public void testSearchCorrectnessCaseSensitiveOrderUserAndGroupPermissions() {
        Stream.of(USER_ANNA, USER_ZUZANNA).forEach(username -> this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), username));
        Stream.of(USER_ALBERT, USER_ZACHARY).forEach(username -> this.backdoor.usersAndGroups().addUserToGroup(username, INTERNAL_GROUP));
        this.permissionSchemesControl.addGroupPermission(this.permissionSchemeId, this.getPermission(), INTERNAL_GROUP);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_ANNA, USER_ZACHARY, USER_ZUZANNA}));
    }

    @Test
    public void testSearchCorrectnessCaseSensitiveOrderWithLimitedQueriesUserAndGroupPermissions() {
        this.maxResults = 3;
        Stream.of(USER_ANNA, USER_ZUZANNA).forEach(username -> this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), username));
        Stream.of(USER_ALBERT, USER_ZACHARY).forEach(username -> this.backdoor.usersAndGroups().addUserToGroup(username, INTERNAL_GROUP));
        this.permissionSchemesControl.addGroupPermission(this.permissionSchemeId, this.getPermission(), INTERNAL_GROUP);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_ANNA}));
    }

    @Test
    public void testSearchCorrectnessDifferentFields() {
        String username = "username_ldap_user";
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), "username_ldap_user");
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"username_ldap_user"}), "USERNAME");
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"username_ldap_user"}), "DISPLAY NAME");
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.is((Matcher)Matchers.empty()), "FIRSTNAME");
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.is((Matcher)Matchers.empty()), "LASTNAME");
    }

    @Test
    public void testSearchCorrectnessDifferentPartOfDisplayName() {
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_ALICE);
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_BOB);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_ALICE}), "AL");
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_ALICE, USER_BOB}), "LDAP");
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_ALICE, USER_BOB}), "USER");
    }

    @Test
    public void testSearchPerformanceWithManyResults() {
        this.maxResults = Integer.MAX_VALUE;
        int expectedMentionsCount = 100;
        this.permissionSchemesControl.addGroupPermission(this.permissionSchemeId, this.getPermission(), "jira-users");
        List<String> first100JiraUsers = DataTestProvider.get100FirstJiraUsersGroupMembers();
        this.searchPerformanceWithManyResultsAssertion(first100JiraUsers, 100);
    }

    protected abstract void searchPerformanceWithManyResultsAssertion(List<String> var1, int var2);

    @Test
    public void testSearchPerformanceWithThreeLetterQuery() {
        this.permissionSchemesControl.addGroupPermission(this.permissionSchemeId, this.getPermission(), GROUP_FOR_TEXT_SEARCH_WITH_SEP_USERS);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_SEPHIRA, USER_SEPP, USER_SEPTEMBER, USER_SEPTIMUS}), "sep");
    }

    @Test
    public void testSearchPerformanceWithThreeLetterQueryButAllJiraUsersAllowed() {
        String prefix = "sep";
        this.permissionSchemesControl.addGroupPermission(this.permissionSchemeId, this.getPermission(), "jira-users");
        List<String> jiraUsersWithPrefix = DataTestProvider.getSortedJiraUsersWithPrefixSep();
        this.testSearchPerformance(TestType.LOAD, Matchers.equalTo(jiraUsersWithPrefix), "sep");
    }

    @Test
    public void testSearchPerformanceWithGroupAny() {
        this.permissionSchemesControl.addGroupPermission(this.permissionSchemeId, this.getPermission(), null);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.hasSize((int)this.maxResults));
    }

    @Test
    public void testSearchPerformanceWithApplicationRoleAnyLoggedInUser() {
        this.permissionSchemesControl.addApplicationRolePermission(this.permissionSchemeId.longValue(), this.getPermission(), "");
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.hasSize((int)this.maxResults));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiplePermissionsCorrectOrdering() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        String groupDeltaBuddies = "delta-buddies";
        String groupDeltaMids = "delta-mids";
        String groupDeltaSeniors = "delta-seniors";
        String groupDeltaSzymons = "delta-szymons";
        String userAndrzej = TestOptimisedUserSearch.ldapUser("Andrzej");
        String userAnkit = TestOptimisedUserSearch.ldapUser("Ankit");
        String userAntoni = TestOptimisedUserSearch.ldapUser("Antoni");
        String userDaria = TestOptimisedUserSearch.ldapUser("Daria");
        String userJakub = TestOptimisedUserSearch.ldapUser("Jakub");
        String userKamil = TestOptimisedUserSearch.ldapUser("Kamil");
        String userKarol = TestOptimisedUserSearch.ldapUser("Karol");
        String userMaciej = TestOptimisedUserSearch.ldapUser("Maciej");
        String userSzymonK = TestOptimisedUserSearch.ldapUser("SzymonK");
        String userSzymonG = TestOptimisedUserSearch.ldapUser("SzymonG");
        try {
            this.permissionSchemesControl.addGroupPermission(this.permissionSchemeId, this.getPermission(), "delta-seniors");
            this.permissionSchemesControl.addProjectLeadPermission(this.permissionSchemeId.longValue(), this.getPermission());
            this.backdoor.project().setProjectLead(10000L, userJakub);
            this.permissionSchemesControl.addGroupPermission(this.permissionSchemeId, this.getPermission(), "delta-szymons");
            this.backdoor.customFields().addOption(this.multiSelectCustomFieldId, "delta-buddies");
            this.setCustomFieldValue(this.issueKey, MULTI_SELECT_CUSTOM_FIELD, this.multiSelectCustomFieldId, "delta-buddies");
            this.permissionSchemesControl.addGroupCustomFieldPermission(this.permissionSchemeId, this.getPermission(), this.multiSelectCustomFieldId);
            this.permissionSchemesControl.addProjectRolePermission(this.permissionSchemeId.longValue(), this.getPermission(), 10001L);
            this.backdoor.projectRole().setActors(PROJECT_KEY, "Developers", (Map)ImmutableMap.builder().put((Object)"atlassian-group-role-actor", (Object)new String[]{"delta-mids"}).put((Object)"atlassian-user-role-actor", (Object)new String[]{userDaria}).build());
            Map[] users = new Map[]{ImmutableMap.of((Object)"name", (Object)userAnkit), ImmutableMap.of((Object)"name", (Object)userKarol)};
            this.backdoor.issues().setIssueFields(this.issueKey, new IssueFields().customField(this.getCfIdAsLong(this.multiUserPickerCustomFieldId), (Object)users));
            this.permissionSchemesControl.addUserCustomFieldPermission(this.permissionSchemeId.longValue(), this.getPermission(), this.multiUserPickerCustomFieldId);
            this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), ProjectPermissions.ASSIGNABLE_USER, userAndrzej);
            this.setAssignee(this.issueKey, userAndrzej);
            this.watchersClient.postResponse(this.issueKey, userSzymonG);
            this.multiplePermissionsCorrectOrderingAssertion("admin", userAndrzej, userAnkit, userAntoni, userDaria, userJakub, userKamil, userKarol, userMaciej, userSzymonG, userSzymonK);
        }
        finally {
            this.backdoor.project().setProjectLead(10000L, "admin");
            this.backdoor.customFields().deleteOption(this.multiSelectCustomFieldId, "delta-buddies");
            this.setAssignee(this.issueKey, "admin");
            this.watchersClient.deleteResponse(this.issueKey, userSzymonG);
        }
    }

    protected void multiplePermissionsCorrectOrderingAssertion(String admin, String userAndrzej, String userAnkit, String userAntoni, String userDaria, String userJakub, String userKamil, String userKarol, String userMaciej, String userSzymonG, String userSzymonK) {
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{userAndrzej, admin, userSzymonG, userAnkit, userAntoni, userDaria, userJakub, userKamil, userKarol, userMaciej, userSzymonK}));
    }

    @Test
    public void testAnonymizedUserDoesNotAppearInSearch() {
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_ELON_ACTIVE);
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_ELON_ANONYMIZED);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_ELON_ACTIVE, USER_ELON_ANONYMIZED}), "elon_");
        this.userAnonymizeControl.anonymize(this.backdoor.usersAndGroups().getUserByName(USER_ELON_ANONYMIZED).getKey());
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_ELON_ACTIVE}), "elon_");
    }

    @Test
    public void testInactiveUserDoesNotAppearInSearch() {
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_ELON_ACTIVE);
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_ELON_INACTIVE);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_ELON_ACTIVE, USER_ELON_INACTIVE}), "elon_");
        this.backdoor.userManager().setActive(USER_ELON_INACTIVE, false);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_ELON_ACTIVE}), "elon_");
    }

    @Test
    public void testDeletedUserDoesNotAppearInSearch() {
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_STEVE_EXISTING);
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_STEVE_DELETED);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_STEVE_DELETED, USER_STEVE_EXISTING}), "steve_");
        this.backdoor.usersAndGroups().deleteUser(USER_STEVE_DELETED);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_STEVE_EXISTING}), "steve_");
    }

    @Test
    public void testUsersFromDeletedGroupDoesNotAppearInSearch() {
        this.backdoor.usersAndGroups().addUserToGroup(USER_NATASHA_IN_GROUP, INTERNAL_GROUP);
        this.permissionSchemesControl.addGroupPermission(this.permissionSchemeId, this.getPermission(), INTERNAL_GROUP);
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_NATASHA_ALONE);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_NATASHA_ALONE, USER_NATASHA_IN_GROUP}), "natasha");
        this.backdoor.usersAndGroups().deleteGroup(INTERNAL_GROUP);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_NATASHA_ALONE}), "natasha");
    }

    @Test
    public void testSearchPerformanceWhenIssueIsUnassigned() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        try {
            this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_ALICE);
            this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), ProjectPermissions.ASSIGNABLE_USER, USER_BOB);
            this.setAssignee(this.issueKey, USER_BOB);
            this.searchPerformanceWhenIssueIsUnassignedAssertion();
        }
        finally {
            this.backdoor.generalConfiguration().disallowUnassignedIssues();
            this.backdoor.project().setProjectDefaultAssignee(10000L, true);
        }
    }

    protected void searchPerformanceWhenIssueIsUnassignedAssertion() {
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_BOB, "admin", USER_ALICE}));
        this.backdoor.generalConfiguration().allowUnassignedIssues();
        this.backdoor.project().setProjectDefaultAssignee(10000L, false);
        this.backdoor.issues().assignIssue(this.issueKey, "-1");
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALICE}));
    }

    @Test
    public void testSearchPerformanceWhenReporterIsNotSet() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_ALICE);
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), ProjectPermissions.ASSIGNABLE_USER, USER_ALBERT);
        this.setReporter(this.issueKey, USER_ALBERT);
        this.searchPerformanceWhenReporterIsNotSetAssertion();
    }

    protected void searchPerformanceWhenReporterIsNotSetAssertion() {
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_ALICE}));
        this.setReporter(this.issueKey, "");
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALICE}));
    }

    @Test
    public void testSearchPerformanceWhenUserPickerCustomFieldHasNoValue() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_ALICE);
        this.permissionSchemesControl.addUserCustomFieldPermission(this.permissionSchemeId, this.getPermission(), this.userPickerCustomFieldId);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALICE}));
    }

    @Test
    public void testSearchPerformanceWhenGroupPickerCustomFieldHasNoValue() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_ALICE);
        this.permissionSchemesControl.addUserCustomFieldPermission(this.permissionSchemeId, this.getPermission(), this.groupPickerCustomFieldId);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALICE}));
    }

    @Test
    public void testSearchPerformanceAfterAssigneeIsAnonymized() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_ALICE);
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), ProjectPermissions.ASSIGNABLE_USER, USER_ANNA);
        this.setAssignee(this.issueKey, USER_ANNA);
        this.searchPerformanceAfterAssigneeIsAnonymizedAssertion();
    }

    protected void searchPerformanceAfterAssigneeIsAnonymizedAssertion() {
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{USER_ANNA, "admin", USER_ALICE}));
        String anonymizedUserKey = this.backdoor.usersAndGroups().getUserByName(USER_ANNA).getKey();
        this.userAnonymizeControl.anonymize(anonymizedUserKey);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{anonymizedUserKey.toLowerCase(), "admin", USER_ALICE}));
    }

    @Test
    public void testSearchPerformanceAfterUserInCustomFieldIsAnonymized() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_ALICE);
        this.backdoor.issues().setIssueFields(this.issueKey, new IssueFields().customField(this.getCfIdAsLong(this.userPickerCustomFieldId), (Object)ImmutableMap.of((Object)"name", (Object)USER_ALBERT)));
        this.permissionSchemesControl.addUserCustomFieldPermission(this.permissionSchemeId, this.getPermission(), this.userPickerCustomFieldId);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_ALICE}));
        String anonymisedUserKey = this.backdoor.usersAndGroups().getUserByName(USER_ALBERT).getKey();
        this.userAnonymizeControl.anonymize(anonymisedUserKey);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALICE}));
    }

    @Test
    public void testSearchPerformanceAfterReporterIsAnonymized() {
        Assume.assumeTrue((boolean)this.issueAlreadyExists());
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_ALICE);
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), ProjectPermissions.ASSIGNABLE_USER, USER_ALBERT);
        this.setReporter(this.issueKey, USER_ALBERT);
        this.searchPerformanceAfterReporterIsAnonymizedAssertion();
    }

    protected void searchPerformanceAfterReporterIsAnonymizedAssertion() {
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_ALICE}));
        String anonymisedUserKey = this.backdoor.usersAndGroups().getUserByName(USER_ALBERT).getKey();
        this.userAnonymizeControl.anonymize(anonymisedUserKey);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", anonymisedUserKey.toLowerCase(), USER_ALICE}));
    }

    @Test
    public void testSearchPerformanceForUserWithNoApplicationAccess() {
        this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), USER_FOREVER_ALONE);
        this.testSearchPerformance(TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_FOREVER_ALONE}));
    }

    @Test
    public void testSearchPerformanceWithManyBigGroups() {
        for (int i = 0; i < 20; ++i) {
            this.permissionSchemesControl.addGroupPermission(this.permissionSchemeId, this.getPermission(), BIG_GROUP_PREFIX + i);
        }
        this.testSearchPerformance(TestType.LOAD, Matchers.hasSize((int)this.maxResults));
    }

    @Test
    @Ignore(value="UCACHE-35")
    public void testSearchPerformanceWithManyUserPermissions() {
        for (int i = 0; i < 5000; ++i) {
            this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), EXPLICIT_USER_PREFIX + i + LDAP_USER_SUFFIX);
        }
        this.testSearchPerformance(TestType.LOAD, Matchers.hasSize((int)this.maxResults));
    }

    @Test
    @Ignore(value="UCACHE-35")
    public void testSearchPerformanceWithManyUserPermissionsWithPrefix() {
        for (int i = 0; i < 5000; ++i) {
            this.permissionSchemesControl.addUserPermission(this.permissionSchemeId.longValue(), this.getPermission(), EXPLICIT_USER_PREFIX + i + LDAP_USER_SUFFIX);
        }
        this.testSearchPerformance(TestType.LOAD, Matchers.hasSize((int)this.maxResults), "explicit");
    }

    protected void testSearchPerformance(TestType testType, Matcher expectedUsers) {
        this.testSearchPerformance(testType, expectedUsers, "");
    }

    private void testSearchPerformance(TestType testType, Matcher expectedUsers, String query) {
        ArrayList<Long> testMeasures = new ArrayList<Long>(NUMBER_OF_ATTEMPTS);
        for (int attemptNumber = 0; attemptNumber < NUMBER_OF_ATTEMPTS; ++attemptNumber) {
            UserSearchResults mentions = this.getUserSearchResults(query);
            String currentTestName = Thread.currentThread().getStackTrace()[2].getMethodName();
            logger.log((Object)String.format("RESULT,%s,ATTEMPT:%d,%d", currentTestName, attemptNumber, mentions.elapsed));
            logger.log((Object)("DEBUG: " + mentions));
            testMeasures.add(mentions.elapsed);
            MatcherAssert.assertThat(mentions.usernames, (Matcher)expectedUsers);
        }
        testResults.put(this.name.getMethodName(), testMeasures);
        long performanceResult = TestOptimisedUserSearch.getMedian(testMeasures);
        if (testType == TestType.FUNCTIONAL) {
            MatcherAssert.assertThat((Object)performanceResult, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(400L))));
        }
        if (testType == TestType.LOAD) {
            MatcherAssert.assertThat((Object)performanceResult, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(1000L))));
        }
        MatcherAssert.assertThat(testMeasures, (Matcher)Matchers.everyItem((Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(10000L)))));
    }

    private String addCustomField(String customFieldType, String customFieldSearcher) {
        String customFieldName = "allow_" + customFieldType;
        Optional<String> existingCustomFieldId = this.backdoor.customFields().getCustomFields().stream().filter(cfr -> customFieldName.equals(cfr.getName())).findFirst().map(cfr -> cfr.id);
        if (existingCustomFieldId.isPresent()) {
            return existingCustomFieldId.get();
        }
        String customFieldId = this.backdoor.customFields().createCustomField(customFieldName, "Allow members of this custom field to see issues", CustomFields.builtInCustomFieldKey(customFieldType), CustomFields.builtInCustomFieldKey(customFieldSearcher));
        this.backdoor.screens().addFieldToScreen("Default Screen", customFieldName);
        return customFieldId;
    }

    protected void setCustomFieldValue(String issueKey, String customFieldType, String customFieldId, String ... values) {
        ResourceRef typedValue;
        Long customFieldIdLong = CustomFieldUtils.getCustomFieldId((String)customFieldId);
        if (customFieldType.startsWith("multi")) {
            typedValue = Arrays.stream(values).map(ResourceRef::withValue).toArray(ResourceRef[]::new);
        } else if (values.length == 1) {
            typedValue = ResourceRef.withValue((String)values[0]);
        } else {
            throw new IllegalArgumentException(Arrays.toString(values));
        }
        this.updateIssueField(issueKey, fields -> fields.customField(customFieldIdLong, typedValue));
    }

    protected void setReporter(String issueKey, String username) {
        if (username.isEmpty()) {
            this.backdoor.getTestkit().fieldConfiguration().makeFieldOptional("Default Field Configuration", "reporter");
        }
        this.updateIssueField(issueKey, fields -> fields.reporter(ResourceRef.withName((String)username)));
    }

    protected void setAssignee(String issueKey, String username) {
        this.updateIssueField(issueKey, fields -> fields.assignee(ResourceRef.withName((String)username)));
    }

    private void updateIssueField(String issueKey, Consumer<IssueFields> fieldsAdder) {
        IssueFields fields = new IssueFields();
        fieldsAdder.accept(fields);
        this.backdoor.issues().setIssueFields(issueKey, fields);
    }

    protected Long getCfIdAsLong(String cfIdAsString) {
        return Long.parseLong(cfIdAsString.split("_")[1]);
    }

    private void removeCustomFieldValue(String customFieldId) {
        this.backdoor.issues().setIssueFields(this.issueKey, new IssueFields().customField(this.getCfIdAsLong(customFieldId), Collections.emptyMap()));
    }

    private void addAlbertAndZacharyToGroupExclusiveYyy() {
        Stream.of(USER_ALBERT, USER_ZACHARY).forEach(username -> this.backdoor.usersAndGroups().addUserToGroup(username, GROUP_EXCLUSIVE_YYY));
    }

    private boolean isOptimisedMentionsOn() {
        try {
            return Boolean.parseBoolean(this.backdoor.systemProperties().getProperty("com.atlassian.jira.use.optimised.user.lookup"));
        }
        catch (WebApplicationException propertyNotSet) {
            return true;
        }
    }

    private static String internalUser(String username) {
        return username + "_internal_user";
    }

    protected static String ldapUser(String username) {
        return username + LDAP_USER_SUFFIX;
    }

    protected static long getAverage(List<Long> values) {
        return Math.round(TestOptimisedUserSearch.filterOutColdCacheMeasures(values).mapToLong(Long::longValue).average().orElse(Double.NaN));
    }

    protected static long getMin(List<Long> values) {
        return TestOptimisedUserSearch.filterOutColdCacheMeasures(values).min(Long::compareTo).orElse(0L);
    }

    protected static long getMax(List<Long> values) {
        return TestOptimisedUserSearch.filterOutColdCacheMeasures(values).max(Long::compareTo).orElse(0L);
    }

    protected static long getMedian(List<Long> values) {
        return Math.round(Quantiles.median().compute((Collection)TestOptimisedUserSearch.filterOutColdCacheMeasures(values).collect(Collectors.toList())));
    }

    protected static Stream<Long> filterOutColdCacheMeasures(List<Long> value) {
        return value.stream().skip(1L);
    }

    protected static class UserSearchResults {
        final long elapsed;
        final List<String> usernames;

        public UserSearchResults(long elapsed, List<String> usernames) {
            this.elapsed = elapsed;
            this.usernames = usernames;
        }

        public String toString() {
            return "UserSearchResults{elapsed=" + this.elapsed + ", usernames=" + this.usernames + '}';
        }
    }

    protected static enum TestType {
        LOAD,
        FUNCTIONAL;

    }
}

