/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.projectconfig;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.ProjectAdministration;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
@Restore(value="projectconfig/TestWebFragment.xml")
@LoginAs(user="admin")
public class TestBackToProjectConfigLink
extends BaseJiraFuncTest {
    @Inject
    Administration administration;

    @Test
    public void testBackToProjectConfigLink() {
        ProjectAdministration homosapienAdministration = ProjectAdministration.navigateToProject(this.navigation, this.getTester(), "HSP");
        this.assertNoProjectLink();
        homosapienAdministration.fields().goTo();
        this.assertOnFieldsTabWithoutReturn();
        this.tester.clickLink("project-config-fields-scheme-change");
        this.assertBackAndNavigate();
        this.assertOnFieldsTabWithoutReturn();
        this.navigation.gotoAdminSection(Navigation.AdminSection.WORKFLOWS);
        this.assertBackAndNavigate();
        this.assertOnFieldsTabWithoutReturn();
    }

    @Test
    public void testBackToProject_shouldNotDisplayAfterProjectDelete() {
        ProjectAdministration.navigateToProject(this.navigation, this.getTester(), "HSP");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.assertBackAndNavigate();
        this.backdoor.project().deleteProject("HSP");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.assertNoProjectLink();
    }

    @Test
    public void testBackToProject_shouldNotDisplayAfterProjectArchive() {
        ProjectAdministration.navigateToProject(this.navigation, this.getTester(), "HSP");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.assertBackAndNavigate();
        this.backdoor.project().archiveProject("HSP");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.assertNoProjectLink();
    }

    private void assertNoProjectLink() {
        this.assertions.assertNodeByIdDoesNotExist("proj-config-return-link");
    }

    private void assertBackAndNavigate() {
        this.assertions.assertNodeByIdExists("proj-config-return-link");
        this.assertions.assertNodeByIdHasText("proj-config-return-link", "Back to project: homosapien");
        this.tester.clickLink("proj-config-return-link");
    }

    private void assertOnFieldsTabWithoutReturn() {
        this.assertNoProjectLink();
        this.assertions.assertNodeByIdExists("project-config-panel-fields");
        this.assertions.assertNodeByIdHasText("project-config-scheme-name", "System Default Field Configuration");
    }
}

