/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.projectconfig;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.BaseTestWorkflowSchemeResource;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleIssueType;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleProject;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleWorkflow;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleWorkflowScheme;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.WorkflowSchemeResource;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestProjectWorkflowSchemeResource.xml")
@LoginAs(user="admin")
public class TestProjectWorkflowSchemeResource
extends BaseTestWorkflowSchemeResource {
    private static final String DEFAULT_JIRA_WORKFLOW_DESCRIPTION = "The default Jira workflow";

    @Test
    public void testGetWithDefaultWorkflowScheme() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        SimpleWorkflowScheme hsp = client.getWorkflowScheme(HSP.getKey());
        SimpleIssueType bug = this.bug();
        bug.setDefaultIssueType(true);
        SimpleIssueType improvement = this.improvement();
        SimpleIssueType monkey = this.monkey();
        SimpleIssueType newFeature = this.newFeature();
        SimpleIssueType task = this.task();
        SimpleIssueType ignored = this.ignored();
        List<SimpleIssueType> issueTypes = Arrays.asList(bug, ignored, improvement, monkey, newFeature, task);
        List<SimpleProject> projects = Arrays.asList(HSP, PROJECT_USING_DEFAULT_WORKFLOW_SCHEME);
        Assert.assertEquals(issueTypes, hsp.getIssueTypes());
        Assert.assertNotNull((Object)hsp.getShared());
        Assert.assertEquals(projects, hsp.getShared().getSharedWithProjects());
        Assert.assertEquals((Object)"Default Workflow Scheme", (Object)hsp.getName());
        Assert.assertEquals((Object)"This is the default Workflow Scheme. Any new projects that are created will be assigned this scheme.", (Object)hsp.getDescription());
        Assert.assertTrue((boolean)hsp.isAdmin());
        Assert.assertTrue((boolean)hsp.isDefaultScheme());
        Assert.assertFalse((boolean)hsp.isDraftScheme());
        Assert.assertNull((Object)hsp.getLastModifiedDate());
        Assert.assertNull((Object)hsp.getLastModifiedUser());
        Assert.assertEquals((Object)"admin", (Object)hsp.getCurrentUser());
        SimpleWorkflow workflow = new SimpleWorkflow("jira", DEFAULT_JIRA_WORKFLOW_DESCRIPTION, true, true, Arrays.asList(bug.getId(), ignored.getId(), improvement.getId(), monkey.getId(), newFeature.getId(), task.getId()), true);
        Assert.assertEquals(Arrays.asList(workflow), hsp.getMappings());
    }

    @Test
    public void testGetWithComplexScheme() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        SimpleWorkflowScheme mky = client.getWorkflowScheme(MKY.getKey());
        SimpleIssueType bug = this.bug();
        SimpleIssueType improvment = this.improvement();
        SimpleIssueType monkey = this.monkey();
        SimpleIssueType newFeature = this.newFeature();
        SimpleIssueType task = this.task();
        List<SimpleIssueType> issueTypes = Arrays.asList(bug, improvment, monkey, newFeature, task);
        Assert.assertEquals(issueTypes, mky.getIssueTypes());
        Assert.assertEquals((Object)"monkey workflow scheme 3", (Object)mky.getName());
        Assert.assertNull((Object)mky.getDescription());
        Assert.assertTrue((boolean)mky.isAdmin());
        Assert.assertFalse((boolean)mky.isDefaultScheme());
        Assert.assertNotNull((Object)mky.getShared());
        Assert.assertEquals(Arrays.asList(MKY, TEST), mky.getShared().getSharedWithProjects());
        Assert.assertFalse((boolean)mky.isDraftScheme());
        Assert.assertNull((Object)mky.getLastModifiedDate());
        Assert.assertNull((Object)mky.getLastModifiedUser());
        Assert.assertEquals((Object)"admin", (Object)mky.getCurrentUser());
        SimpleWorkflow jiraWorkflow = new SimpleWorkflow("jira", DEFAULT_JIRA_WORKFLOW_DESCRIPTION, true, true, Arrays.asList(bug.getId(), monkey.getId(), newFeature.getId()), true);
        SimpleWorkflow monkeyWorkflow = new SimpleWorkflow("monkey 2 Workflow", null, false, false, Arrays.asList(improvment.getId(), task.getId()));
        Assert.assertEquals(Arrays.asList(jiraWorkflow, monkeyWorkflow), mky.getMappings());
    }

    @Test
    public void testGetWithComplexDraftScheme() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        SimpleWorkflowScheme pwdws = client.getWorkflowScheme(PROJECT_WITH_DRAFT_WORKFLOW_SCHEME.getKey());
        SimpleIssueType bug = this.bug();
        bug.setDefaultIssueType(true);
        SimpleIssueType improvment = this.improvement();
        SimpleIssueType monkey = this.monkey();
        SimpleIssueType newFeature = this.newFeature();
        SimpleIssueType task = this.task();
        SimpleIssueType ignored = this.ignored();
        List<SimpleIssueType> issueTypes = Arrays.asList(bug, ignored, improvment, monkey, newFeature, task);
        Assert.assertEquals(issueTypes, pwdws.getIssueTypes());
        Assert.assertEquals((Object)"monkey workflow scheme 4", (Object)pwdws.getName());
        Assert.assertNull((Object)pwdws.getDescription());
        Assert.assertTrue((boolean)pwdws.isAdmin());
        Assert.assertFalse((boolean)pwdws.isDefaultScheme());
        Assert.assertNotNull((Object)pwdws.getShared());
        Assert.assertEquals(Arrays.asList(PROJECT_WITH_DRAFT_WORKFLOW_SCHEME), pwdws.getShared().getSharedWithProjects());
        Assert.assertTrue((boolean)pwdws.isDraftScheme());
        Assert.assertEquals((Object)"10/Aug/11 3:00 PM", (Object)pwdws.getLastModifiedDate());
        Assert.assertEquals((Object)ADMIN_USER, (Object)pwdws.getLastModifiedUser());
        Assert.assertEquals((Object)"admin", (Object)pwdws.getCurrentUser());
        SimpleWorkflow jiraWorkflow = new SimpleWorkflow("jira", DEFAULT_JIRA_WORKFLOW_DESCRIPTION, true, true, Arrays.asList(bug.getId(), monkey.getId(), newFeature.getId()), true);
        SimpleWorkflow monkey2Workflow = new SimpleWorkflow("monkey 2 Workflow", null, false, false, Arrays.asList(improvment.getId(), task.getId()));
        SimpleWorkflow monkeyWorkflow = new SimpleWorkflow("monkey Workflow", null, false, false, Arrays.asList(ignored.getId()));
        Assert.assertEquals(Arrays.asList(jiraWorkflow, monkey2Workflow, monkeyWorkflow), pwdws.getMappings());
    }

    @Test
    public void testGetNoPermissionAnonymous() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        ParsedResponse response = ((WorkflowSchemeResource)client.anonymous()).getWorkflowResponse(MKY.getKey());
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testGetNoPermissionLoggedIn() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        ParsedResponse response = ((WorkflowSchemeResource)client.loginAs("fred")).getWorkflowResponse(MKY.getKey());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("You cannot edit the configuration of this project."));
    }

    @Test
    public void testGetNoProject() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        ParsedResponse response = client.getWorkflowResponse("ASDF");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("No project could be found with key 'ASDF'."));
    }

    @Test
    public void testGetProjectAdmin() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        SimpleWorkflowScheme mky = ((WorkflowSchemeResource)client.loginAs("proj")).getWorkflowScheme(MKY.getKey());
        SimpleIssueType bug = this.bug();
        SimpleIssueType improvment = this.improvement();
        SimpleIssueType monkey = this.monkey();
        SimpleIssueType newFeature = this.newFeature();
        SimpleIssueType task = this.task();
        List<SimpleIssueType> issueTypes = Arrays.asList(bug, improvment, monkey, newFeature, task);
        Assert.assertEquals(issueTypes, mky.getIssueTypes());
        Assert.assertEquals(Arrays.asList(MKY), mky.getShared().getSharedWithProjects());
        Assert.assertEquals((Object)"monkey workflow scheme 3", (Object)mky.getName());
        Assert.assertNull((Object)mky.getDescription());
        Assert.assertFalse((boolean)mky.isAdmin());
        Assert.assertFalse((boolean)mky.isDefaultScheme());
        Assert.assertFalse((boolean)mky.isDraftScheme());
        Assert.assertNull((Object)mky.getLastModifiedDate());
        Assert.assertNull((Object)mky.getLastModifiedUser());
        Assert.assertEquals((Object)"proj", (Object)mky.getCurrentUser());
        SimpleWorkflow jiraWorkflow = new SimpleWorkflow("jira", DEFAULT_JIRA_WORKFLOW_DESCRIPTION, true, true, Arrays.asList(bug.getId(), monkey.getId(), newFeature.getId()), true);
        SimpleWorkflow monkeyWorkflow = new SimpleWorkflow("monkey 2 Workflow", null, false, false, Arrays.asList(improvment.getId(), task.getId()));
        Assert.assertEquals(Arrays.asList(jiraWorkflow, monkeyWorkflow), mky.getMappings());
        ParsedResponse response = client.getWorkflowResponse(HSP.getKey());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("You cannot edit the configuration of this project."));
    }

    @Test
    public void testGetWithDefault() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        SimpleWorkflowScheme scheme = client.getWorkflowScheme(PROJECT_WITH_DEFAULT_WORKFLOW.getKey());
        SimpleIssueType bug = this.bug();
        bug.setDefaultIssueType(true);
        SimpleIssueType improvment = this.improvement();
        SimpleIssueType monkey = this.monkey();
        SimpleIssueType newFeature = this.newFeature();
        SimpleIssueType task = this.task();
        SimpleIssueType ignored = this.ignored();
        List<SimpleIssueType> issueTypes = Arrays.asList(bug, ignored, improvment, monkey, newFeature, task);
        List<SimpleProject> projects = Arrays.asList(PROJECT_WITHOUT_DEFAULT_WORKFLOW, PROJECT_WITH_DEFAULT_WORKFLOW);
        Assert.assertEquals(issueTypes, scheme.getIssueTypes());
        Assert.assertNotNull((Object)scheme.getShared());
        Assert.assertEquals(projects, scheme.getShared().getSharedWithProjects());
        Assert.assertEquals((Object)"monkey workflow scheme 2", (Object)scheme.getName());
        Assert.assertNull((Object)scheme.getDescription());
        Assert.assertTrue((boolean)scheme.isAdmin());
        Assert.assertFalse((boolean)scheme.isDefaultScheme());
        Assert.assertFalse((boolean)scheme.isDraftScheme());
        Assert.assertNull((Object)scheme.getLastModifiedDate());
        Assert.assertNull((Object)scheme.getLastModifiedUser());
        Assert.assertEquals((Object)"admin", (Object)scheme.getCurrentUser());
        SimpleWorkflow monkeyWorkflow = new SimpleWorkflow("monkey Workflow", null, true, false, Arrays.asList(ignored.getId(), monkey.getId(), newFeature.getId(), task.getId()));
        SimpleWorkflow jira = new SimpleWorkflow("jira", DEFAULT_JIRA_WORKFLOW_DESCRIPTION, false, true, Arrays.asList(bug.getId()), true);
        SimpleWorkflow monkey2Workflow = new SimpleWorkflow("monkey 2 Workflow", null, false, false, Arrays.asList(improvment.getId()));
        Assert.assertEquals(Arrays.asList(monkeyWorkflow, jira, monkey2Workflow), scheme.getMappings());
    }

    @Test
    public void testGetNoDefault() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        SimpleWorkflowScheme scheme = client.getWorkflowScheme(PROJECT_WITHOUT_DEFAULT_WORKFLOW.getKey());
        SimpleIssueType bug = this.bug();
        SimpleIssueType improvment = this.improvement();
        List<SimpleIssueType> issueTypes = Arrays.asList(bug, improvment);
        List<SimpleProject> projects = Arrays.asList(PROJECT_WITHOUT_DEFAULT_WORKFLOW, PROJECT_WITH_DEFAULT_WORKFLOW);
        Assert.assertEquals(issueTypes, scheme.getIssueTypes());
        Assert.assertNotNull((Object)scheme.getShared());
        Assert.assertEquals(projects, scheme.getShared().getSharedWithProjects());
        Assert.assertEquals((Object)"monkey workflow scheme 2", (Object)scheme.getName());
        Assert.assertNull((Object)scheme.getDescription());
        Assert.assertTrue((boolean)scheme.isAdmin());
        Assert.assertFalse((boolean)scheme.isDefaultScheme());
        Assert.assertFalse((boolean)scheme.isDraftScheme());
        Assert.assertNull((Object)scheme.getLastModifiedDate());
        Assert.assertNull((Object)scheme.getLastModifiedUser());
        Assert.assertEquals((Object)"admin", (Object)scheme.getCurrentUser());
        SimpleWorkflow jira = new SimpleWorkflow("jira", DEFAULT_JIRA_WORKFLOW_DESCRIPTION, false, true, Arrays.asList(bug.getId()), true);
        SimpleWorkflow monkey2Workflow = new SimpleWorkflow("monkey 2 Workflow", null, false, false, Arrays.asList(improvment.getId()));
        Assert.assertEquals(Arrays.asList(jira, monkey2Workflow), scheme.getMappings());
    }

    @Test
    public void testCreateDraftWorkflowSchemeWhileUsingDefaultWorkflowScheme() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        this.checkWorkflowScheme(client.createDraftWorkflowScheme(PROJECT_USING_DEFAULT_WORKFLOW_SCHEME.getKey()));
        this.checkWorkflowScheme(client.createDraftWorkflowScheme(PROJECT_USING_DEFAULT_WORKFLOW_SCHEME.getKey()));
    }

    private void checkWorkflowScheme(SimpleWorkflowScheme scheme) {
        SimpleIssueType bug = this.bug();
        bug.setDefaultIssueType(true);
        SimpleIssueType improvment = this.improvement();
        SimpleIssueType monkey = this.monkey();
        SimpleIssueType issueType = this.newFeature();
        SimpleIssueType task = this.task();
        SimpleIssueType ignored = this.ignored();
        List<SimpleIssueType> issueTypes = Arrays.asList(bug, ignored, improvment, monkey, issueType, task);
        List<SimpleProject> projects = Arrays.asList(PROJECT_USING_DEFAULT_WORKFLOW_SCHEME);
        Assert.assertEquals(issueTypes, scheme.getIssueTypes());
        Assert.assertEquals(projects, scheme.getShared().getSharedWithProjects());
        Assert.assertEquals((Object)(PROJECT_USING_DEFAULT_WORKFLOW_SCHEME.getName() + " Workflow Scheme"), (Object)scheme.getName());
        Assert.assertNull((Object)scheme.getDescription());
        Assert.assertTrue((boolean)scheme.isAdmin());
        Assert.assertFalse((boolean)scheme.isDefaultScheme());
        Assert.assertTrue((boolean)scheme.isDraftScheme());
        Assert.assertNotNull((Object)scheme.getLastModifiedDate());
        Assert.assertEquals((Object)ADMIN_USER, (Object)scheme.getLastModifiedUser());
        Assert.assertEquals((Object)"admin", (Object)scheme.getCurrentUser());
        SimpleWorkflow workflow = new SimpleWorkflow("jira", DEFAULT_JIRA_WORKFLOW_DESCRIPTION, true, true, Arrays.asList(bug.getId(), ignored.getId(), improvment.getId(), monkey.getId(), issueType.getId(), task.getId()), true);
        Assert.assertEquals(Arrays.asList(workflow), scheme.getMappings());
    }

    @Test
    public void testCreateDraftWorkflowSchemeWhileUsingNonDefaultWorkflowScheme() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        SimpleWorkflowScheme scheme = client.createDraftWorkflowScheme(PROJECT_NOT_USING_DEFAULT_WORKFLOW_SCHEME.getKey());
        SimpleIssueType bug = this.bug();
        bug.setDefaultIssueType(true);
        SimpleIssueType improvment = this.improvement();
        SimpleIssueType monkey = this.monkey();
        SimpleIssueType issueType = this.newFeature();
        SimpleIssueType task = this.task();
        SimpleIssueType ignored = this.ignored();
        List<SimpleIssueType> issueTypes = Arrays.asList(bug, ignored, improvment, monkey, issueType, task);
        List<SimpleProject> projects = Arrays.asList(PROJECT_NOT_USING_DEFAULT_WORKFLOW_SCHEME);
        Assert.assertEquals(issueTypes, scheme.getIssueTypes());
        Assert.assertEquals(projects, scheme.getShared().getSharedWithProjects());
        Assert.assertEquals((Object)(PROJECT_NOT_USING_DEFAULT_WORKFLOW_SCHEME.getName() + " Workflow Scheme"), (Object)scheme.getName());
        Assert.assertNull((Object)scheme.getDescription());
        Assert.assertTrue((boolean)scheme.isAdmin());
        Assert.assertFalse((boolean)scheme.isDefaultScheme());
        Assert.assertTrue((boolean)scheme.isDraftScheme());
        Assert.assertNotNull((Object)scheme.getLastModifiedDate());
        Assert.assertEquals((Object)ADMIN_USER, (Object)scheme.getLastModifiedUser());
        Assert.assertEquals((Object)"admin", (Object)scheme.getCurrentUser());
        SimpleWorkflow workflow = new SimpleWorkflow("Project Not Using Default Workflow Scheme Workflow", null, true, false, Arrays.asList(bug.getId(), ignored.getId(), improvment.getId(), monkey.getId(), issueType.getId(), task.getId()));
        Assert.assertEquals(Arrays.asList(workflow), scheme.getMappings());
    }

    @Test
    public void testCreateNoPermissionAnonymous() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        ParsedResponse response = ((WorkflowSchemeResource)client.anonymous()).createDraftWorkflowSchemeResponse(MKY.getKey());
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testCreateNoPermissionLoggedIn() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        ParsedResponse response = ((WorkflowSchemeResource)client.loginAs("fred")).createDraftWorkflowSchemeResponse(MKY.getKey());
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("You do not have permission to edit this workflow scheme."));
    }

    @Test
    public void testCreateNoProject() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        ParsedResponse response = client.createDraftWorkflowSchemeResponse("ASDF");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("You do not have permission to edit this project."));
    }

    @Test
    public void testDiscardDraftWorkflowScheme() {
        String projectKey = "DDWS";
        this.backdoor.project().addProject("testDiscardDraftWorkflowScheme", "DDWS", "admin");
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        SimpleWorkflowScheme oldOriginal = client.getWorkflowScheme("DDWS");
        SimpleWorkflowScheme draft = client.createDraftWorkflowScheme("DDWS");
        Assert.assertThat((Object)draft.isDraftScheme(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)draft.isDefaultScheme(), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat(draft.getMappings(), (Matcher)Matchers.equalTo(oldOriginal.getMappings()));
        SimpleWorkflowScheme newOriginal = client.discardDraftWorkflowScheme("DDWS");
        Assert.assertThat((Object)newOriginal.isDraftScheme(), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)newOriginal.isDefaultScheme(), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat(newOriginal.getMappings(), (Matcher)Matchers.equalTo(oldOriginal.getMappings()));
        Assert.assertThat((Object)client.getWorkflowScheme("DDWS"), (Matcher)Matchers.equalTo((Object)newOriginal));
    }

    @Test
    public void testDiscardNoPermissionAnonymous() {
        String projectKey = "DDWSA";
        this.backdoor.project().addProject("testDiscardNoPermissionAnonymous", "DDWSA", "admin");
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        client.createDraftWorkflowScheme("DDWSA");
        ParsedResponse response = ((WorkflowSchemeResource)client.anonymous()).discardDraftWorkflowSchemeResponse("DDWSA");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testDiscardNoPermissionLoggedIn() {
        String projectKey = "DDWSF";
        this.backdoor.project().addProject("testDiscardNoPermissionLoggedIn", "DDWSF", "admin");
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        client.createDraftWorkflowScheme("DDWSF");
        ParsedResponse response = ((WorkflowSchemeResource)client.loginAs("fred")).discardDraftWorkflowSchemeResponse("DDWSF");
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("You cannot edit the configuration of this project."));
    }

    @Test
    public void testDiscardNoProject() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        ParsedResponse response = client.discardDraftWorkflowSchemeResponse("ASDF");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("No project could be found with key 'ASDF'."));
    }

    @Test
    public void testDiscardNoDraft() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        ParsedResponse response = client.discardDraftWorkflowSchemeResponse(MKY.getKey());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("The workflow scheme does not have a draft."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetOriginalScheme() {
        WorkflowSchemeResource client = new WorkflowSchemeResource(this.environmentData);
        SimpleWorkflowScheme oldOriginal = client.getWorkflowScheme(MKY.getKey());
        try {
            SimpleWorkflowScheme draft = client.createDraftWorkflowScheme(MKY.getKey());
            SimpleWorkflowScheme newOriginal = client.getOriginalWorkflowScheme(MKY.getKey());
            Assert.assertThat((Object)newOriginal, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)draft)));
            Assert.assertThat((Object)newOriginal, (Matcher)Matchers.equalTo((Object)oldOriginal));
        }
        finally {
            client.discardDraftWorkflowScheme(MKY.getKey());
        }
    }
}

