/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.projectconfig;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.RoleResourceClient;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.rest.beans.GroupResponse;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.rest.beans.RoleActorsAddResponse;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.rest.beans.RoleMembersResponse;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.rest.beans.RolesResponse;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.rest.beans.UserResponse;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestRolesResource
extends BaseJiraFuncTest {
    private static final String SCO_PROJECT_KEY = "SCO";
    private static final String SCO_PROJECT_NAME = "Scotts";

    @Before
    public void setUpProjects() {
        this.backdoor.project().addProject(SCO_PROJECT_NAME, SCO_PROJECT_KEY, "admin");
    }

    @Test
    public void testGetRolesActors() {
        String specialistDevGroup = "specialist-developers";
        String jsNinjaUser = "jsninja";
        this.backdoor.usersAndGroups().addUser(jsNinjaUser);
        this.backdoor.usersAndGroups().addGroup(specialistDevGroup);
        this.backdoor.usersAndGroups().addUserToGroup(jsNinjaUser, specialistDevGroup);
        this.assignMembersToRole("Developers", specialistDevGroup, "fred");
        this.assignMembersToRole("Users", null, jsNinjaUser);
        RoleResourceClient client = new RoleResourceClient(this.environmentData);
        RolesResponse response = client.get(SCO_PROJECT_KEY);
        this.assertRoleHasNumberOfMembers(response, "Administrators", 1);
        this.assertRoleHasGroups(response, "Administrators", "jira-administrators");
        this.assertRoleHasUsers(response, "Administrators", new String[0]);
        this.assertRoleHasNumberOfMembers(response, "Developers", 3);
        this.assertRoleHasGroups(response, "Developers", "jira-developers", specialistDevGroup);
        this.assertRoleHasUsers(response, "Developers", "fred");
        this.assertRoleHasNumberOfMembers(response, "Users", 2);
        this.assertRoleHasGroups(response, "Users", "jira-users");
        this.assertRoleHasUsers(response, "Users", jsNinjaUser);
    }

    @Test
    public void testGetRolesActorsWithMaxResults() {
        this.setupMultipleUsers("sd", "user", 20);
        RoleResourceClient client = new RoleResourceClient(this.environmentData);
        RolesResponse response = client.get(SCO_PROJECT_KEY);
        this.assertRoleHasNumberOfMembers(response, "Users", 21);
        this.assertRoleHasNumberOfGroups(response, "Users", 1);
        this.assertRoleHasNumberOfUsers(response, "Users", 4);
    }

    @Test
    public void testSearchRolesActors() {
        this.setupMultipleUsers("user", "The User No.", 20);
        this.setupMultipleUsers("people", "The Person No.", 5);
        RoleResourceClient client = new RoleResourceClient(this.environmentData);
        RolesResponse response = client.search(SCO_PROJECT_KEY, "  use  ");
        this.assertNumberOfRolesReturned(response, 3);
        this.assertRoleHasNumberOfMembers(response, "Administrators", 0);
        this.assertRoleHasNumberOfMembers(response, "Developers", 0);
        this.assertRoleHasNumberOfMembers(response, "Users", 21);
        this.assertRoleHasNumberOfGroups(response, "Users", 1);
        this.assertRoleHasNumberOfUsers(response, "Users", 4);
    }

    @Test
    public void testSearchSpecificRoleActors() {
        this.setupMultipleUsers("user", "The User No.", 20);
        this.setupMultipleUsers("people", "The Person No.", 5);
        RoleResourceClient client = new RoleResourceClient(this.environmentData);
        RolesResponse response = client.search(SCO_PROJECT_KEY, 10000L, "  use  ");
        this.assertNumberOfRolesReturned(response, 1);
        this.assertRoleHasNumberOfMembers(response, "Users", 21);
        this.assertRoleHasNumberOfGroups(response, "Users", 1);
        this.assertRoleHasNumberOfUsers(response, "Users", 4);
    }

    @Test
    public void testSearchSpecificRoleActorsWithPagination() {
        this.setupMultipleGroups("Group Pagination", 7);
        this.setupMultipleUsers("userpagination", "User Pagination", 10);
        this.searchAndVerifyPaginatedResults("  paginat  ", 1, 5, 17, 5, 0);
        this.searchAndVerifyPaginatedResults("  paginat  ", 2, 5, 17, 2, 3);
        this.searchAndVerifyPaginatedResults("  paginat  ", 3, 5, 17, 0, 5);
        this.searchAndVerifyPaginatedResults("  paginat  ", 4, 5, 17, 0, 2);
        this.searchAndVerifyPaginatedResults("  paginat  ", 5, 5, 17, 0, 0);
    }

    @Test
    public void testSearchRolesActorsWithErrors() {
        RoleResourceClient client = new RoleResourceClient(this.environmentData);
        ParsedResponse response = client.searchResponse("BLAH", 99999L);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = client.searchResponse(SCO_PROJECT_KEY, 99999L);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = client.searchResponse(SCO_PROJECT_KEY, 10000L, 0, 5);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = client.searchResponse(SCO_PROJECT_KEY, 10000L, -1, 5);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = client.searchResponse(SCO_PROJECT_KEY, 10000L, 1, 0);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = client.searchResponse(SCO_PROJECT_KEY, 10000L, 1, -1);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = ((RoleResourceClient)client.anonymous()).searchResponse(SCO_PROJECT_KEY, 10000L);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testAddActorsToRole() {
        String testUserName = "testuser";
        String testUserKey = this.backdoor.usersAndGroups().addUser(testUserName).getUserByName(testUserName).getKey();
        String adminUserKey = this.backdoor.usersAndGroups().getUserByName("admin").getKey();
        this.assignMembersToRole("Administrators", null, testUserName);
        String[] groupsToAdd = new String[]{"jira-administrators", "jira-developers", "jira-users"};
        String[] usersToAdd = new String[]{adminUserKey, testUserKey};
        RoleResourceClient client = new RoleResourceClient(this.environmentData);
        RoleActorsAddResponse addResponse = client.addActors(SCO_PROJECT_KEY, 10002L, groupsToAdd, usersToAdd);
        Assert.assertEquals((long)2L, (long)addResponse.getNumberOfGroupsAdded());
        Assert.assertEquals((long)1L, (long)addResponse.getNumberOfUsersAdded());
        RolesResponse searchResponse = client.search(SCO_PROJECT_KEY, 10002L);
        this.assertRoleHasGroups(searchResponse, "Administrators", "jira-administrators", "jira-developers", "jira-users");
        this.assertRoleHasUsers(searchResponse, "Administrators", "admin", testUserName);
    }

    @Test
    public void testAddActorsToRoleWithErrors() {
        String adminUserKey = this.backdoor.usersAndGroups().getUserByName("admin").getKey();
        RoleResourceClient client = new RoleResourceClient(this.environmentData);
        String[] groupsToAdd = new String[]{"jira-administrators"};
        String[] usersToAdd = new String[]{adminUserKey};
        ParsedResponse response = client.addActorsResponse("BLAH", 99999L, groupsToAdd, usersToAdd);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = client.addActorsResponse(SCO_PROJECT_KEY, 99999L, groupsToAdd, usersToAdd);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = client.addActorsResponse(SCO_PROJECT_KEY, 99999L, null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = ((RoleResourceClient)client.anonymous()).addActorsResponse(SCO_PROJECT_KEY, 10000L, groupsToAdd, usersToAdd);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testEmailVisibilitySetting() {
        this.assignMembersToRole("Developers", null, "admin");
        RoleResourceClient client = new RoleResourceClient(this.environmentData);
        RolesResponse response = client.get(SCO_PROJECT_KEY);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"admin@example.com"}), this.getUserActorEmailAddresses(response));
        this.backdoor.applicationProperties().setString("jira.option.emailvisible", "hide");
        response = client.get(SCO_PROJECT_KEY);
        Assert.assertTrue((boolean)this.getUserActorEmailAddresses(response).isEmpty());
    }

    private List<String> getUserActorEmailAddresses(RolesResponse response) {
        return response.getRoles().stream().flatMap(r -> r.getUsers().stream().map(UserResponse::getEmailAddress)).filter(email -> email != null).collect(Collectors.toList());
    }

    private void assignMembersToRole(String role, String group, String user) {
        String[] groupArray = null;
        if (group != null) {
            groupArray = new String[]{group};
        }
        String[] userArray = null;
        if (user != null) {
            userArray = new String[]{user};
        }
        this.backdoor.projectRole().addActors(SCO_PROJECT_KEY, role, groupArray, userArray);
    }

    private void setupMultipleGroups(String groupNamePrefix, int numberOfGroups) {
        IntStream.range(0, numberOfGroups).forEach(i -> this.backdoor.usersAndGroups().addGroup(groupNamePrefix + i));
        String[] groupNames = (String[])IntStream.range(0, numberOfGroups).mapToObj(i -> groupNamePrefix + i).toArray(String[]::new);
        this.backdoor.projectRole().addActors(SCO_PROJECT_KEY, "Users", groupNames, null);
    }

    private void setupMultipleUsers(String userNamePrefix, String displayNamePrefix, int numberOfUsers) {
        this.backdoor.usersAndGroups().addUsers(userNamePrefix, displayNamePrefix, numberOfUsers);
        String[] userNames = (String[])IntStream.range(0, numberOfUsers).mapToObj(i -> userNamePrefix + i).toArray(String[]::new);
        this.backdoor.projectRole().addActors(SCO_PROJECT_KEY, "Users", null, userNames);
    }

    private void searchAndVerifyPaginatedResults(String query, int pageNumber, int pageSize, int expectedTotal, int expectedNumOfGroup, int expectedNumOfUser) {
        RoleResourceClient client = new RoleResourceClient(this.environmentData);
        RolesResponse response = client.search(SCO_PROJECT_KEY, 10000L, query, pageNumber, pageSize);
        this.assertRoleHasNumberOfMembers(response, "Users", expectedTotal);
        this.assertRoleHasNumberOfGroups(response, "Users", expectedNumOfGroup);
        this.assertRoleHasNumberOfUsers(response, "Users", expectedNumOfUser);
    }

    private void assertNumberOfRolesReturned(RolesResponse response, int expectedNumber) {
        Assert.assertEquals((long)expectedNumber, (long)response.getRoles().size());
    }

    private void assertRoleHasNumberOfMembers(RolesResponse response, String role, int expectedNumber) {
        Assert.assertEquals((long)expectedNumber, (long)this.getTotalMembersForRole(response, role));
    }

    private void assertRoleHasNumberOfGroups(RolesResponse response, String role, int expectedNumber) {
        Assert.assertEquals((long)expectedNumber, (long)this.getGroupsForRole(response, role).size());
    }

    private void assertRoleHasNumberOfUsers(RolesResponse response, String role, int expectedNumber) {
        Assert.assertEquals((long)expectedNumber, (long)this.getUsersForRole(response, role).size());
    }

    private void assertRoleHasGroups(RolesResponse response, String role, String ... expectedGroups) {
        Assert.assertEquals((Object)Lists.newArrayList((Object[])expectedGroups), this.getGroupsForRole(response, role));
    }

    private void assertRoleHasUsers(RolesResponse response, String role, String ... expectedUsers) {
        Assert.assertEquals((Object)Lists.newArrayList((Object[])expectedUsers), this.getUsersForRole(response, role));
    }

    private long getTotalMembersForRole(RolesResponse response, String roleName) {
        return this.getRoleMembers(response, roleName).map(RoleMembersResponse::getTotal).get();
    }

    private List<String> getGroupsForRole(RolesResponse response, String roleName) {
        return this.getRoleMembers(response, roleName).map(role -> role.getGroups().stream().map(GroupResponse::getName)).get().collect(Collectors.toList());
    }

    private List<String> getUsersForRole(RolesResponse response, String roleName) {
        return this.getRoleMembers(response, roleName).map(role -> role.getUsers().stream().map(UserResponse::getName)).get().collect(Collectors.toList());
    }

    private Optional<RoleMembersResponse> getRoleMembers(RolesResponse response, String roleName) {
        return response.getRoles().stream().filter(r -> r.getName().equals(roleName)).findFirst();
    }
}

