/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.projectconfig;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleIssueType;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleProject;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleWorkflow;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleWorkflowScheme;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreOnce(value="TestWorkflowSchemeEditorResource.xml")
@LoginAs(user="admin")
public class TestWorkflowSchemeEditorResource
extends BaseJiraFuncTest {
    private static Map<String, String> issueTypeUrls;

    @Before
    public void setUpTest() {
        this.initIssueTypeUrls();
    }

    private void initIssueTypeUrls() {
        issueTypeUrls = new HashMap<String, String>();
        for (IssueTypeControl.IssueType it : this.backdoor.issueType().getIssueTypes()) {
            issueTypeUrls.put(it.getName(), it.getIconUrl());
        }
    }

    @Test
    public void testGetWorkflowScheme() {
        EditorResource resource = new EditorResource(this.environmentData);
        ParsedResponse<SimpleWorkflowScheme> response = resource.getScheme(101010101L);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        AssignableWorkflowScheme scheme = new AssignableWorkflowScheme().setName("EmptyScheme").setDescription("This is an empty scheme.").save();
        ResponseAssertions assertions = new ResponseAssertions().setIssueTypes(IssueType.ALL).setScheme(scheme).setUser("admin").assertResponse(resource.getScheme(scheme.id));
        scheme = scheme.setDefaultWorkflow(Workflow.JIRA).save();
        assertions.assertResponse(resource.getScheme(scheme.id));
        scheme = scheme.setMapping(IssueType.BUG, Workflow.JIRA).setMapping(IssueType.IMPROVEMENT, Workflow.TWO).setMapping(IssueType.NEW_FEATURE, Workflow.TWO).save();
        assertions.assertResponse(resource.getScheme(scheme.id));
        scheme = scheme.removeDefaultWorkflow().save();
        assertions.assertResponse(resource.getScheme(scheme.id));
        Project project = new Project().setKey("TGWS").setName("testGetWorkflowScheme").create().setWorkflowScheme(scheme);
        assertions.setProjects(project);
        assertions.assertResponse(resource.getScheme(scheme.id));
        DraftWorkflowScheme draft = scheme.createDraft();
        assertions.assertResponse(resource.getScheme(scheme.id));
        draft = draft.clear().removeDefault().save();
        assertions.assertResponse(resource.getScheme(scheme.id));
        draft = draft.setDefaultWorkflow(Workflow.TWO).save();
        assertions.assertResponse(resource.getScheme(scheme.id));
        draft = draft.setMapping(IssueType.BUG, Workflow.TWO).setMapping(IssueType.IMPROVEMENT, Workflow.ONE).save();
        assertions.assertResponse(resource.getScheme(scheme.id));
        scheme = draft.discard();
        assertions.assertResponse(resource.getScheme(scheme.id));
        Project projectShared = new Project().setKey("TGWSS").setName("testGetWorkflowSchemeShared").create().setWorkflowScheme(scheme);
        assertions.setProjects(project, projectShared).assertResponse(resource.getScheme(scheme.id));
        project.delete();
        projectShared.delete();
        assertions.setProjects(new Project[0]).assertResponse(resource.getScheme(scheme.id));
        scheme.delete();
        response = resource.getScheme(scheme.getId());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testGetWorkflowSchemeNonAdmin() {
        EditorResource resource = (EditorResource)new EditorResource(this.environmentData).loginAs("fred");
        ParsedResponse<SimpleWorkflowScheme> scheme = resource.getScheme(101010101L);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)scheme.statusCode);
    }

    @Test
    public void testGetWorkflowSchemeAnonymous() {
        EditorResource resource = (EditorResource)new EditorResource(this.environmentData).anonymous();
        ParsedResponse<SimpleWorkflowScheme> scheme = resource.getScheme(101010101L);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)scheme.statusCode);
    }

    @Test
    public void testDeleteIssueTypeNonAdmin() {
        EditorResource resource = (EditorResource)new EditorResource(this.environmentData).loginAs("fred");
        ParsedResponse<SimpleWorkflowScheme> scheme = resource.deleteIssueType(101010101L, "0", "workflow");
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)scheme.statusCode);
    }

    @Test
    public void testDeleteIssueTypeAnonymous() {
        EditorResource resource = (EditorResource)new EditorResource(this.environmentData).anonymous();
        ParsedResponse<SimpleWorkflowScheme> scheme = resource.deleteIssueType(101010101L, "0", "workflow");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)scheme.statusCode);
    }

    @Test
    public void testDeleteIssueType() {
        EditorResource resource = new EditorResource(this.environmentData);
        ParsedResponse<SimpleWorkflowScheme> response = resource.deleteIssueType(101010101L, "0", "workflow");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        AssignableWorkflowScheme scheme = new AssignableWorkflowScheme().setName("testDeleteIssueType").setDescription("Scheme to test the deletion of an issue type.").save();
        ResponseAssertions assertions = new ResponseAssertions().setUser("admin").setIssueTypes(IssueType.ALL).setScheme(scheme).assertResponse(resource.deleteIssueType(scheme.id, IssueType.BUG.id, "workflow"));
        scheme.setDefaultWorkflow(Workflow.TWO).setMapping(IssueType.BUG, Workflow.ONE).save();
        assertions.assertResponse(resource.deleteIssueType(scheme.id, IssueType.BUG.id, "a workflow that doesn't exist!"));
        scheme.removeMapping(IssueType.BUG);
        assertions.assertResponse(resource.deleteIssueType(scheme.id, IssueType.BUG.id, Workflow.ONE.name));
        scheme.setMapping(IssueType.BUG, Workflow.ONE).save();
        Project project = new Project().setKey("TDIT").setName("testDeleteIssueType").create().setWorkflowScheme(scheme);
        DraftWorkflowScheme draftWorkflowScheme = scheme.localDraft();
        draftWorkflowScheme.removeMapping(IssueType.BUG);
        assertions.setProjects(project);
        response = resource.deleteIssueType(scheme.id, IssueType.BUG.id, Workflow.ONE.name);
        draftWorkflowScheme.setId(((SimpleWorkflowScheme)response.body).getId());
        draftWorkflowScheme.setUsername("admin");
        assertions.assertResponse(response);
        draftWorkflowScheme.setMapping(IssueType.BUG, Workflow.ONE).save();
        assertions.assertResponse(resource.deleteIssueType(scheme.id, IssueType.BUG.id, "workflow"));
    }

    @Test
    public void testDeleteWorkflow() {
        EditorResource resource = new EditorResource(this.environmentData);
        ParsedResponse<SimpleWorkflowScheme> response = resource.deleteIssueType(101010101L, "0", "workflow");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        AssignableWorkflowScheme scheme = new AssignableWorkflowScheme().setName("testDeleteWorkflow").setDescription("Scheme to test the deletion of a workflow.").save();
        ResponseAssertions assertions = new ResponseAssertions().setUser("admin").setIssueTypes(IssueType.ALL).setScheme(scheme).assertResponse(resource.deleteWorkflow(scheme.id, Workflow.ONE.name));
        scheme.setDefaultWorkflow(Workflow.TWO).setMapping(IssueType.BUG, Workflow.ONE).save().removeMapping(IssueType.BUG);
        assertions.assertResponse(resource.deleteWorkflow(scheme.id, Workflow.ONE.name));
        scheme.setMapping(IssueType.BUG, Workflow.ONE).save();
        Project project = new Project().setKey("TDW").setName("testDeleteWorkflow").create().setWorkflowScheme(scheme);
        DraftWorkflowScheme draftWorkflowScheme = scheme.localDraft();
        draftWorkflowScheme.removeMapping(IssueType.BUG);
        assertions.setProjects(project);
        response = resource.deleteIssueType(scheme.id, IssueType.BUG.id, Workflow.ONE.name);
        draftWorkflowScheme.setId(((SimpleWorkflowScheme)response.body).getId());
        draftWorkflowScheme.setUsername("admin");
        assertions.assertResponse(response);
        draftWorkflowScheme.setMapping(IssueType.BUG, Workflow.ONE).save().removeMapping(IssueType.BUG);
        assertions.assertResponse(resource.deleteIssueType(scheme.id, IssueType.BUG.id, Workflow.ONE.name));
    }

    @Test
    public void testDeleteWorkflowReassignsDefaultWithoutSpecifyingOne() {
        EditorResource resource = new EditorResource(this.environmentData);
        AssignableWorkflowScheme scheme = new AssignableWorkflowScheme().setName("testDeleteDefaultWithoutSpecifyingDefault").setDefaultWorkflow(Workflow.TWO).setMapping(IssueType.BUG, Workflow.ONE).setMapping(IssueType.IMPROVEMENT, Workflow.JIRA).save();
        ResponseAssertions assertions = new ResponseAssertions().setIssueTypes(IssueType.ALL).setScheme(scheme).setUser("admin");
        scheme.setDefaultWorkflow(Workflow.JIRA);
        assertions.assertResponse(resource.deleteWorkflow(scheme.id, Workflow.TWO.name));
    }

    @Test
    public void testDeleteWorkflowReassignsDefaultBySpecifyingOne() {
        EditorResource resource = new EditorResource(this.environmentData);
        AssignableWorkflowScheme scheme = new AssignableWorkflowScheme().setName("testDeleteDefaultBySpecifyingDefault").setDefaultWorkflow(Workflow.TWO).setMapping(IssueType.BUG, Workflow.ONE).setMapping(IssueType.IMPROVEMENT, Workflow.JIRA).save();
        ResponseAssertions assertions = new ResponseAssertions().setIssueTypes(IssueType.ALL).setScheme(scheme).setUser("admin");
        scheme.setDefaultWorkflow(Workflow.ONE);
        assertions.assertResponse(resource.deleteWorkflow(scheme.id, Workflow.TWO.name, Workflow.ONE.name));
        scheme.removeMapping(IssueType.BUG).setDefaultWorkflow(Workflow.JIRA);
        assertions.assertResponse(resource.deleteWorkflow(scheme.id, Workflow.ONE.name, Workflow.ONE.name));
    }

    @Test
    public void testDeleteWorkflowNonAdmin() {
        EditorResource resource = (EditorResource)new EditorResource(this.environmentData).loginAs("fred");
        ParsedResponse<SimpleWorkflowScheme> scheme = resource.deleteWorkflow(101010101L, "0");
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)scheme.statusCode);
    }

    @Test
    public void testDeleteWorkflowAnonymous() {
        EditorResource resource = (EditorResource)new EditorResource(this.environmentData).anonymous();
        ParsedResponse<SimpleWorkflowScheme> scheme = resource.deleteWorkflow(101010101L, "0");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)scheme.statusCode);
    }

    @Test
    public void testAssignIssueTypes() {
        EditorResource resource = new EditorResource(this.environmentData);
        AssignableWorkflowScheme scheme = new AssignableWorkflowScheme().setName("testAssignIssueTypes").setDescription("Scheme to test the assignment of issue types.").save();
        ResponseAssertions assertions = new ResponseAssertions().setIssueTypes(IssueType.ALL).setScheme(scheme).setUser("admin");
        ParsedResponse<SimpleWorkflowScheme> response = resource.assignIssueTypes(101010101L, "workflow", Arrays.asList("0"), false);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = resource.assignIssueTypes(scheme.id, "this workfow doesn't exist", Arrays.asList(IssueType.BUG.id), false);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = resource.assignIssueTypes(scheme.id, Workflow.ONE.name, Arrays.asList("100"), false);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        scheme.setMapping(IssueType.BUG, Workflow.ONE);
        assertions.assertResponse(resource.assignIssueTypes(scheme.id, Workflow.ONE.name, Arrays.asList(IssueType.BUG.id), false));
        scheme.setMapping(IssueType.IMPROVEMENT, Workflow.ONE);
        assertions.assertResponse(resource.assignIssueTypes(scheme.id, Workflow.ONE.name, Arrays.asList(IssueType.IMPROVEMENT.id), false));
        scheme.setMapping(IssueType.BUG, Workflow.TWO);
        assertions.assertResponse(resource.assignIssueTypes(scheme.id, Workflow.TWO.name, Arrays.asList(IssueType.BUG.id), false));
        scheme.setDefaultWorkflow(Workflow.TWO);
        assertions.assertResponse(resource.assignIssueTypes(scheme.id, Workflow.TWO.name, null, true));
        scheme.setMapping(IssueType.NEW_FEATURE, Workflow.ONE).setDefaultWorkflow(Workflow.ONE);
        assertions.assertResponse(resource.assignIssueTypes(scheme.id, Workflow.ONE.name, Arrays.asList(IssueType.NEW_FEATURE.id), true));
        Project project = new Project().setKey("TAIT").setName("testAssignIssueTypes").create().setWorkflowScheme(scheme);
        DraftWorkflowScheme draftWorkflowScheme = scheme.localDraft().setMapping(IssueType.TASK, Workflow.TWO);
        assertions.setProjects(project);
        response = resource.assignIssueTypes(scheme.id, Workflow.TWO.name, Arrays.asList(IssueType.TASK.id), false);
        draftWorkflowScheme.setId(((SimpleWorkflowScheme)response.body).getId());
        draftWorkflowScheme.setUsername("admin");
        assertions.assertResponse(response);
        draftWorkflowScheme.setMapping(IssueType.BUG, Workflow.ONE).setMapping(IssueType.TASK, Workflow.ONE);
        assertions.assertResponse(resource.assignIssueTypes(scheme.id, Workflow.ONE.name, Arrays.asList(IssueType.BUG.id, IssueType.TASK.id), false));
    }

    @Test
    public void testAssignIssueTypesNonAdmin() {
        EditorResource resource = (EditorResource)new EditorResource(this.environmentData).loginAs("fred");
        ParsedResponse<SimpleWorkflowScheme> scheme = resource.assignIssueTypes(101010101L, "workflow", Arrays.asList("0"), false);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)scheme.statusCode);
    }

    @Test
    public void testAssignIssueTypesAnonymous() {
        EditorResource resource = (EditorResource)new EditorResource(this.environmentData).anonymous();
        ParsedResponse<SimpleWorkflowScheme> scheme = resource.assignIssueTypes(101010101L, "workflow", Arrays.asList("0"), false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)scheme.statusCode);
    }

    @Test
    public void testDiscardDraft() {
        EditorResource resource = new EditorResource(this.environmentData);
        AssignableWorkflowScheme scheme = new AssignableWorkflowScheme().setName("testDiscardDraft").setDescription("Scheme to test the assignment of issue types.").save();
        ResponseAssertions assertions = new ResponseAssertions().setIssueTypes(IssueType.ALL).setScheme(scheme).setUser("admin");
        ParsedResponse<SimpleWorkflowScheme> response = resource.discardDraft(101010101L);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        assertions.assertResponse(resource.discardDraft(scheme.getId()));
        Project project = new Project().setKey("TDD").setName("testDiscardDraft").create().setWorkflowScheme(scheme);
        DraftWorkflowScheme draftWorkflowScheme = scheme.createDraft().setMapping(IssueType.TASK, Workflow.TWO).setUsername("admin").save();
        assertions.setProjects(project).assertResponse(resource.getScheme(scheme.getId()));
        draftWorkflowScheme.discardLocal();
        assertions.assertResponse(resource.discardDraft(scheme.getId()));
    }

    @Test
    public void testDiscardDraftNonAdmin() {
        EditorResource resource = (EditorResource)new EditorResource(this.environmentData).loginAs("fred");
        ParsedResponse<SimpleWorkflowScheme> scheme = resource.discardDraft(101010101L);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)scheme.statusCode);
    }

    @Test
    public void testDiscardDraftAnonymous() {
        EditorResource resource = (EditorResource)new EditorResource(this.environmentData).anonymous();
        ParsedResponse<SimpleWorkflowScheme> scheme = resource.discardDraft(101010101L);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)scheme.statusCode);
    }

    @Test
    public void testUpdateName() {
        AssignableWorkflowScheme scheme = new AssignableWorkflowScheme().setName("testUpdateName").save();
        EditorResource resource = new EditorResource(this.environmentData);
        ParsedResponse<SimpleWorkflowScheme> response = ((EditorResource)resource.anonymous()).updateName(10000L, "workflow scheme");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((EditorResource)resource.loginAs("fred")).updateName(10000L, "workflow scheme");
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        response = ((EditorResource)resource.loginAs("admin")).updateName(12345L, "workflow scheme");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = resource.updateName(scheme.id, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = resource.updateName(scheme.id, "");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        ResponseAssertions assertions = new ResponseAssertions().setIssueTypes(IssueType.ALL).setScheme(scheme).setUser("admin");
        scheme.setName("new scheme name");
        assertions.assertResponse(resource.updateName(scheme.id, "new scheme name"));
    }

    @Test
    public void testUpdateDescription() {
        AssignableWorkflowScheme scheme = new AssignableWorkflowScheme().setName("testUpdateDescription").setDescription("project for testing the update of descriptions").save();
        EditorResource resource = new EditorResource(this.environmentData);
        ParsedResponse<SimpleWorkflowScheme> response = ((EditorResource)resource.anonymous()).updateDescription(10000L, "workflow scheme");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((EditorResource)resource.loginAs("fred")).updateDescription(10000L, "workflow scheme");
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        response = ((EditorResource)resource.loginAs("admin")).updateDescription(12345L, "workflow scheme");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        ResponseAssertions assertions = new ResponseAssertions().setIssueTypes(IssueType.ALL).setScheme(scheme).setUser("admin");
        scheme.setDescription(null);
        assertions.assertResponse(resource.updateDescription(scheme.id, null));
        assertions.assertResponse(resource.updateDescription(scheme.id, ""));
        scheme.setDescription("new scheme name");
        assertions.assertResponse(resource.updateDescription(scheme.id, "new scheme name"));
    }

    public static class RemoveWorkflowRequest {
        @JsonProperty
        private String workflow;
        @JsonProperty
        private String nextDefaultWorkflow;

        public RemoveWorkflowRequest(String workflow) {
            this(workflow, null);
        }

        public RemoveWorkflowRequest(String workflow, String nextDefaultWorkflow) {
            this.workflow = workflow;
            this.nextDefaultWorkflow = nextDefaultWorkflow;
        }
    }

    public static class WorkflowSchemeRequest {
        @JsonProperty
        private final String workflow;
        @JsonProperty
        private final Collection<String> issueTypes;
        @JsonProperty
        private final boolean defaultWorkflow;

        public WorkflowSchemeRequest(String workflow, Collection<String> issueTypes, boolean defaultWorkflow) {
            this.workflow = workflow;
            this.issueTypes = issueTypes;
            this.defaultWorkflow = defaultWorkflow;
        }

        public WorkflowSchemeRequest(String workflow, Collection<String> issueTypes) {
            this(workflow, issueTypes, false);
        }

        public WorkflowSchemeRequest(String workflow) {
            this(workflow, null, false);
        }
    }

    public class EditorResource
    extends RestApiClient<EditorResource> {
        private final String root;

        public EditorResource(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
            super((JIRAEnvironmentData)environmentData);
            this.root = environmentData.getBaseUrl().toExternalForm();
        }

        protected WebTarget createResource() {
            return this.resourceRoot(this.root).path("rest").path("globalconfig").path("latest").path("workflowschemeeditor");
        }

        public WebTarget createResource(long id) {
            return this.createResource().path(String.valueOf(id));
        }

        public ParsedResponse<SimpleWorkflowScheme> getScheme(long id) {
            return this.toResponse(() -> (Response)this.createResource(id).request().get(Response.class), SimpleWorkflowScheme.class);
        }

        public ParsedResponse<SimpleWorkflowScheme> deleteIssueType(long id, String issueTypeId, String workflow) {
            return this.toResponse(() -> (Response)this.createResource(id).path("issuetype").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).method("DELETE", Entity.json((Object)new WorkflowSchemeRequest(workflow, Arrays.asList(issueTypeId))), Response.class), SimpleWorkflowScheme.class);
        }

        public ParsedResponse<SimpleWorkflowScheme> deleteWorkflow(long id, String workflow) {
            return this.toResponse(() -> (Response)this.createResource(id).path("workflow").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).method("DELETE", Entity.json((Object)new RemoveWorkflowRequest(workflow)), Response.class), SimpleWorkflowScheme.class);
        }

        public ParsedResponse<SimpleWorkflowScheme> deleteWorkflow(long id, String workflow, String nextDefaultWorkflow) {
            return this.toResponse(() -> (Response)this.createResource(id).path("workflow").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).method("DELETE", Entity.json((Object)new RemoveWorkflowRequest(workflow, nextDefaultWorkflow)), Response.class), SimpleWorkflowScheme.class);
        }

        public ParsedResponse<SimpleWorkflowScheme> assignIssueTypes(long id, String workflow, Collection<String> issueTypes, boolean defaultWorkflow) {
            return this.toResponse(() -> (Response)this.createResource(id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new WorkflowSchemeRequest(workflow, issueTypes, defaultWorkflow)), Response.class), SimpleWorkflowScheme.class);
        }

        public ParsedResponse<SimpleWorkflowScheme> discardDraft(long id) {
            return this.toResponse(() -> (Response)this.createResource(id).path("draft").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class), SimpleWorkflowScheme.class);
        }

        public ParsedResponse<SimpleWorkflowScheme> updateName(long id, String name) {
            return this.toResponse(() -> (Response)this.createResource(id).path("name").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)name), Response.class), SimpleWorkflowScheme.class);
        }

        public ParsedResponse<SimpleWorkflowScheme> updateDescription(long id, String description) {
            return this.toResponse(() -> (Response)this.createResource(id).path("description").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)description), Response.class), SimpleWorkflowScheme.class);
        }
    }

    public static class IssueType {
        private static IssueType BUG = new IssueType(1L, "Bug", "A problem which impairs or prevents the functions of the product.");
        private static IssueType IMPROVEMENT = new IssueType(4L, "Improvement", "An improvement or enhancement to an existing feature or task.");
        private static IssueType NEW_FEATURE = new IssueType(2L, "New Feature", "A new feature of the product, which has yet to be developed.");
        private static IssueType TASK = new IssueType(3L, "Task", "A task that needs to be done.");
        private static List<IssueType> ALL = ImmutableList.of((Object)BUG, (Object)IMPROVEMENT, (Object)NEW_FEATURE, (Object)TASK);
        private final String id;
        private final String name;
        private final String description;

        private IssueType(long id, String name, String description) {
            this.id = String.valueOf(id);
            this.name = name;
            this.description = description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssueType issueType = (IssueType)o;
            return this.id.equals(issueType.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public static IssueType fromId(String id) {
            if (id == null) {
                return null;
            }
            for (IssueType issueType : ALL) {
                if (!issueType.id.equals(id)) continue;
                return issueType;
            }
            throw new RuntimeException("Unable to find an issue type with id '" + id + "'");
        }

        public static IssueType fromName(String id) {
            if (id == null) {
                return null;
            }
            for (IssueType issueType : ALL) {
                if (!issueType.name.equals(id)) continue;
                return issueType;
            }
            throw new RuntimeException("Unable to find an issue type with id '" + id + "'");
        }

        public void assertIssueType(SimpleIssueType actualIssueType) {
            MatcherAssert.assertThat((Object)actualIssueType.getName(), (Matcher)Matchers.equalTo((Object)this.name));
            MatcherAssert.assertThat((Object)actualIssueType.getDescription(), (Matcher)Matchers.equalTo((Object)this.description));
            MatcherAssert.assertThat((Object)actualIssueType.getId(), (Matcher)Matchers.equalTo((Object)this.id));
            MatcherAssert.assertThat((Object)actualIssueType.getIconUrl(), (Matcher)Matchers.endsWith((String)((String)issueTypeUrls.get(this.name))));
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Workflow {
        private static Workflow JIRA = new Workflow("jira", "Jira Workflow (jira)", "The default Jira workflow.");
        private static Workflow ONE = new Workflow("One", "Description for One");
        private static Workflow TWO = new Workflow("Two", null);
        private static List<Workflow> ALL = ImmutableList.of((Object)JIRA, (Object)ONE, (Object)TWO);
        private final String name;
        private final String displayName;
        private final String description;

        public Workflow(String name, String description) {
            this(name, name, description);
        }

        public Workflow(String name, String displayName, String description) {
            this.name = name;
            this.displayName = displayName;
            this.description = description;
        }

        public static Workflow fromName(String workflow) {
            if (workflow == null) {
                return null;
            }
            for (Workflow wf : ALL) {
                if (!wf.name.equals(workflow)) continue;
                return wf;
            }
            throw new RuntimeException("Workflow of name '" + workflow + "' not found.");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Workflow workflow = (Workflow)o;
            return this.name.equals(workflow.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    public class AssignableWorkflowScheme {
        private Long id;
        private String name;
        private String description;
        private WorkflowSchemeMappings mappings;
        private DraftWorkflowScheme draft;

        public AssignableWorkflowScheme() {
            this.mappings = new WorkflowSchemeMappings();
        }

        public String getDescription() {
            return this.description;
        }

        public AssignableWorkflowScheme setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public AssignableWorkflowScheme setName(String name) {
            this.name = name;
            return this;
        }

        public Map<IssueType, Workflow> getMappings() {
            return this.mappings.getMappings();
        }

        public AssignableWorkflowScheme setMappings(Map<IssueType, Workflow> mappings) {
            this.mappings.setMappings(mappings);
            return this;
        }

        public AssignableWorkflowScheme setMapping(IssueType type, Workflow workflow) {
            this.mappings.setMapping(type, workflow);
            return this;
        }

        public AssignableWorkflowScheme removeMapping(IssueType type) {
            this.mappings.removeMapping(type);
            return this;
        }

        public AssignableWorkflowScheme clear() {
            this.mappings.clear();
            return this;
        }

        public Workflow getDefaultWorkflow() {
            return this.mappings.defaultWorkflow;
        }

        public AssignableWorkflowScheme setDefaultWorkflow(Workflow defaultWorkflow) {
            this.mappings.setDefaultWorkflow(defaultWorkflow);
            return this;
        }

        public AssignableWorkflowScheme removeDefaultWorkflow() {
            this.mappings.removeDefaultWorkflow();
            return this;
        }

        private AssignableWorkflowScheme setId(Long id) {
            this.id = id;
            return this;
        }

        public AssignableWorkflowScheme save() {
            if (this.id == null) {
                this.setWorkflowSchemeData(TestWorkflowSchemeEditorResource.this.backdoor.workflowSchemes().createScheme(this.asWorkflowSchemeData()));
            } else {
                this.setWorkflowSchemeData(TestWorkflowSchemeEditorResource.this.backdoor.workflowSchemes().updateScheme(this.asWorkflowSchemeData()));
            }
            return this;
        }

        public AssignableWorkflowScheme setWorkflowSchemeData(WorkflowSchemeData data) {
            this.setId(data.getId());
            this.setName(data.getName()).setDescription(data.getDescription());
            this.mappings.setMappingsFrom(data);
            return this;
        }

        public WorkflowSchemeData asWorkflowSchemeData() {
            WorkflowSchemeData data = new WorkflowSchemeData();
            data.setName(this.name).setDescription(this.description).setId(this.id);
            return this.mappings.addMappingsTo(data);
        }

        public AssignableWorkflowScheme assertSimpleScheme(SimpleWorkflowScheme actualScheme) {
            MatcherAssert.assertThat((Object)actualScheme.getName(), (Matcher)Matchers.equalTo((Object)this.name));
            MatcherAssert.assertThat((Object)actualScheme.getDescription(), (Matcher)Matchers.equalTo((Object)this.description));
            MatcherAssert.assertThat((Object)actualScheme.isDraftScheme(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)actualScheme.isDefaultScheme(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)actualScheme.getLastModifiedDate(), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)actualScheme.getLastModifiedUser(), (Matcher)Matchers.nullValue());
            this.mappings.assertMappings(actualScheme);
            return this;
        }

        public Long getId() {
            return this.id;
        }

        public DraftWorkflowScheme createDraft() {
            WorkflowSchemeData data = TestWorkflowSchemeEditorResource.this.backdoor.workflowSchemes().createDraft(this.asWorkflowSchemeData());
            this.draft = new DraftWorkflowScheme(this).setWorkflowSchemeData(data);
            return this.draft;
        }

        public DraftWorkflowScheme localDraft() {
            this.draft = new DraftWorkflowScheme(this);
            return this.draft;
        }

        public void delete() {
            TestWorkflowSchemeEditorResource.this.backdoor.workflowSchemes().deleteScheme(this.id.longValue());
        }
    }

    public class DraftWorkflowScheme {
        private Long id;
        private String username;
        private WorkflowSchemeMappings mappings;
        private AssignableWorkflowScheme parent;

        public DraftWorkflowScheme(AssignableWorkflowScheme parent) {
            this.mappings = new WorkflowSchemeMappings();
            this.parent = parent;
            this.mappings = new WorkflowSchemeMappings(parent.mappings);
        }

        public DraftWorkflowScheme setWorkflowSchemeData(WorkflowSchemeData data) {
            this.setId(data.getId());
            this.setUsername(data.getLastModifiedUser());
            this.mappings.setMappingsFrom(data);
            return this;
        }

        public DraftWorkflowScheme setId(Long id) {
            this.id = id;
            return this;
        }

        public DraftWorkflowScheme setUsername(String username) {
            this.username = username;
            return this;
        }

        public DraftWorkflowScheme assertSimpleScheme(SimpleWorkflowScheme actualScheme) {
            MatcherAssert.assertThat((Object)actualScheme.getId(), (Matcher)Matchers.equalTo((Object)this.id));
            MatcherAssert.assertThat((Object)actualScheme.getName(), (Matcher)Matchers.equalTo((Object)this.parent.name));
            MatcherAssert.assertThat((Object)actualScheme.getDescription(), (Matcher)Matchers.equalTo((Object)this.parent.description));
            MatcherAssert.assertThat((Object)actualScheme.getLastModifiedUser().getName(), (Matcher)Matchers.equalTo((Object)this.username));
            MatcherAssert.assertThat((Object)actualScheme.isDraftScheme(), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)actualScheme.isDefaultScheme(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)actualScheme.getLastModifiedDate(), (Matcher)Matchers.notNullValue());
            this.mappings.assertMappings(actualScheme);
            return this;
        }

        public DraftWorkflowScheme clear() {
            this.mappings.clear();
            return this;
        }

        public DraftWorkflowScheme removeDefault() {
            this.mappings.removeDefaultWorkflow();
            return this;
        }

        public DraftWorkflowScheme setDefaultWorkflow(Workflow workflow) {
            this.mappings.setDefaultWorkflow(workflow);
            return this;
        }

        public DraftWorkflowScheme setMapping(IssueType issueType, Workflow workflow) {
            this.mappings.setMapping(issueType, workflow);
            return this;
        }

        public AssignableWorkflowScheme discard() {
            TestWorkflowSchemeEditorResource.this.backdoor.workflowSchemes().discardDraftScheme(this.parent.id.longValue());
            return this.discardLocal();
        }

        public DraftWorkflowScheme save() {
            WorkflowSchemeData data = new WorkflowSchemeData();
            this.mappings.addMappingsTo(data);
            this.setWorkflowSchemeData(TestWorkflowSchemeEditorResource.this.backdoor.workflowSchemes().updateDraftScheme(this.parent.id.longValue(), data));
            return this;
        }

        public DraftWorkflowScheme removeMapping(IssueType issueType) {
            this.mappings.removeMapping(issueType);
            return this;
        }

        public AssignableWorkflowScheme discardLocal() {
            this.parent.draft = null;
            return this.parent;
        }
    }

    private class WorkflowSchemeMappings {
        private Workflow defaultWorkflow;
        private Map<IssueType, Workflow> mappings;

        public WorkflowSchemeMappings() {
            this.mappings = Maps.newHashMap();
        }

        public WorkflowSchemeMappings(WorkflowSchemeMappings source) {
            this.mappings = Maps.newHashMap(source.mappings);
            this.defaultWorkflow = source.defaultWorkflow;
        }

        public Map<IssueType, Workflow> getMappings() {
            return this.mappings;
        }

        public WorkflowSchemeMappings setMappings(Map<IssueType, Workflow> mappings) {
            this.mappings = Maps.newHashMap(mappings);
            return this;
        }

        public WorkflowSchemeMappings setMapping(IssueType type, Workflow workflow) {
            this.mappings.put(type, workflow);
            return this;
        }

        public WorkflowSchemeMappings removeMapping(IssueType type) {
            this.mappings.remove(type);
            return this;
        }

        public WorkflowSchemeMappings clear() {
            this.mappings.clear();
            return this;
        }

        public Workflow getDefaultWorkflow() {
            return this.defaultWorkflow;
        }

        public WorkflowSchemeMappings setDefaultWorkflow(Workflow defaultWorkflow) {
            this.defaultWorkflow = defaultWorkflow;
            return this;
        }

        public WorkflowSchemeMappings removeDefaultWorkflow() {
            this.defaultWorkflow = null;
            return this;
        }

        public WorkflowSchemeData addMappingsTo(WorkflowSchemeData data) {
            if (this.defaultWorkflow != null) {
                data.setDefaultWorkflow(this.defaultWorkflow.name);
            }
            for (Map.Entry<IssueType, Workflow> entry : this.mappings.entrySet()) {
                data.setMapping(entry.getKey().id, entry.getValue().name);
            }
            return data;
        }

        public WorkflowSchemeMappings setMappingsFrom(WorkflowSchemeData data) {
            this.defaultWorkflow = Workflow.fromName(data.getDefaultWorkflow());
            if (this.defaultWorkflow == null) {
                this.defaultWorkflow = Workflow.JIRA;
            }
            this.mappings.clear();
            for (Map.Entry entry : data.getMappings().entrySet()) {
                this.mappings.put(IssueType.fromName((String)entry.getKey()), Workflow.fromName((String)entry.getValue()));
            }
            return this;
        }

        public WorkflowSchemeMappings assertMappings(SimpleWorkflowScheme actualScheme) {
            return this.assertMappings(actualScheme.getMappings());
        }

        public WorkflowSchemeMappings assertOriginalMappings(SimpleWorkflowScheme actualScheme) {
            return this.assertMappings(actualScheme.getOriginalMappings());
        }

        private WorkflowSchemeMappings assertMappings(List<SimpleWorkflow> input) {
            Workflow defaultWorkflow = null;
            HashMap calculatedScheme = Maps.newHashMap();
            for (SimpleWorkflow mapping : input) {
                Workflow workflow = Workflow.fromName(mapping.getName());
                if (mapping.isDefaultWorkflow()) {
                    if (defaultWorkflow != null) {
                        Assert.fail((String)("Workflow '" + defaultWorkflow + "' and '" + workflow + "' both reported as the default."));
                    } else {
                        defaultWorkflow = workflow;
                    }
                }
                for (String issueType : mapping.getIssueTypes()) {
                    IssueType type = IssueType.fromId(issueType);
                    Workflow currentWorkflow = (Workflow)calculatedScheme.get(type);
                    if (currentWorkflow != null) {
                        Assert.fail((String)("Response has two mappings for the issue type '" + type + "'."));
                    }
                    calculatedScheme.put(type, workflow);
                }
            }
            if (defaultWorkflow == null) {
                defaultWorkflow = Workflow.JIRA;
            }
            MatcherAssert.assertThat((Object)calculatedScheme, (Matcher)Matchers.equalTo(this.mappings));
            MatcherAssert.assertThat((Object)defaultWorkflow, (Matcher)Matchers.equalTo((Object)this.defaultWorkflow));
            return this;
        }
    }

    public class Project {
        private String name;
        private String key;
        private Long id;

        public Project setName(String name) {
            this.name = name;
            return this;
        }

        public Project setKey(String key) {
            this.key = key;
            return this;
        }

        public Project setId(Long id) {
            this.id = id;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public Long getId() {
            return this.id;
        }

        public Project create() {
            this.id = TestWorkflowSchemeEditorResource.this.backdoor.project().addProject(this.name, this.key, "admin");
            return this;
        }

        public Project setWorkflowScheme(AssignableWorkflowScheme scheme) {
            TestWorkflowSchemeEditorResource.this.backdoor.project().setWorkflowScheme(this.key, scheme.getId());
            return this;
        }

        public Project assertProject(SimpleProject actualProject) {
            MatcherAssert.assertThat((Object)actualProject.getId(), (Matcher)Matchers.equalTo((Object)actualProject.getId()));
            MatcherAssert.assertThat((Object)actualProject.getName(), (Matcher)Matchers.equalTo((Object)actualProject.getName()));
            MatcherAssert.assertThat((Object)actualProject.getKey(), (Matcher)Matchers.equalTo((Object)actualProject.getKey()));
            MatcherAssert.assertThat((Object)actualProject.getUrl(), (Matcher)Matchers.nullValue());
            return this;
        }

        public void delete() {
            TestWorkflowSchemeEditorResource.this.backdoor.project().deleteProject(this.key);
        }
    }

    public static class ResponseAssertions {
        private List<IssueType> issueTypes = Lists.newArrayList();
        private AssignableWorkflowScheme scheme;
        private List<Project> projects = Lists.newArrayList();
        private String user;

        public ResponseAssertions setIssueTypes(List<IssueType> types) {
            this.issueTypes = types;
            return this;
        }

        public ResponseAssertions setScheme(AssignableWorkflowScheme scheme) {
            this.scheme = scheme;
            return this;
        }

        public ResponseAssertions setProjects(Project ... projects) {
            this.projects = Lists.newArrayList(Arrays.asList(projects));
            return this;
        }

        public ResponseAssertions setUser(String user) {
            this.user = user;
            return this;
        }

        public ResponseAssertions assertResponse(ParsedResponse<SimpleWorkflowScheme> response) {
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
            return this.assertResponse((SimpleWorkflowScheme)response.body);
        }

        public ResponseAssertions assertResponse(SimpleWorkflowScheme workflow) {
            if (this.scheme.draft != null) {
                this.scheme.draft.assertSimpleScheme(workflow);
                this.scheme.mappings.assertOriginalMappings(workflow);
            } else {
                this.scheme.assertSimpleScheme(workflow);
            }
            MatcherAssert.assertThat((Object)workflow.getCurrentUser(), (Matcher)Matchers.equalTo((Object)this.user));
            MatcherAssert.assertThat((Object)workflow.getIssueTypes().size(), (Matcher)Matchers.equalTo((Object)this.issueTypes.size()));
            Iterator<SimpleIssueType> actualIterator = workflow.getIssueTypes().iterator();
            for (IssueType issueType : this.issueTypes) {
                issueType.assertIssueType(actualIterator.next());
            }
            MatcherAssert.assertThat((Object)workflow.getShared().getSharedWithProjects().size(), (Matcher)Matchers.equalTo((Object)this.projects.size()));
            Iterator<SimpleProject> actualProjectIterator = workflow.getShared().getSharedWithProjects().iterator();
            for (Project project : this.projects) {
                project.assertProject(actualProjectIterator.next());
            }
            return this;
        }
    }
}

