/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.projectconfig.framework;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.rest.beans.RoleActorsAddResponse;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.rest.beans.RolesResponse;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class RoleResourceClient
extends RestApiClient<RoleResourceClient> {
    private final String root;

    public RoleResourceClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.root = environmentData.getBaseUrl().toExternalForm();
    }

    protected WebTarget createResource() {
        return this.resourceRoot(this.root).path("rest").path("projectconfig").path("latest").path("roles");
    }

    protected WebTarget createResource(String projectKey) {
        return this.createResource().path(projectKey);
    }

    public RolesResponse get(String projectKey) {
        return (RolesResponse)this.createResource(projectKey).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(RolesResponse.class);
    }

    public RolesResponse search(String projectKey, String query) {
        return (RolesResponse)this.createResource(projectKey).queryParam("query", new Object[]{query}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(RolesResponse.class);
    }

    public RolesResponse search(String projectKey, long roleId) {
        return (RolesResponse)this.createResource(projectKey).queryParam("roleId", new Object[]{String.valueOf(roleId)}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(RolesResponse.class);
    }

    public RolesResponse search(String projectKey, long roleId, String query) {
        return (RolesResponse)this.createResource(projectKey).queryParam("roleId", new Object[]{String.valueOf(roleId)}).queryParam("query", new Object[]{query}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(RolesResponse.class);
    }

    public RolesResponse search(String projectKey, long roleId, String query, int pageNumber, int pageSize) {
        return (RolesResponse)this.createResource(projectKey).queryParam("roleId", new Object[]{String.valueOf(roleId)}).queryParam("query", new Object[]{query}).queryParam("pageNumber", new Object[]{String.valueOf(pageNumber)}).queryParam("pageSize", new Object[]{String.valueOf(pageSize)}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(RolesResponse.class);
    }

    public RoleActorsAddResponse addActors(String projectKey, long roleId, String[] groups, String[] userKeys) {
        HashMap actors = Maps.newHashMap();
        actors.put("groups", groups);
        actors.put("users", userKeys);
        return (RoleActorsAddResponse)this.createResource(projectKey).path(String.valueOf(roleId)).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)actors), RoleActorsAddResponse.class);
    }

    public ParsedResponse searchResponse(String projectKey, long roleId) {
        return this.toResponse(() -> (Response)this.createResource(projectKey).queryParam("roleId", new Object[]{String.valueOf(roleId)}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Response.class));
    }

    public ParsedResponse searchResponse(String projectKey, long roleId, int pageNumber, int pageSize) {
        return this.toResponse(() -> (Response)this.createResource(projectKey).queryParam("roleId", new Object[]{String.valueOf(roleId)}).queryParam("pageNumber", new Object[]{String.valueOf(pageNumber)}).queryParam("pageSize", new Object[]{String.valueOf(pageSize)}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Response.class));
    }

    public ParsedResponse addActorsResponse(String projectKey, long roleId, String[] groups, String[] userKeys) {
        HashMap actors = Maps.newHashMap();
        actors.put("groups", groups);
        actors.put("users", userKeys);
        return this.toResponse(() -> (Response)this.createResource(projectKey).path(String.valueOf(roleId)).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)actors), Response.class));
    }
}

