/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.projectconfig.framework;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class SimpleUser {
    @JsonProperty
    private String name;
    @JsonProperty
    private String displayName;
    @JsonProperty
    private Map<String, String> avatarUrls;
    @JsonProperty
    private boolean active;

    public SimpleUser(String displayName, String name, String avatarUrl, boolean active) {
        this.displayName = displayName;
        this.name = name;
        this.avatarUrls = Collections.singletonMap("16x16", avatarUrl);
        this.active = active;
    }

    public SimpleUser() {
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getAvatarUrls() {
        return this.avatarUrls;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleUser that = (SimpleUser)o;
        if (this.active != that.active) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.active ? 1 : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

