/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.projectconfig.framework;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class SimpleWorkflow {
    @JsonProperty
    private String name;
    @JsonProperty
    private String displayName;
    @JsonProperty
    private String description;
    @JsonProperty(value="default")
    private boolean defaultWorkflow;
    @JsonProperty
    private boolean system;
    @JsonProperty
    private List<String> issueTypes;
    @JsonProperty
    private boolean jiraDefault;

    public SimpleWorkflow() {
    }

    public SimpleWorkflow(String name, String description, boolean defaultWorkflow, boolean system, List<String> issueTypes) {
        this(name, description, defaultWorkflow, system, issueTypes, false);
    }

    public SimpleWorkflow(String name, String description, boolean defaultWorkflow, boolean system, List<String> issueTypes, boolean jiraDefault) {
        this.name = name;
        this.displayName = jiraDefault ? "Jira Workflow (jira)" : name;
        this.description = description;
        this.defaultWorkflow = defaultWorkflow;
        this.system = system;
        this.issueTypes = issueTypes;
        this.jiraDefault = jiraDefault;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleWorkflow that = (SimpleWorkflow)o;
        if (this.defaultWorkflow != that.defaultWorkflow) {
            return false;
        }
        if (this.jiraDefault != that.jiraDefault) {
            return false;
        }
        if (this.system != that.system) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        if (this.issueTypes != null ? !this.issueTypes.equals(that.issueTypes) : that.issueTypes != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.defaultWorkflow ? 1 : 0);
        result = 31 * result + (this.system ? 1 : 0);
        result = 31 * result + (this.issueTypes != null ? this.issueTypes.hashCode() : 0);
        result = 31 * result + (this.jiraDefault ? 1 : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDefaultWorkflow() {
        return this.defaultWorkflow;
    }

    public boolean isSystem() {
        return this.system;
    }

    public List<String> getIssueTypes() {
        return this.issueTypes;
    }

    public boolean isJiraDefault() {
        return this.jiraDefault;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

