/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.projectconfig.framework.rest.beans;

import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleProject;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize
public class SharedByData {
    private List<SimpleProject> sharedWithProjects;
    private List<String> sharedWithIssueTypes;
    private long totalProjectsCount;

    public SharedByData() {
    }

    public SharedByData(List<SimpleProject> allowedProjects, List<String> issueTypes, long totalProjectsCount) {
        this.sharedWithProjects = allowedProjects;
        this.sharedWithIssueTypes = issueTypes;
        this.totalProjectsCount = totalProjectsCount;
    }

    public SharedByData(List<SimpleProject> allowedProjects, List<String> issueTypes) {
        this(allowedProjects, issueTypes, allowedProjects.size());
    }

    public SharedByData(List<SimpleProject> projects, long totalProjectsCount) {
        this(projects, Collections.emptyList(), totalProjectsCount);
    }

    public SharedByData(List<SimpleProject> projects) {
        this(projects, projects.size());
    }

    public List<SimpleProject> getSharedWithProjects() {
        return this.sharedWithProjects;
    }

    public List<String> getSharedWithIssueTypes() {
        return this.sharedWithIssueTypes;
    }

    public long getHiddenProjectsCount() {
        return this.totalProjectsCount - (long)this.sharedWithProjects.size();
    }

    public long getTotalProjectsCount() {
        return this.totalProjectsCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedByData that = (SharedByData)o;
        return this.totalProjectsCount == that.totalProjectsCount && Objects.equals(this.sharedWithProjects, that.sharedWithProjects) && Objects.equals(this.sharedWithIssueTypes, that.sharedWithIssueTypes);
    }

    public int hashCode() {
        return Objects.hash(this.sharedWithProjects, this.sharedWithIssueTypes, this.totalProjectsCount);
    }
}

