/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.projectconfig.framework.rest.beans;

import com.atlassian.jira.user.ApplicationUser;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.atlassian.fugue.Option;
import java.util.List;

public class UserResponse {
    @JsonProperty
    private String name;
    @JsonProperty
    private String emailAddress;
    @JsonProperty
    private String avatarUrl;
    @JsonProperty
    private String lastSession;
    @JsonProperty
    private String displayName;
    @JsonProperty
    private boolean active;
    @JsonProperty
    private String key;
    @JsonProperty
    private List<String> applicationRoleNames;

    public UserResponse(String key, String name, String displayName, String emailAddress, boolean active, String avatarUrl, String lastSession, List<String> applicationRoleNames) {
        this.key = key;
        this.name = name;
        this.displayName = displayName;
        this.emailAddress = emailAddress;
        this.active = active;
        this.avatarUrl = avatarUrl;
        this.lastSession = lastSession;
        this.applicationRoleNames = applicationRoleNames;
    }

    private UserResponse() {
    }

    public String getName() {
        return this.name;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public String getLastSession() {
        return this.lastSession;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getFormattedDate() {
        return this.lastSession;
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getApplicationRoleNames() {
        return this.applicationRoleNames;
    }

    public static UserResponse fromApplicationUser(ApplicationUser user, String avatarUrl, Option<String> lastSession, boolean isEmailVisible, List<String> applicationRoleNames) {
        String emailAddress = null;
        if (isEmailVisible) {
            emailAddress = user.getEmailAddress();
        }
        return new UserResponse(user.getKey(), user.getName(), user.getDisplayName(), emailAddress, user.isActive(), avatarUrl, (String)lastSession.getOrNull(), applicationRoleNames);
    }
}

