/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.quicksearch;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.QuicksearchControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
public class TestProductSearchResource
extends BaseJiraFuncTest {
    @Before
    public void setup() {
        this.backdoor.project().addProject("Project", "PROJ", "admin");
    }

    @Test
    public void testSearchEmptyInstance() {
        List<QuicksearchControl.SearchResultItem> result = this.backdoor.quicksearch().search("").issues();
        Assert.assertThat(result, (Matcher)Matchers.empty());
    }

    @Test
    public void testSearchSingleIssue() {
        this.backdoor.issues().createIssue("PROJ", "my issue");
        List<QuicksearchControl.SearchResultItem> result = this.backdoor.quicksearch().search("issue").issues();
        Assert.assertThat(result, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result, (Matcher)Matchers.hasItem((Matcher)new SearchResultTitleMatcher("my issue")));
    }

    @Test
    public void testSearchProject() {
        this.verifyProjects("Pro", "Project (PROJ)");
        this.verifyProjects("Project", "Project (PROJ)");
    }

    @Test
    public void testSearchProjectSkipArchived() {
        this.backdoor.license().set(LicenseKeys.COMMERCIAL_FOR_ARCHIVING);
        this.backdoor.project().archiveProject("PROJ");
        this.verifyProjects("Pro", new String[0]);
        this.verifyProjects("Project", new String[0]);
        this.backdoor.project().restoreProject("PROJ");
        this.verifyProjects("Pro", "Project (PROJ)");
        this.verifyProjects("Project", "Project (PROJ)");
    }

    private void verifyProjects(String query, String ... expected) {
        List<QuicksearchControl.SearchResultItem> result = this.backdoor.quicksearch().search(query).projects();
        Assert.assertThat(result, (Matcher)Matchers.hasSize((int)expected.length));
        Assert.assertThat(result, (Matcher)Matchers.allOf((Iterable)Stream.of(expected).map(item -> Matchers.hasItem((Matcher)new SearchResultTitleMatcher((String)item))).collect(Collectors.toList())));
    }

    private static class SearchResultTitleMatcher
    extends TypeSafeMatcher<QuicksearchControl.SearchResultItem> {
        private final String expected;

        SearchResultTitleMatcher(String expected) {
            this.expected = expected;
        }

        protected boolean matchesSafely(QuicksearchControl.SearchResultItem item) {
            return Objects.equals(item.title, this.expected);
        }

        public void describeTo(Description description) {
            description.appendText(this.expected);
        }
    }
}

