/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.render;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BackdoorModule;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.rules.FeatureFlagRule;
import com.atlassian.jira.webtests.util.BidiUtils;
import com.atlassian.jira.webtests.ztests.render.ContentToRender;
import com.atlassian.jira.webtests.ztests.render.RenderersClient;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreOnce(value="TestAssignToMe.xml")
@LoginAs(user="admin")
public class TestRenderingResources
extends BaseJiraRestTest {
    private static final FeatureFlag VARIABLE_FORMAT_FEATURE_FLAG = FeatureFlag.featureFlag((String)"jira.renderer.consider.variable.format");
    @Rule
    public TestRule featureRule = new FeatureFlagRule(new BackdoorModule().getBackdoor().getTestkit(), (Collection)ImmutableSet.of((Object)VARIABLE_FORMAT_FEATURE_FLAG));
    private RenderersClient renderersClient;

    @Before
    public void setUp() {
        this.renderersClient = new RenderersClient(this.getEnvironmentData());
    }

    @Test
    public void testRenderingWithContentVariableFormatEnabled() {
        ParsedResponse render = this.renderersClient.render(ContentToRender.fromWikiMarkup("${noformat} Some format ${noformat}", "MKY-1"));
        Assertions.assertThat((int)render.statusCode).isEqualTo(200).withFailMessage("Except OK result but errors : " + render.entity, new Object[0]);
        ((ObjectAssert)Assertions.assertThat((Object)render.body).isEqualTo((Object)"<p>${noformat} Some format ${noformat}</p>")).withFailMessage("Expected html body", new Object[0]);
    }

    @Test
    public void testRenderingWithContentVariableFormatDisabled() {
        this.backdoor.darkFeatures().disableForSite(VARIABLE_FORMAT_FEATURE_FLAG);
        ParsedResponse render = this.renderersClient.render(ContentToRender.fromWikiMarkup("${noformat} Some format ${noformat}", "MKY-1"));
        Assertions.assertThat((int)render.statusCode).isEqualTo(200).withFailMessage("Expected status OK, but instead got: " + render.entity, new Object[0]);
        ((ObjectAssert)Assertions.assertThat((Object)render.body).isEqualTo((Object)"<p>$</p>\n<div class=\"preformatted panel\" style=\"border-width: 1px;\"><div class=\"preformattedContent panelContent\">\n<pre> Some format $</pre>\n</div></div>")).withFailMessage("Expected html body", new Object[0]);
    }

    @Test
    public void testRenderingNoFormatMacro() {
        ParsedResponse render = this.renderersClient.render(ContentToRender.fromWikiMarkup("{noformat} Some format {noformat}", "MKY-1"));
        Assertions.assertThat((int)render.statusCode).isEqualTo(200).withFailMessage("Expected status OK, but instead got: " + render.entity, new Object[0]);
        ((ObjectAssert)Assertions.assertThat((Object)render.body).isEqualTo((Object)"<div class=\"preformatted panel\" style=\"border-width: 1px;\"><div class=\"preformattedContent panelContent\">\n<pre> Some format </pre>\n</div></div>")).withFailMessage("Expected html body", new Object[0]);
    }

    @Test
    public void testBidiEscaping() {
        this.backdoor.darkFeatures().enableForSite(BidiUtils.BIDI_ESCAPING);
        String content = String.format("{code}%1$s{code}{noformat}%1$s{noformat}", BidiUtils.getBidis());
        ParsedResponse result = this.renderersClient.render(ContentToRender.fromWikiMarkup(content, "MKY-1"));
        Assertions.assertThat((int)result.statusCode).isEqualTo(200).withFailMessage("Expected status OK, but instead got: " + result.entity, new Object[0]);
        ((ObjectAssert)Assertions.assertThat((Object)result.body).isEqualTo((Object)(BidiUtils.getCodePanelWithEscapedBidis() + BidiUtils.getNoFormatPanelWithEscapedBidis()))).withFailMessage("Expected html body", new Object[0]);
    }

    @Test
    public void testBidiNotEscaped() {
        this.backdoor.darkFeatures().disableForSite(BidiUtils.BIDI_ESCAPING);
        String content = String.format("{code}%1$s{code}{noformat}%1$s{noformat}", BidiUtils.getBidis());
        ParsedResponse result = this.renderersClient.render(ContentToRender.fromWikiMarkup(content, "MKY-1"));
        Assertions.assertThat((int)result.statusCode).isEqualTo(200).withFailMessage("Expected status OK, but instead got: " + result.entity, new Object[0]);
        ((ObjectAssert)Assertions.assertThat((Object)result.body).isEqualTo((Object)(BidiUtils.getCodePanelWithUnescapedBidis() + BidiUtils.getNoFormatPanelWithUnescapedBidis()))).withFailMessage("Expected html body", new Object[0]);
    }
}

