/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
@LoginAs(user="admin")
public class TestRedirectAfterLogin
extends BaseJiraFuncTest {
    private String context;
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        String xsrfTokenValue = this.page.getXsrfToken();
        this.navigation.logout();
        String expectedLogoutPage = "/secure/Logout!default.jspa?atl_token=" + xsrfTokenValue;
        Assert.assertTrue((boolean)this.getCurrentUrl().endsWith(expectedLogoutPage));
        this.context = this.getCurrentUrl().substring(0, this.getCurrentUrl().length() - expectedLogoutPage.length());
    }

    @Test
    public void testRedirectWithRelativeUrl() throws Exception {
        this.tester.gotoPage("login.jsp?os_destination=%2Fsecure%2Fadmin%2Fuser%2FUserBrowser.jspa");
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        Assert.assertEquals((Object)(this.context + "/secure/admin/user/UserBrowser.jspa"), (Object)this.getCurrentUrl());
        this.tester.assertTextPresent("Filter users");
    }

    @Test
    public void testRedirectWithAbsoluteUrlSameContext() throws Exception {
        String absoluteUrl = this.context + "/secure/admin/user/UserBrowser.jspa";
        this.tester.gotoPage("login.jsp?os_destination=" + URLEncoder.encode(absoluteUrl, System.getProperty("file.encoding")));
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        Assert.assertEquals((Object)(this.context + "/secure/admin/user/UserBrowser.jspa"), (Object)this.getCurrentUrl());
        this.tester.assertTextPresent("Filter users");
    }

    @Test
    public void testRedirectWithAbsoluteUrlDifferentContext() throws Exception {
        String absoluteUrl = "http://www.atlassian.com";
        this.tester.gotoPage("login.jsp?os_destination=" + URLEncoder.encode(absoluteUrl, System.getProperty("file.encoding")));
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        Assert.assertEquals((Object)(this.context + "/"), (Object)this.getCurrentUrl());
        this.tester.assertTextPresent("jWebTest JIRA installation");
    }

    @Test
    public void testRedirectWithHeaderInjectionCRLF() throws Exception {
        this._testRedirectWithHeaderInjection("\r\n");
    }

    @Test
    public void testRedirectWithHeaderInjectionCR() throws Exception {
        this._testRedirectWithHeaderInjection("\r");
    }

    @Test
    public void testRedirectWithHeaderInjectionLF() throws Exception {
        this._testRedirectWithHeaderInjection("\n");
    }

    private void _testRedirectWithHeaderInjection(String newlineChars) throws UnsupportedEncodingException {
        this.tester.gotoPage("login.jsp?os_destination=%2Fsecure%2Fadmin%2Fuser%2FUserBrowser.jspa" + URLEncoder.encode(newlineChars + "http://www.atlassian.com", System.getProperty("file.encoding")));
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        Assert.assertEquals((Object)(this.context + "/"), (Object)this.getCurrentUrl());
        this.tester.assertTextPresent("jWebTest JIRA installation");
    }

    private String getCurrentUrl() {
        return this.tester.getDialog().getWebClient().getCurrentPage().getURL().toString();
    }
}

