/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.page.Error404;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
@LoginAs(user="admin")
public class TestWebActionResolution
extends BaseJiraFuncTest {
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testFullyQualifiedClassNameInUrlCanNotBeResolvedToAnAction() throws Exception {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        this.tester.gotoPage("com.atlassian.jira.web.action.user.ViewUserIssueColumns.jspa");
        Assert.assertFalse((boolean)this.tester.getDialog().getResponse().getText().contains("securitybreach"));
        Assert.assertThat((Object)new Error404(this.tester), Error404.isOn404Page());
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
    }

    @Test
    public void testCanResolveARootActionGivenThatNoExplicitAliasHasBeenDefinedForIt() throws Exception {
        this.tester.gotoPage("Dashboard.jspa");
        Assert.assertTrue((boolean)this.locator.id("dashboard").exists());
    }

    @Test
    public void testCanResolveACommandActionGivenAnAliasHasBeenDefinedForIt() throws Exception {
        this.navigation.login("admin");
        this.tester.gotoPage("AddNewWorkflow.jspa");
        Assert.assertTrue((boolean)this.locator.id("add-workflow").exists());
    }

    @Test
    public void testCanNotResolveARootActionGivenThatTheUserDoesNotHaveTheRolesRequiredForIt() throws Exception {
        this.navigation.login("fred");
        this.tester.gotoPage("ImportWorkflowFromXml!default.jspa");
        Assert.assertTrue((boolean)this.locator.id("login-form").exists());
    }

    @Test
    public void testCanNotResolveACommandActionGivenThatTheUserDoesNotHaveTheRolesRequiredForItByInheritance() throws Exception {
        this.navigation.login("fred");
        this.tester.gotoPage("IssueLinkingActivate.jspa?atl_token=" + this.page.getFreshXsrfToken());
        Assert.assertTrue((boolean)this.locator.id("login-form").exists());
    }

    private static class ViewUserIssueColumnsAction {
        private ViewUserIssueColumnsAction() {
        }

        private static class Views {
            public static final String SECURITY_BREACH = "securitybreach";

            private Views() {
            }
        }
    }
}

