/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security.xsrf;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SkipCacheCheck;
import com.atlassian.jira.webtests.LicenseKeys;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SETUP, Category.SECURITY})
@LoginAs(user="admin")
@SkipCacheCheck
public class TestXsrfJiraSetup
extends BaseJiraFuncTest {
    private static final String CONFIGURE_APP_PROPERTIES = "Set up application properties";
    private static final String SET_UP_LICENSE = "Specify your license key";
    private static final String SET_UP_ADMIN_ACCOUNT = "Set up administrator account";
    private static final String SET_UP_EMAIL_NOTIFICATIONS = "Set up email notifications";
    private static final String NEXT = "next";
    private static final String FINISH = "finish";
    @Inject
    private Form form;
    @Inject
    private Administration administration;

    @Test
    public void testJiraSetup() throws Exception {
        this.restoreNotSetupInstance();
        new XsrfTestSuite(new XsrfCheck(CONFIGURE_APP_PROPERTIES, () -> {
            this.gotoSetUpApplicationProperties();
            this.fillConfigureApplicationPropertiesForm();
        }, new XsrfCheck.FormSubmission(NEXT)), new XsrfCheck(SET_UP_LICENSE, () -> {
            this.doConfigureApplicationProperties();
            this.fillSetupLicenseForm();
        }, new XsrfCheck.FormSubmission(NEXT)), new XsrfCheck(SET_UP_ADMIN_ACCOUNT, () -> {
            this.doConfigureApplicationProperties();
            this.doSetupLicense();
            this.fillSetupAdminAccountForm();
        }, new XsrfCheck.FormSubmission(NEXT)), new XsrfCheck(SET_UP_EMAIL_NOTIFICATIONS, () -> {
            this.doConfigureApplicationProperties();
            this.doSetupLicense();
        }, new XsrfCheck.FormSubmission(FINISH))).run(this.tester, this.navigation, this.form);
    }

    private void restoreNotSetupInstance() {
        this.administration.restoreNotSetupInstance();
    }

    private void gotoSetUpApplicationProperties() {
        this.tester.gotoPage("secure/SetupApplicationProperties!default.jspa");
    }

    private void doConfigureApplicationProperties() {
        this.gotoSetUpApplicationProperties();
        this.fillConfigureApplicationPropertiesForm();
        this.tester.submit();
    }

    private void fillConfigureApplicationPropertiesForm() {
        this.tester.assertTextPresent(CONFIGURE_APP_PROPERTIES);
        this.tester.setWorkingForm("jira-setupwizard");
        this.tester.setFormElement("title", "TestXsrfJiraSetup");
    }

    private void doSetupLicense() {
        this.fillSetupLicenseForm();
        this.tester.submit();
    }

    private void fillSetupLicenseForm() {
        this.tester.assertTextPresent(SET_UP_LICENSE);
        this.tester.setWorkingForm("setupLicenseForm");
        this.tester.setFormElement("setupLicenseKey", LicenseKeys.COMMERCIAL_DC.getLicenseString());
    }

    private void fillSetupAdminAccountForm() {
        this.tester.assertTextPresent(SET_UP_ADMIN_ACCOUNT);
        this.tester.setFormElement("fullname", "Administrator");
        this.tester.setFormElement("email", "admin@stuff.com.com");
        this.tester.setFormElement("username", "admin");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
    }
}

