/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security.xsrf;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebResponse;
import java.net.URL;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestXsrfLogOut
extends BaseJiraFuncTest {
    private static final String LOG_OUT_LINK_ID = "log_out";
    @Inject
    private Form form;
    @Inject
    private HtmlPage page;

    @Test
    public void testXsrfLogoutFromSeraph() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Log Out XSRF Protection Test - Seraph", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfLogOut.this.navigation.gotoDashboard();
            }
        }, new XsrfCheck.LinkWithIdSubmission(LOG_OUT_LINK_ID){

            @Override
            public String getLink() throws Exception {
                String baseLink = super.getLink();
                String finalLink = baseLink.replaceFirst(TestXsrfLogOut.this.getEnvironmentData().getContext(), "");
                return finalLink;
            }
        })).run(this.tester, this.navigation, this.form, "Confirm logout");
    }

    @Test
    public void testXsrfLogoutFromSeraphWithAnExpiredSession() throws Exception {
        this.navigation.gotoDashboard();
        this.tester.getDialog().getWebClient().clearCookies();
        this.tester.clickLink(LOG_OUT_LINK_ID);
        this.tester.getDialog().getResponse();
        this.tester.assertTextPresent("You have already been logged out of Jira");
    }

    @Test
    public void testXsrfLogoutFromSeraphWithAnExpiredSessionAndWrongReferer() throws SAXException {
        this.navigation.gotoDashboard();
        this.tester.getDialog().getWebClient().clearCookies();
        String logOutUrl = this.tester.getDialog().getResponse().getLinkWithID(LOG_OUT_LINK_ID).getURLString();
        logOutUrl = logOutUrl.replaceFirst(this.getEnvironmentData().getContext(), "");
        logOutUrl = logOutUrl.replace("atl_token=", "atl_token=invalid");
        this.tester.getTestContext().getWebClient().setHeaderField("Referer", "http://invalid.com");
        this.tester.gotoPage(logOutUrl);
        this.tester.getDialog().getResponse();
        this.tester.assertTextPresent("Forbidden (403)");
    }

    @Test
    public void testXsrfLogOutFromSeraphConfirmsLogOutWhenRememberMeIsOn() throws Exception {
        this.navigation.logout();
        this.navigation.login("admin", "admin", true);
        new XsrfTestSuite(new XsrfCheck("Log Out XSRF Protection Test - Seraph", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfLogOut.this.navigation.gotoDashboard();
            }
        }, new XsrfCheck.LinkWithIdSubmission(LOG_OUT_LINK_ID){

            @Override
            public String getLink() throws Exception {
                String baseLink = super.getLink();
                String finalLink = baseLink.replaceFirst(TestXsrfLogOut.this.getEnvironmentData().getContext(), "");
                return finalLink;
            }
        })).run(this.tester, this.navigation, this.form, "Confirm logout");
    }

    @Test
    public void testXsrfLogoutFromActionViaDefaultCommand() throws Exception {
        String tokenValue = this.page.getXsrfToken();
        new XsrfTestSuite(new XsrfCheck("Log Out XSRF Protection Test - Default Action", new XsrfCheck.Setup.None(), new UrlSubmission(new URL(this.getEnvironmentData().getBaseUrl() + "/Logout!default.jspa?" + "atl_token" + "=" + tokenValue)))).run(this.tester, this.navigation, this.form, "Confirm logout");
    }

    @Test
    public void testXsrfLogoutFromActionViaDefaultCommandWithAnExpiredSession() throws Exception {
        this.navigation.gotoDashboard();
        this.tester.getDialog().getWebClient().clearCookies();
        this.tester.getTestContext().getWebClient().setHeaderField("Referer", this.tester.getTestContext().getBaseUrl());
        String tokenValue = this.page.getXsrfToken();
        this.tester.gotoPage("/Logout!default.jspa?atl_token=" + tokenValue);
        this.tester.getDialog().getResponse();
        this.tester.assertTextPresent("You have already been logged out of Jira");
    }

    @Test
    public void testXsrfLogoutFromActionViaDefaultCommandWithAnExpiredSessionAndWrongReferer() {
        this.navigation.gotoDashboard();
        this.tester.getDialog().getWebClient().clearCookies();
        this.tester.getTestContext().getWebClient().setHeaderField("Referer", "http://example.com");
        String tokenValue = this.page.getXsrfToken();
        this.tester.gotoPage("/Logout!default.jspa?atl_token=" + tokenValue);
        this.tester.getDialog().getResponse();
        this.tester.assertTextPresent("HTTPError403");
    }

    @Test
    public void testXsrfLogoutFromActionViaDefaultCommandWhenRememberMeIsOn() throws Exception {
        this.navigation.logout();
        this.navigation.login("admin", "admin", true);
        String tokenValue = this.page.getXsrfToken();
        new XsrfTestSuite(new XsrfCheck("Log Out XSRF Protection Test - Default Action", new XsrfCheck.Setup.None(), new UrlSubmission(new URL(this.getEnvironmentData().getBaseUrl() + "/Logout!default.jspa?" + "atl_token" + "=" + tokenValue)))).run(this.tester, this.navigation, this.form, "Confirm logout");
    }

    @Test
    public void testXsrfLogoutFromActionViaExecuteCommand() throws Exception {
        String tokenValue = this.page.getXsrfToken();
        new XsrfTestSuite(new XsrfCheck("Log Out XSRF Protection Test - Action", new XsrfCheck.Setup.None(), new UrlSubmission(new URL(this.getEnvironmentData().getBaseUrl() + "/Logout.jspa?" + "atl_token" + "=" + tokenValue)))).run(this.tester, this.navigation, this.form, "Confirm logout");
    }

    @Test
    public void testXsrfLogoutFromActionViaExecuteCommandWithAnExpiredSession() throws Exception {
        this.navigation.gotoDashboard();
        this.tester.getDialog().getWebClient().clearCookies();
        this.tester.getTestContext().getWebClient().setHeaderField("Referer", this.tester.getTestContext().getBaseUrl());
        String tokenValue = this.page.getXsrfToken();
        this.tester.gotoPage("/Logout.jspa?atl_token=" + tokenValue);
        this.tester.getDialog().getResponse();
        this.tester.assertTextPresent("You have already been logged out of Jira");
    }

    @Test
    public void testXsrfLogoutFromActionViaExecuteCommandWithAnExpiredSessionAndWrongReferer() {
        this.navigation.gotoDashboard();
        this.tester.getDialog().getWebClient().clearCookies();
        this.tester.getTestContext().getWebClient().setHeaderField("Referer", "http://example.com");
        String tokenValue = this.page.getXsrfToken();
        this.tester.gotoPage("/Logout.jspa?atl_token=" + tokenValue);
        this.tester.getDialog().getResponse();
        this.tester.assertTextPresent("HTTPError403");
    }

    @Test
    public void testXsrfLogoutFromActionViaExecuteCommandWhenRememberMeIsOn() throws Exception {
        this.navigation.logout();
        this.navigation.login("admin", "admin", true);
        String tokenValue = this.page.getXsrfToken();
        new XsrfTestSuite(new XsrfCheck("Log Out XSRF Protection Test - Action", new XsrfCheck.Setup.None(), new UrlSubmission(new URL(this.getEnvironmentData().getBaseUrl() + "/Logout.jspa?" + "atl_token" + "=" + tokenValue)))).run(this.tester, this.navigation, this.form, "Confirm logout");
    }

    private final class UrlSubmission
    implements XsrfCheck.Submission {
        private final URL originalUrl;
        private WebTester tester;
        private URL urlToSubmit;

        private UrlSubmission(URL originalUrl) {
            String queryString = originalUrl.getQuery();
            String xsrfTokenParameterRegex = ".*?atl_token=.*?";
            if (!Pattern.matches(".*?atl_token=.*?", queryString)) {
                throw new IllegalArgumentException("The URL must contain a XSRF Token parameter");
            }
            this.originalUrl = originalUrl;
            this.urlToSubmit = originalUrl;
        }

        @Override
        public void init(WebTester tester, Navigation navigation, Form form) {
            this.tester = tester;
            this.resetReferer();
        }

        @Override
        public void removeToken() throws Exception {
            String invalidTokenInUrlString = XsrfCheck.invalidTokenInUrl(this.originalUrl.toString());
            this.urlToSubmit = new URL(invalidTokenInUrlString);
        }

        @Override
        public void submitRequest() throws Exception {
            this.tester.gotoPage(this.urlToSubmit.toString());
            this.resetUrlToSubmit();
        }

        @Override
        public WebResponse submitRequest(String referer) throws Exception {
            this.setReferer(referer);
            this.submitRequest();
            this.resetReferer();
            return this.tester.getDialog().getResponse();
        }

        private void setReferer(String url) {
            this.tester.getTestContext().getWebClient().setHeaderField("Referer", url);
        }

        private void resetReferer() {
            this.setReferer(this.tester.getTestContext().getBaseUrl());
        }

        private void resetUrlToSubmit() {
            this.urlToSubmit = this.originalUrl;
        }
    }
}

