/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security.xsrf;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
@RestoreBlankInstance
public class TestXsrfSessionBoundToken
extends BaseJiraFuncTest {
    private final HttpClient client = new HttpClient();
    private static final String HEADER = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.13; rv:70.0) Gecko/20100101 Firefox/70.0";
    private static final String DASHBOARD_URI = "/secure/Dashboard.jspa";
    private static final String XSRF_TOKEN_KEY = "atlassian.xsrf.token";
    private static final String JSESSIONID = "JSESSIONID";

    @Test
    public void testRequestToRestEndpointAsUnknownBrowserShouldNotReturnSessionCookie() throws IOException, URISyntaxException {
        String requestURI = this.requestURI("/rest/gadgets/1.0/g/feed").toString();
        GetMethod getRequest = new GetMethod(requestURI);
        getRequest.setRequestHeader("User-Agent", "Random-Unknown-Browser");
        int statusCode = this.client.executeMethod((HttpMethod)getRequest);
        Assert.assertEquals((long)200L, (long)statusCode);
        Header accessControlResponseHeader = getRequest.getResponseHeader("Set-Cookie");
        Assert.assertThat((Object)accessControlResponseHeader.getValue(), (Matcher)Matchers.containsString((String)XSRF_TOKEN_KEY));
        Assert.assertThat((Object)accessControlResponseHeader.getValue(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)JSESSIONID)));
    }

    private URI requestURI(String resourceURI) throws URISyntaxException {
        URI jiraURI = this.environmentData.getBaseUrl().toURI();
        return UriBuilder.fromUri((URI)jiraURI).path(resourceURI).build(new Object[0]);
    }

    @Test
    public void testRequestToRestEndpointAsKnownBrowserShouldNotReturnSessionCookie() throws IOException, URISyntaxException {
        String requestURI = this.requestURI("/rest/gadgets/1.0/g/feed").toString();
        GetMethod getRequest = new GetMethod(requestURI);
        getRequest.setRequestHeader("User-Agent", HEADER);
        int statusCode = this.client.executeMethod((HttpMethod)getRequest);
        Assert.assertEquals((long)200L, (long)statusCode);
        Header accessControlResponseHeader = getRequest.getResponseHeader("Set-Cookie");
        Assert.assertThat((Object)accessControlResponseHeader.getValue(), (Matcher)Matchers.containsString((String)XSRF_TOKEN_KEY));
        Assert.assertThat((Object)accessControlResponseHeader.getValue(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)JSESSIONID)));
    }

    @Test
    public void testRequestToWebworkEndpointShouldReturnSessionCookie() throws IOException, URISyntaxException {
        String requestURI = this.requestURI(DASHBOARD_URI).toString();
        GetMethod getRequest = new GetMethod(requestURI);
        getRequest.setRequestHeader("User-Agent", HEADER);
        int statusCode = this.client.executeMethod((HttpMethod)getRequest);
        Assert.assertEquals((long)200L, (long)statusCode);
        Header accessControlResponseHeader = getRequest.getResponseHeader("Set-Cookie");
        Assert.assertThat((Object)accessControlResponseHeader.getValue(), (Matcher)Matchers.containsString((String)XSRF_TOKEN_KEY));
        Assert.assertThat((Object)accessControlResponseHeader.getValue(), (Matcher)Matchers.containsString((String)JSESSIONID));
    }
}

